/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.debug.api.emulation.EmulatorFactory;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.exec.trace.TraceEmulationIntegration;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.time.schedule.Scheduler;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

@ServiceInfo(defaultProviderName="ghidra.app.plugin.core.debug.service.emulation.DebuggerEmulationServicePlugin")
public interface DebuggerEmulationService {
    public Collection<EmulatorFactory> getEmulatorFactories();

    public void setEmulatorFactory(EmulatorFactory var1);

    public EmulatorFactory getEmulatorFactory();

    public Trace launchProgram(Program var1, Address var2) throws IOException;

    public long emulate(TracePlatform var1, TraceSchedule var2, TaskMonitor var3) throws CancelledException;

    default public long emulate(Trace trace, TraceSchedule time, TaskMonitor monitor) throws CancelledException {
        return this.emulate(trace.getPlatformManager().getHostPlatform(), time, monitor);
    }

    public EmulationResult run(TracePlatform var1, TraceSchedule var2, TaskMonitor var3, Scheduler var4) throws CancelledException;

    public CompletableFuture<Long> backgroundEmulate(TracePlatform var1, TraceSchedule var2);

    public CompletableFuture<EmulationResult> backgroundRun(TracePlatform var1, TraceSchedule var2, Scheduler var3);

    public PcodeMachine<?> getCachedEmulator(Trace var1, TraceSchedule var2);

    public Collection<CachedEmulator> getBusyEmulators();

    public void invalidateCache();

    public void addStateListener(EmulatorStateListener var1);

    public void removeStateListener(EmulatorStateListener var1);

    public static interface EmulatorStateListener {
        default public void running(CachedEmulator emu) {
        }

        default public void stopped(CachedEmulator emu) {
        }
    }

    public record CachedEmulator(Trace trace, PcodeMachine<?> emulator, TraceEmulationIntegration.Writer writer, long version) {
        public CachedEmulator(Trace trace, PcodeMachine<?> emulator, TraceEmulationIntegration.Writer writer) {
            this(trace, emulator, writer, trace.getEmulatorCacheVersion());
        }

        public boolean isValid() {
            return this.version >= this.trace.getEmulatorCacheVersion();
        }
    }

    public record RecordEmulationResult(TraceSchedule schedule, long snapshot, Throwable error) implements EmulationResult
    {
    }

    public static interface EmulationResult
    extends Scheduler.RunResult {
        public long snapshot();
    }
}

