/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Locator;
import io.sf.carte.doc.style.css.nsac.PageSelectorList;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSParentHandler;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.CounterStyleRule;
import io.sf.carte.doc.style.css.om.FontFaceRule;
import io.sf.carte.doc.style.css.om.FontFeatureValuesRule;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.om.ImportRule;
import io.sf.carte.doc.style.css.om.KeyframeRule;
import io.sf.carte.doc.style.css.om.KeyframesRule;
import io.sf.carte.doc.style.css.om.MarginRule;
import io.sf.carte.doc.style.css.om.MediaRule;
import io.sf.carte.doc.style.css.om.NamespaceRule;
import io.sf.carte.doc.style.css.om.PageRule;
import io.sf.carte.doc.style.css.om.PropertyRule;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.om.SupportsRule;
import io.sf.carte.doc.style.css.om.UnknownRule;
import io.sf.carte.doc.style.css.om.ViewportRule;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import java.util.LinkedList;
import org.w3c.dom.DOMException;

class SheetHandler
implements CSSParentHandler,
CSSErrorHandler,
Parser.NamespaceMap {
    private ParserControl parserctl = null;
    private final BaseCSSStyleSheet parentSheet;
    private AbstractCSSRule currentRule = null;
    private AbstractCSSRule lastRule = null;
    private final byte sheetOrigin;
    private final LinkedList<String> comments;
    private final boolean allCommentsPrecede;
    private short ignoreGroupingRules = 0;
    private boolean ignoreImports = false;
    private CSSParseException outOfRuleException = null;

    SheetHandler(BaseCSSStyleSheet baseCSSStyleSheet, byte by, short s) {
        this.parentSheet = baseCSSStyleSheet;
        this.sheetOrigin = by;
        this.comments = s != 0 ? new LinkedList() : null;
        this.allCommentsPrecede = s != 2;
    }

    @Override
    public void parseStart(ParserControl parserControl) {
        this.currentRule = null;
        this.parserctl = parserControl;
        this.ignoreGroupingRules = 0;
        this.ignoreImports = false;
        this.resetCommentStack();
    }

    @Override
    public void endOfStream() {
        this.resetCommentStack();
        this.parserctl = null;
    }

    @Override
    public void comment(String string, boolean bl) {
        if (this.comments != null) {
            if (this.lastRule != null && !bl && !this.allCommentsPrecede) {
                BaseCSSRule baseCSSRule = (BaseCSSRule)this.lastRule;
                if (baseCSSRule.getTrailingComments() == null) {
                    baseCSSRule.setTrailingComments(new LinkedStringList());
                }
                baseCSSRule.getTrailingComments().add(string);
            } else {
                this.comments.add(string);
            }
        }
    }

    @Override
    public void ignorableAtRule(String string) {
        int n = string.length();
        if (n > 21) {
            n = 21;
        }
        this.newRule();
        UnknownRule unknownRule = this.parentSheet.createUnknownRule();
        if (string.charAt(1) != '-') {
            this.parentSheet.getErrorHandler().unknownRule(string);
        }
        try {
            unknownRule.setRuleCssText(string);
        }
        catch (DOMException dOMException) {
            this.parentSheet.getErrorHandler().badAtRule(dOMException, string);
            return;
        }
        this.setCommentsToRule(unknownRule);
        if (this.currentRule != null) {
            this.addToCurrentRule(unknownRule);
        } else {
            this.addLocalRule(unknownRule);
            this.resetCurrentRule();
        }
        this.lastRule = unknownRule;
    }

    private void newRule() {
        this.lastRule = null;
    }

    protected void addLocalRule(AbstractCSSRule abstractCSSRule) {
        this.parentSheet.addLocalRule(abstractCSSRule);
    }

    private void addToCurrentRule(AbstractCSSRule abstractCSSRule) {
        try {
            ((GroupingRule)this.currentRule).addRule(abstractCSSRule);
        }
        catch (ClassCastException classCastException) {
            DOMException dOMException = new DOMException(12, "Found @-rule inside a non-grouping rule of type: " + this.currentRule.getType());
            this.parentSheet.getErrorHandler().badAtRule(dOMException, abstractCSSRule.getCssText());
            this.lastRule = null;
        }
    }

    @Override
    public void namespaceDeclaration(String string, String string2) {
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            this.parentSheet.setNamespace(string, string2);
            NamespaceRule namespaceRule = this.parentSheet.createNamespaceRule(string, string2);
            if (this.currentRule != null) {
                this.addToCurrentRule(namespaceRule);
            } else {
                this.addLocalRule(namespaceRule);
            }
            this.resetCurrentRule();
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void importStyle(String string, MediaQueryList mediaQueryList, String string2) {
        if (this.ignoreImports) {
            SheetErrorHandler sheetErrorHandler = this.parentSheet.getErrorHandler();
            sheetErrorHandler.ignoredImport(string);
            this.resetCommentStack();
            return;
        }
        if (this.parentSheet.match(this.parentSheet.getMedia(), mediaQueryList)) {
            if (!mediaQueryList.isNotAllMedia()) {
                if (this.currentRule == null) {
                    ImportRule importRule = this.parentSheet.createImportRule(mediaQueryList, string);
                    this.setCommentsToRule(importRule);
                    this.addLocalRule(importRule);
                }
            } else {
                this.parentSheet.getErrorHandler().badMediaList(mediaQueryList);
            }
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void startSupports(BooleanCondition booleanCondition) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            if (this.currentRule != null) {
                short s = this.currentRule.getType();
                if (s == 4 || s == 12) {
                    SupportsRule supportsRule = new SupportsRule((AbstractCSSStyleSheet)this.parentSheet, booleanCondition, this.sheetOrigin);
                    this.addToCurrentRule(supportsRule);
                    this.currentRule = supportsRule;
                    this.setCommentsToRule(this.currentRule);
                } else {
                    SheetErrorHandler sheetErrorHandler = this.parentSheet.getErrorHandler();
                    if (sheetErrorHandler != null) {
                        sheetErrorHandler.sacMalfunction("Unexpected supports rule inside of: " + this.currentRule.getCssText());
                        this.ignoreGroupingRules = 1;
                    }
                }
            } else {
                this.currentRule = new SupportsRule((AbstractCSSStyleSheet)this.parentSheet, booleanCondition, this.sheetOrigin);
                this.setCommentsToRule(this.currentRule);
            }
        } else {
            this.ignoreGroupingRules = (short)(this.ignoreGroupingRules + 1);
        }
    }

    @Override
    public void endSupports(BooleanCondition booleanCondition) {
        this.endGroupingRule();
    }

    void endGroupingRule() {
        if (this.ignoreGroupingRules != 0) {
            this.ignoreGroupingRules = (short)(this.ignoreGroupingRules - 1);
            this.resetCommentStack();
        } else if (this.currentRule != null) {
            this.lastRule = this.currentRule;
            AbstractCSSRule abstractCSSRule = this.currentRule.getParentRule();
            if (abstractCSSRule == null) {
                this.addLocalRule(this.currentRule);
                this.resetCurrentRule();
            } else {
                this.resetCurrentRule();
                this.currentRule = abstractCSSRule;
            }
        }
    }

    @Override
    public void startMedia(MediaQueryList mediaQueryList) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            if (this.currentRule != null) {
                short s = this.currentRule.getType();
                if (s == 4 || s == 12) {
                    MediaRule mediaRule = new MediaRule((AbstractCSSStyleSheet)this.parentSheet, mediaQueryList, this.sheetOrigin);
                    this.addToCurrentRule(mediaRule);
                    this.currentRule = mediaRule;
                    this.setCommentsToRule(this.currentRule);
                } else {
                    SheetErrorHandler sheetErrorHandler = this.parentSheet.getErrorHandler();
                    if (sheetErrorHandler != null) {
                        sheetErrorHandler.sacMalfunction("Unexpected media rule inside of: " + this.currentRule.getCssText());
                        this.ignoreGroupingRules = 1;
                    }
                }
            } else {
                this.currentRule = new MediaRule((AbstractCSSStyleSheet)this.parentSheet, mediaQueryList, this.sheetOrigin);
                this.setCommentsToRule(this.currentRule);
            }
        } else {
            this.ignoreGroupingRules = (short)(this.ignoreGroupingRules + 1);
        }
    }

    @Override
    public void endMedia(MediaQueryList mediaQueryList) {
        this.endGroupingRule();
    }

    @Override
    public void startPage(PageSelectorList pageSelectorList) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            PageRule pageRule = this.parentSheet.createPageRule();
            pageRule.setParentRule(this.currentRule);
            pageRule.setSelectorList(pageSelectorList);
            this.currentRule = pageRule;
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endPage(PageSelectorList pageSelectorList) {
        this.endGenericRule();
    }

    @Override
    public void startMargin(String string) {
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            assert (this.currentRule != null && this.currentRule.getType() == 6);
            MarginRule marginRule = this.parentSheet.createMarginRule(string);
            marginRule.setParentRule(this.currentRule);
            this.currentRule = marginRule;
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endMargin() {
        if (this.ignoreGroupingRules == 0) {
            assert (this.currentRule != null && this.currentRule.getType() == 9);
            this.lastRule = this.currentRule;
            AbstractCSSRule abstractCSSRule = this.currentRule.getParentRule();
            PageRule pageRule = (PageRule)abstractCSSRule;
            pageRule.addMarginRule((MarginRule)this.currentRule);
            this.currentRule = abstractCSSRule;
        }
        this.resetCommentStack();
    }

    @Override
    public void startFontFace() {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            FontFaceRule fontFaceRule = new FontFaceRule(this.parentSheet, this.sheetOrigin);
            fontFaceRule.setParentRule(this.currentRule);
            this.currentRule = fontFaceRule;
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endFontFace() {
        this.endGenericRule();
    }

    private void endGenericRule() {
        if (this.ignoreGroupingRules == 0) {
            if (this.currentRule != null) {
                this.lastRule = this.currentRule;
                AbstractCSSRule abstractCSSRule = this.currentRule.getParentRule();
                if (abstractCSSRule == null) {
                    this.addLocalRule(this.currentRule);
                    this.resetCurrentRule();
                } else {
                    this.addCurrentRuleToRule(abstractCSSRule);
                    this.resetCommentStack();
                    this.currentRule = abstractCSSRule;
                }
            }
        } else {
            this.resetCommentStack();
        }
    }

    private void addCurrentRuleToRule(AbstractCSSRule abstractCSSRule) {
        try {
            ((GroupingRule)abstractCSSRule).addRule(this.currentRule);
        }
        catch (ClassCastException classCastException) {
            DOMException dOMException = new DOMException(12, "Found @-rule inside a non-grouping rule of type: " + abstractCSSRule.getType());
            this.parentSheet.getErrorHandler().badAtRule(dOMException, this.currentRule.getCssText());
        }
    }

    @Override
    public void startCounterStyle(String string) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            CounterStyleRule counterStyleRule = this.parentSheet.createCounterStyleRule(string);
            counterStyleRule.setParentRule(this.currentRule);
            this.currentRule = counterStyleRule;
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endCounterStyle() {
        this.endGenericRule();
    }

    @Override
    public void startKeyframes(String string) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            KeyframesRule keyframesRule = this.parentSheet.createKeyframesRule(string);
            keyframesRule.setParentRule(this.currentRule);
            this.currentRule = keyframesRule;
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endKeyframes() {
        this.endGenericRule();
    }

    @Override
    public void startKeyframe(LexicalUnit lexicalUnit) {
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            KeyframesRule keyframesRule = (KeyframesRule)this.currentRule;
            KeyframeRule keyframeRule = new KeyframeRule(keyframesRule);
            keyframeRule.setKeyText(KeyframesRule.keyframeSelector(lexicalUnit));
            keyframesRule.getCssRules().add(keyframeRule);
            this.currentRule = keyframeRule;
            this.setCommentsToRule(this.currentRule);
        }
    }

    @Override
    public void endKeyframe() {
        if (this.ignoreGroupingRules == 0) {
            assert (this.currentRule != null && this.currentRule.getType() == 8);
            this.lastRule = this.currentRule;
            this.currentRule = this.currentRule.getParentRule();
        }
        this.resetCommentStack();
    }

    @Override
    public void startFontFeatures(String[] stringArray) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            FontFeatureValuesRule fontFeatureValuesRule = this.parentSheet.createFontFeatureValuesRule(stringArray);
            fontFeatureValuesRule.setParentRule(this.currentRule);
            this.currentRule = fontFeatureValuesRule;
            this.setCommentsToRule(this.currentRule);
            CSSHandler cSSHandler = fontFeatureValuesRule.createFontFeatureValuesHandler(this, this.parserctl);
            cSSHandler.startFontFeatures(stringArray);
            this.parserctl.setDocumentHandler(cSSHandler);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endFontFeatures() {
        throw new IllegalStateException();
    }

    @Override
    public void startFeatureMap(String string) {
        throw new IllegalStateException();
    }

    @Override
    public void endFeatureMap() {
        throw new IllegalStateException();
    }

    @Override
    public void endSubHandler(short s) {
        this.parserctl.setDocumentHandler(this);
        this.endGenericRule();
    }

    @Override
    public void startProperty(String string) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            PropertyRule propertyRule = this.parentSheet.createPropertyRule(string);
            propertyRule.setParentRule(this.currentRule);
            this.currentRule = propertyRule;
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endProperty(boolean bl) {
        if (bl) {
            this.discardGenericRule();
        } else {
            this.endGenericRule();
        }
    }

    private void discardGenericRule() {
        if (this.ignoreGroupingRules == 0 && this.currentRule != null) {
            this.currentRule = this.currentRule.getParentRule();
        }
        this.resetCommentStack();
    }

    @Override
    public void startViewport() {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            ViewportRule viewportRule = this.parentSheet.createViewportRule();
            viewportRule.setParentRule(this.currentRule);
            this.currentRule = viewportRule;
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endViewport() {
        this.endGenericRule();
    }

    @Override
    public void startSelector(SelectorList selectorList) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            StyleRule styleRule = this.parentSheet.createStyleRule();
            if (this.currentRule != null) {
                styleRule.setParentRule(this.currentRule);
            }
            this.currentRule = styleRule;
            ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(selectorList);
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endSelector(SelectorList selectorList) {
        if (this.ignoreGroupingRules == 0) {
            assert (this.currentRule != null && this.currentRule.getType() == 1);
            this.lastRule = this.currentRule;
            BaseCSSRule baseCSSRule = (BaseCSSRule)this.currentRule.getParentRule();
            if (((StyleRule)this.currentRule).getStyle().getLength() == 0) {
                SheetErrorHandler sheetErrorHandler = this.parentSheet.getErrorHandler();
                sheetErrorHandler.emptyStyleRule(((StyleRule)this.currentRule).getSelectorText());
            } else if (baseCSSRule == null) {
                if (this.currentRule != null) {
                    this.addLocalRule(this.currentRule);
                }
            } else {
                ((GroupingRule)baseCSSRule).addRule(this.currentRule);
            }
            this.currentRule = baseCSSRule;
        }
        this.resetCommentStack();
    }

    @Override
    public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
        if (this.ignoreGroupingRules == 0) {
            if (this.currentRule != null) {
                try {
                    ((BaseCSSDeclarationRule)this.currentRule).getStyle().setProperty(string, lexicalUnit, bl);
                }
                catch (RuntimeException runtimeException) {
                    CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException(runtimeException);
                    cSSPropertyValueException.setValueText(lexicalUnit.toString());
                    ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().wrongValue(string, cSSPropertyValueException);
                    Locator locator = this.parserctl.createLocator();
                    CSSParseException cSSParseException = new CSSParseException("Invalid value for property " + string, locator, runtimeException);
                    this.error(cSSParseException);
                }
            } else {
                this.parentSheet.getErrorHandler().sacMalfunction("Unexpected property " + string + ": " + lexicalUnit.toString());
            }
        }
    }

    @Override
    public void lexicalProperty(String string, LexicalUnit lexicalUnit, boolean bl) {
        if (this.ignoreGroupingRules == 0) {
            if (this.currentRule != null) {
                try {
                    ((BaseCSSDeclarationRule)this.currentRule).getStyle().setLexicalProperty(string, lexicalUnit, bl);
                }
                catch (RuntimeException runtimeException) {
                    CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException(runtimeException);
                    cSSPropertyValueException.setValueText(lexicalUnit.toString());
                    ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().wrongValue(string, cSSPropertyValueException);
                    Locator locator = this.parserctl.createLocator();
                    CSSParseException cSSParseException = new CSSParseException("Invalid value for property " + string, locator, runtimeException);
                    this.error(cSSParseException);
                }
            } else {
                this.parentSheet.getErrorHandler().sacMalfunction("Unexpected property " + string + ": " + lexicalUnit.toString());
            }
        }
    }

    private void resetCurrentRule() {
        this.currentRule = null;
        this.resetCommentStack();
    }

    private void setCommentsToRule(AbstractCSSRule abstractCSSRule) {
        if (this.comments != null && !this.comments.isEmpty()) {
            LinkedStringList linkedStringList = new LinkedStringList();
            linkedStringList.addAll(this.comments);
            abstractCSSRule.setPrecedingComments(linkedStringList);
        }
        this.resetCommentStack();
    }

    private void resetCommentStack() {
        if (this.comments != null) {
            this.comments.clear();
        }
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.parentSheet.getNamespaceURI(string);
    }

    public BaseCSSStyleSheet getStyleSheet() {
        return this.parentSheet;
    }

    @Override
    public void warning(CSSParseException cSSParseException) throws CSSParseException {
        if (this.currentRule instanceof BaseCSSDeclarationRule && ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler() != null) {
            int n = -1;
            AbstractCSSStyleDeclaration abstractCSSStyleDeclaration = ((BaseCSSDeclarationRule)this.currentRule).getStyle();
            if (abstractCSSStyleDeclaration != null) {
                n = abstractCSSStyleDeclaration.getLength() - 1;
            }
            ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().sacWarning(cSSParseException, n);
        } else {
            this.parentSheet.getErrorHandler().handleSacWarning(cSSParseException);
        }
    }

    @Override
    public void error(CSSParseException cSSParseException) throws CSSParseException {
        if (this.currentRuleCanHandleError()) {
            int n = -1;
            AbstractCSSStyleDeclaration abstractCSSStyleDeclaration = ((BaseCSSDeclarationRule)this.currentRule).getStyle();
            if (abstractCSSStyleDeclaration != null) {
                n = abstractCSSStyleDeclaration.getLength() - 1;
            }
            ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().sacError(cSSParseException, n);
            this.parentSheet.getErrorHandler().mapError(cSSParseException, this.currentRule);
        } else {
            this.nonRuleErrorHandling(cSSParseException);
        }
    }

    private boolean currentRuleCanHandleError() {
        return this.currentRule instanceof BaseCSSDeclarationRule && ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler() != null;
    }

    private void nonRuleErrorHandling(CSSParseException cSSParseException) {
        this.parentSheet.getErrorHandler().handleSacError(cSSParseException);
        if (this.outOfRuleException == null) {
            this.outOfRuleException = cSSParseException;
        }
    }

    CSSParseException getOutOfRuleException() {
        return this.outOfRuleException;
    }
}

