/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import net.infonode.docking.DockingWindow;
import net.infonode.docking.View;
import net.infonode.docking.WindowTab;
import net.infonode.docking.properties.ViewTitleBarProperties;
import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabListener;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.hover.TabbedPanelTitledTabHoverAction;
import net.infonode.tabbedpanel.hover.TitledTabTabbedPanelHoverAction;
import net.infonode.tabbedpanel.titledtab.TitledTab;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;

public class TabWindowHoverAction
implements HoverListener {
    private TabbedPanelProperties tabbedPanelProperties;
    private TitledTabProperties titledTabProperties;
    private ViewTitleBarProperties viewTitleBarProperties;
    private TabbedPanelTitledTabHoverAction tpTabAction;
    private TitledTabTabbedPanelHoverAction tabTpAction;
    private boolean titleBarPropsAdded = false;
    private TabListener tabListener = new TabAdapter(){

        @Override
        public void tabSelected(TabStateChangedEvent event) {
            if (event.getTab() != null) {
                DockingWindow w = ((WindowTab)event.getTab()).getWindow();
                if (!TabWindowHoverAction.this.titleBarPropsAdded && w instanceof View) {
                    TabWindowHoverAction.this.addViewTitleBarProperties((View)w);
                }
            }
        }

        @Override
        public void tabDeselected(TabStateChangedEvent event) {
            if (event.getTab() != null) {
                DockingWindow w = ((WindowTab)event.getTab()).getWindow();
                if (TabWindowHoverAction.this.titleBarPropsAdded && w instanceof View) {
                    TabWindowHoverAction.this.removeViewTitleBarProperties((View)w);
                }
            }
        }
    };

    public TabWindowHoverAction() {
        this(new TabbedPanelProperties(), new TitledTabProperties(), new ViewTitleBarProperties());
    }

    public TabWindowHoverAction(TabbedPanelProperties tabbedPanelProperties, TitledTabProperties titledTabProperties, ViewTitleBarProperties viewTitleBarProperties) {
        this.tabbedPanelProperties = tabbedPanelProperties;
        this.titledTabProperties = titledTabProperties;
        this.viewTitleBarProperties = viewTitleBarProperties;
        this.tpTabAction = new TabbedPanelTitledTabHoverAction(tabbedPanelProperties, titledTabProperties);
        this.tabTpAction = new TitledTabTabbedPanelHoverAction(titledTabProperties, tabbedPanelProperties);
    }

    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.tabbedPanelProperties;
    }

    public TitledTabProperties getTitledTabProperties() {
        return this.titledTabProperties;
    }

    public ViewTitleBarProperties getViewTitleBarProperties() {
        return this.viewTitleBarProperties;
    }

    @Override
    public void mouseEntered(HoverEvent event) {
        if (event.getSource() instanceof TabbedPanel) {
            DockingWindow w;
            TabbedPanel tp = (TabbedPanel)event.getSource();
            tp.addTabListener(this.tabListener);
            if (tp.getSelectedTab() != null && (w = ((WindowTab)tp.getSelectedTab()).getWindow()) instanceof View) {
                this.addViewTitleBarProperties((View)w);
            }
            this.tpTabAction.mouseEntered(event);
        } else if (event.getSource() instanceof TitledTab) {
            WindowTab tab = (WindowTab)event.getSource();
            tab.addTabListener(this.tabListener);
            if (tab.isSelected() && tab.getWindow() instanceof View) {
                this.addViewTitleBarProperties((View)tab.getWindow());
            }
            this.tabTpAction.mouseEntered(event);
        }
    }

    @Override
    public void mouseExited(HoverEvent event) {
        if (event.getSource() instanceof TabbedPanel) {
            DockingWindow w;
            TabbedPanel tp = (TabbedPanel)event.getSource();
            tp.removeTabListener(this.tabListener);
            if (this.titleBarPropsAdded && tp.getSelectedTab() != null && (w = ((WindowTab)tp.getSelectedTab()).getWindow()) instanceof View) {
                this.removeViewTitleBarProperties((View)w);
            }
            this.tpTabAction.mouseExited(event);
        } else if (event.getSource() instanceof TitledTab) {
            WindowTab tab = (WindowTab)event.getSource();
            tab.removeTabListener(this.tabListener);
            if (this.titleBarPropsAdded && tab.getWindow() instanceof View) {
                this.removeViewTitleBarProperties((View)tab.getWindow());
            }
            this.tabTpAction.mouseExited(event);
        }
    }

    private void addViewTitleBarProperties(View view) {
        view.getViewProperties().getViewTitleBarProperties().addSuperObject(this.viewTitleBarProperties);
        this.titleBarPropsAdded = true;
    }

    private void removeViewTitleBarProperties(View view) {
        view.getViewProperties().getViewTitleBarProperties().removeSuperObject(this.viewTitleBarProperties);
        this.titleBarPropsAdded = false;
    }
}

