/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsCorrelatedSourceModel
extends SQLQueryRowsSourceModel {
    @NotNull
    private final SQLQueryRowsSourceModel source;
    @NotNull
    private final SQLQuerySymbolEntry alias;
    @NotNull
    private final List<SQLQuerySymbolEntry> correlationColumNames;

    public SQLQueryRowsCorrelatedSourceModel(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryRowsSourceModel source, @NotNull SQLQuerySymbolEntry alias, @NotNull List<SQLQuerySymbolEntry> correlationColumNames) {
        super(syntaxNode, source);
        this.source = source;
        this.alias = alias;
        this.correlationColumNames = correlationColumNames;
    }

    @Override
    @Nullable
    public SQLQuerySymbolClass getAssociatedSymbolClass() {
        return SQLQuerySemanticUtils.getIdentifierSymbolClass(this.alias);
    }

    @NotNull
    public SQLQueryRowsSourceModel getSource() {
        return this.source;
    }

    @NotNull
    public SQLQuerySymbolEntry getAlias() {
        return this.alias;
    }

    @NotNull
    public List<SQLQuerySymbolEntry> getCorrelationColumNames() {
        return this.correlationColumNames;
    }

    @NotNull
    public static SQLQueryRowsDataContext prepareColumnsCorrelation(@NotNull SQLQueryRowsDataContext context, @NotNull List<SQLQuerySymbolEntry> correlationColumNames, @NotNull SQLQueryRowsSourceModel columnsSource) {
        ArrayList<SQLQueryResultColumn> columns = new ArrayList<SQLQueryResultColumn>(context.getColumnsList());
        if (correlationColumNames.isEmpty()) {
            int i = 0;
            while (i < columns.size()) {
                SQLQueryResultColumn oldColumn = (SQLQueryResultColumn)columns.get(i);
                columns.set(i, oldColumn.withNewSource(columnsSource));
                ++i;
            }
        } else {
            int i = 0;
            while (i < columns.size() && i < correlationColumNames.size()) {
                SQLQuerySymbolEntry correlatedNameDef = correlationColumNames.get(i);
                if (correlatedNameDef.isNotClassified()) {
                    SQLQueryResultColumn oldColumn = (SQLQueryResultColumn)columns.get(i);
                    SQLQuerySymbol correlatedName = correlatedNameDef.getSymbol();
                    correlatedName.setDefinition(correlatedNameDef);
                    correlatedName.setSymbolClass(SQLQuerySymbolClass.COLUMN_DERIVED);
                    correlatedNameDef.setDefinition(oldColumn.symbol.getDefinition());
                    columns.set(i, new SQLQueryResultColumn(i, correlatedName, columnsSource, null, null, oldColumn.type));
                }
                ++i;
            }
        }
        return columnsSource.getRowsSources().makeTuple(columnsSource, columns, context.getPseudoColumnsList());
    }

    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.alias.isNotClassified()) {
            this.alias.getSymbol().setDefinition(this.alias);
            if (this.alias.isNotClassified()) {
                this.alias.getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE_ALIAS);
            }
        }
        return this.source.resolveRowSources(context, statistics).replaceWithAlias(this.source, this, this.alias);
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        return SQLQueryRowsCorrelatedSourceModel.prepareColumnsCorrelation(this.source.getRowsDataContext(), this.correlationColumNames, this);
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T node) {
        return visitor.visitRowsCorrelatedSource(this, node);
    }
}

