/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.RankSorter;

class MinCross
extends GraphVisitor {
    static final int MAX = 45;
    private DirectedGraph g;
    private RankSorter sorter = new RankSorter();

    public MinCross() {
    }

    public MinCross(RankSorter sorter) {
        this.setRankSorter(sorter);
    }

    public void setRankSorter(RankSorter sorter) {
        this.sorter = sorter;
    }

    void solve() {
        int loop = 0;
        while (loop < 45) {
            Rank rank;
            int row = 1;
            while (row < this.g.ranks.size()) {
                rank = this.g.ranks.getRank(row);
                this.sorter.sortRankIncoming(this.g, rank, row, (double)loop / 45.0);
                ++row;
            }
            if (loop != 44) {
                row = this.g.ranks.size() - 2;
                while (row >= 0) {
                    rank = this.g.ranks.getRank(row);
                    this.sorter.sortRankOutgoing(this.g, rank, row, (double)loop / 45.0);
                    --row;
                }
            }
            ++loop;
        }
    }

    @Override
    public void visit(DirectedGraph g) {
        this.sorter.init(g);
        this.g = g;
        this.solve();
        this.sorter.optimize(g);
    }
}

