/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.views.session;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.editors.SinglePageDatabaseEditor;
import org.jkiss.dbeaver.ui.views.session.SessionManagerViewer;

public abstract class AbstractSessionEditor
extends SinglePageDatabaseEditor<IEditorInput>
implements ISearchContextProvider {
    private SessionManagerViewer sessionsViewer;

    public SessionManagerViewer getSessionsViewer() {
        return this.sessionsViewer;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ISearchContextProvider.class) {
            return adapter.cast((Object)this);
        }
        return (T)super.getAdapter(adapter);
    }

    public void dispose() {
        if (this.sessionsViewer != null) {
            this.sessionsViewer.dispose();
        }
        super.dispose();
    }

    public void createEditorControl(Composite parent) {
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext != null) {
            this.setPartName("Sessions - " + executionContext.getDataSource().getContainer().getName());
            this.sessionsViewer = this.createSessionViewer(executionContext, parent);
            this.sessionsViewer.loadSettings(this);
            this.sessionsViewer.refreshSessions();
        }
    }

    protected abstract SessionManagerViewer createSessionViewer(DBCExecutionContext var1, Composite var2);

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        this.sessionsViewer.refreshSessions();
        return IRefreshablePart.RefreshResult.REFRESHED;
    }

    public void setFocus() {
        if (this.sessionsViewer != null) {
            this.sessionsViewer.getControl().setFocus();
        }
    }

    public boolean isSearchPossible() {
        return true;
    }

    public boolean isSearchEnabled() {
        return true;
    }

    public boolean performSearch(ISearchContextProvider.SearchType searchType) {
        if (this.sessionsViewer != null) {
            return this.sessionsViewer.getSessionListControl().performSearch(searchType);
        }
        return false;
    }
}

