/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs;

import java.net.URI;
import java.util.ArrayList;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractVirtualFileSystem
implements DBFVirtualFileSystem {
    @Override
    public String[] getURISegments(URI uri) {
        String path;
        ArrayList<String> segments = new ArrayList<String>();
        if (this.useUriHostNameAsSegment(uri)) {
            String authority;
            String host = uri.getHost();
            if (!CommonUtils.isEmpty((String)host)) {
                segments.add(host);
            }
            if (!CommonUtils.isEmpty((String)(authority = uri.getAuthority())) && !authority.equals(host)) {
                segments.add(authority);
            }
        }
        if (!CommonUtils.isEmpty((String)(path = uri.getPath()))) {
            String[] stringArray = path.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (!item.isEmpty()) {
                    segments.add(item);
                }
                ++n2;
            }
        }
        return segments.toArray(new String[0]);
    }

    protected boolean useUriHostNameAsSegment(URI uri) {
        return true;
    }
}

