/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.cnfexpression;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public abstract class MultipleExpression
extends ASTNodeAccessImpl
implements Expression {
    private final List<Expression> childlist;

    public MultipleExpression(List<Expression> childlist) {
        this.childlist = childlist;
    }

    public int size() {
        return this.childlist.size();
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(new NullValue(), context);
    }

    public List<Expression> getList() {
        return this.childlist;
    }

    public Expression getChild(int index) {
        return this.childlist.get(index);
    }

    public Expression removeChild(int index) {
        return this.childlist.remove(index);
    }

    public void setChild(int index, Expression express) {
        this.childlist.set(index, express);
    }

    public int getIndex(Expression express) {
        return this.childlist.indexOf(express);
    }

    public void addChild(int index, Expression express) {
        this.childlist.add(index, express);
    }

    public abstract String getStringExpression();

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.getChild(i));
            if (i == this.size() - 1) continue;
            sb.append(" ").append(this.getStringExpression()).append(" ");
        }
        sb.append(")");
        return sb.toString();
    }
}

