/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.analyzer;

import java.util.Collection;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.tools.analyzer.IUAnalyzer;

public class UnzipFeatureJarAnalyzer
extends IUAnalyzer {
    @Override
    public void analyzeIU(IInstallableUnit iu) {
        if (iu.getId().indexOf("feature.jar") > -1) {
            Collection touchpointData = iu.getTouchpointData();
            if (touchpointData.size() == 0) {
                this.error(iu, "[ERROR] No unzip touchpoint for: " + iu.getId());
            } else {
                boolean found = false;
                for (ITouchpointData td : touchpointData) {
                    ITouchpointInstruction instruction = td.getInstruction("zipped");
                    if (!instruction.getBody().equals("true")) continue;
                    found = true;
                }
                if (!found) {
                    this.error(iu, "[ERROR] No unzip touchpoint for: " + iu.getId());
                }
            }
        }
    }

    @Override
    public void preAnalysis(IMetadataRepository repository) {
    }
}

