﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces-web/WorkSpacesWebRequest.h>
#include <aws/workspaces-web/WorkSpacesWeb_EXPORTS.h>

#include <utility>

namespace Aws {
namespace WorkSpacesWeb {
namespace Model {

/**
 */
class GetUserAccessLoggingSettingsRequest : public WorkSpacesWebRequest {
 public:
  AWS_WORKSPACESWEB_API GetUserAccessLoggingSettingsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetUserAccessLoggingSettings"; }

  AWS_WORKSPACESWEB_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ARN of the user access logging settings.</p>
   */
  inline const Aws::String& GetUserAccessLoggingSettingsArn() const { return m_userAccessLoggingSettingsArn; }
  inline bool UserAccessLoggingSettingsArnHasBeenSet() const { return m_userAccessLoggingSettingsArnHasBeenSet; }
  template <typename UserAccessLoggingSettingsArnT = Aws::String>
  void SetUserAccessLoggingSettingsArn(UserAccessLoggingSettingsArnT&& value) {
    m_userAccessLoggingSettingsArnHasBeenSet = true;
    m_userAccessLoggingSettingsArn = std::forward<UserAccessLoggingSettingsArnT>(value);
  }
  template <typename UserAccessLoggingSettingsArnT = Aws::String>
  GetUserAccessLoggingSettingsRequest& WithUserAccessLoggingSettingsArn(UserAccessLoggingSettingsArnT&& value) {
    SetUserAccessLoggingSettingsArn(std::forward<UserAccessLoggingSettingsArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_userAccessLoggingSettingsArn;
  bool m_userAccessLoggingSettingsArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpacesWeb
}  // namespace Aws
