﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mq/MQ_EXPORTS.h>
#include <aws/mq/model/ConfigurationRevision.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MQ {
namespace Model {
class ListConfigurationRevisionsResult {
 public:
  AWS_MQ_API ListConfigurationRevisionsResult() = default;
  AWS_MQ_API ListConfigurationRevisionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MQ_API ListConfigurationRevisionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique ID that Amazon MQ generates for the configuration.</p>
   */
  inline const Aws::String& GetConfigurationId() const { return m_configurationId; }
  template <typename ConfigurationIdT = Aws::String>
  void SetConfigurationId(ConfigurationIdT&& value) {
    m_configurationIdHasBeenSet = true;
    m_configurationId = std::forward<ConfigurationIdT>(value);
  }
  template <typename ConfigurationIdT = Aws::String>
  ListConfigurationRevisionsResult& WithConfigurationId(ConfigurationIdT&& value) {
    SetConfigurationId(std::forward<ConfigurationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of configuration revisions that can be returned per page
   * (20 by default). This value must be an integer from 5 to 100.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListConfigurationRevisionsResult& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token that specifies the next page of results Amazon MQ should return. To
   * request the first page, leave nextToken empty.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListConfigurationRevisionsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of all revisions for the specified configuration.</p>
   */
  inline const Aws::Vector<ConfigurationRevision>& GetRevisions() const { return m_revisions; }
  template <typename RevisionsT = Aws::Vector<ConfigurationRevision>>
  void SetRevisions(RevisionsT&& value) {
    m_revisionsHasBeenSet = true;
    m_revisions = std::forward<RevisionsT>(value);
  }
  template <typename RevisionsT = Aws::Vector<ConfigurationRevision>>
  ListConfigurationRevisionsResult& WithRevisions(RevisionsT&& value) {
    SetRevisions(std::forward<RevisionsT>(value));
    return *this;
  }
  template <typename RevisionsT = ConfigurationRevision>
  ListConfigurationRevisionsResult& AddRevisions(RevisionsT&& value) {
    m_revisionsHasBeenSet = true;
    m_revisions.emplace_back(std::forward<RevisionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListConfigurationRevisionsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_configurationId;

  int m_maxResults{0};

  Aws::String m_nextToken;

  Aws::Vector<ConfigurationRevision> m_revisions;

  Aws::String m_requestId;
  bool m_configurationIdHasBeenSet = false;
  bool m_maxResultsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_revisionsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MQ
}  // namespace Aws
