/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;
import org.apache.kafka.common.message.WriteShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.WriteShareGroupStateResponse;

public class WriteShareGroupStateRequest
extends AbstractRequest {
    private final WriteShareGroupStateRequestData data;

    public WriteShareGroupStateRequest(WriteShareGroupStateRequestData data, short version) {
        super(ApiKeys.WRITE_SHARE_GROUP_STATE, version);
        this.data = data;
    }

    @Override
    public WriteShareGroupStateResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ArrayList<WriteShareGroupStateResponseData.WriteStateResult> results = new ArrayList<WriteShareGroupStateResponseData.WriteStateResult>();
        this.data.topics().forEach(topicResult -> results.add(new WriteShareGroupStateResponseData.WriteStateResult().setTopicId(topicResult.topicId()).setPartitions(topicResult.partitions().stream().map(partitionData -> new WriteShareGroupStateResponseData.PartitionResult().setPartition(partitionData.partition()).setErrorCode(Errors.forException(e).code()).setErrorMessage(Errors.forException(e).message())).collect(Collectors.toList()))));
        return new WriteShareGroupStateResponse(new WriteShareGroupStateResponseData().setResults(results));
    }

    @Override
    public WriteShareGroupStateRequestData data() {
        return this.data;
    }

    public static WriteShareGroupStateRequest parse(ByteBuffer buffer, short version) {
        return new WriteShareGroupStateRequest(new WriteShareGroupStateRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<WriteShareGroupStateRequest> {
        private final WriteShareGroupStateRequestData data;

        public Builder(WriteShareGroupStateRequestData data) {
            this(data, true);
        }

        public Builder(WriteShareGroupStateRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.WRITE_SHARE_GROUP_STATE, enableUnstableLastVersion);
            this.data = data;
        }

        @Override
        public WriteShareGroupStateRequest build(short version) {
            return new WriteShareGroupStateRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

