/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.authn;

import com.onelogin.saml2.authn.AuthnRequestParams;
import com.onelogin.saml2.model.Organization;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthnRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthnRequest.class);
    private final String authnRequestString;
    private final String id;
    private final Saml2Settings settings;
    private final Calendar issueInstant;

    public AuthnRequest(Saml2Settings settings) {
        this(settings, new AuthnRequestParams(false, false, true));
    }

    @Deprecated
    public AuthnRequest(Saml2Settings settings, boolean forceAuthn, boolean isPassive, boolean setNameIdPolicy, String nameIdValueReq) {
        this(settings, new AuthnRequestParams(forceAuthn, isPassive, setNameIdPolicy, nameIdValueReq));
    }

    @Deprecated
    public AuthnRequest(Saml2Settings settings, boolean forceAuthn, boolean isPassive, boolean setNameIdPolicy) {
        this(settings, forceAuthn, isPassive, setNameIdPolicy, null);
    }

    public AuthnRequest(Saml2Settings settings, AuthnRequestParams params) {
        this.id = Util.generateUniqueID(settings.getUniqueIDPrefix());
        this.issueInstant = Calendar.getInstance();
        this.settings = settings;
        StrSubstitutor substitutor = this.generateSubstitutor(params, settings);
        this.authnRequestString = this.postProcessXml(substitutor.replace((CharSequence)AuthnRequest.getAuthnRequestTemplate()), params, settings);
        LOGGER.debug("AuthNRequest --> " + this.authnRequestString);
    }

    protected String postProcessXml(String authnRequestXml, AuthnRequestParams params, Saml2Settings settings) {
        return authnRequestXml;
    }

    public String getEncodedAuthnRequest(Boolean deflated) throws IOException {
        if (deflated == null) {
            deflated = this.settings.isCompressRequestEnabled();
        }
        String encodedAuthnRequest = deflated != false ? Util.deflatedBase64encoded(this.getAuthnRequestXml()) : Util.base64encoder(this.getAuthnRequestXml());
        return encodedAuthnRequest;
    }

    public String getEncodedAuthnRequest() throws IOException {
        return this.getEncodedAuthnRequest(null);
    }

    public String getAuthnRequestXml() {
        return this.authnRequestString;
    }

    private StrSubstitutor generateSubstitutor(AuthnRequestParams params, Saml2Settings settings) {
        String displayName;
        HashMap<String, String> valueMap = new HashMap<String, String>();
        String forceAuthnStr = "";
        if (params.isForceAuthn()) {
            forceAuthnStr = " ForceAuthn=\"true\"";
        }
        String isPassiveStr = "";
        if (params.isPassive()) {
            isPassiveStr = " IsPassive=\"true\"";
        }
        valueMap.put("forceAuthnStr", forceAuthnStr);
        valueMap.put("isPassiveStr", isPassiveStr);
        String destinationStr = "";
        URL sso = settings.getIdpSingleSignOnServiceUrl();
        if (sso != null) {
            destinationStr = " Destination=\"" + Util.toXml(sso.toString()) + "\"";
        }
        valueMap.put("destinationStr", destinationStr);
        String subjectStr = "";
        String nameIdValueReq = params.getNameIdValueReq();
        if (nameIdValueReq != null && !nameIdValueReq.isEmpty()) {
            String nameIDFormat = settings.getSpNameIDFormat();
            subjectStr = "<saml:Subject>";
            subjectStr = subjectStr + "<saml:NameID Format=\"" + Util.toXml(nameIDFormat) + "\">" + Util.toXml(nameIdValueReq) + "</saml:NameID>";
            subjectStr = subjectStr + "<saml:SubjectConfirmation Method=\"urn:oasis:names:tc:SAML:2.0:cm:bearer\"></saml:SubjectConfirmation>";
            subjectStr = subjectStr + "</saml:Subject>";
        }
        valueMap.put("subjectStr", subjectStr);
        String nameIDPolicyStr = "";
        if (params.isSetNameIdPolicy()) {
            String nameIDPolicyFormat = settings.getSpNameIDFormat();
            if (settings.getWantNameIdEncrypted()) {
                nameIDPolicyFormat = "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted";
            }
            String allowCreateStr = "";
            if (params.isAllowCreate()) {
                allowCreateStr = " AllowCreate=\"true\"";
            }
            nameIDPolicyStr = "<samlp:NameIDPolicy Format=\"" + Util.toXml(nameIDPolicyFormat) + "\"" + allowCreateStr + " />";
        }
        valueMap.put("nameIDPolicyStr", nameIDPolicyStr);
        String providerStr = "";
        Organization organization = settings.getOrganization();
        if (organization != null && !(displayName = organization.getOrgDisplayName()).isEmpty()) {
            providerStr = " ProviderName=\"" + Util.toXml(displayName) + "\"";
        }
        valueMap.put("providerStr", providerStr);
        String issueInstantString = Util.formatDateTime(this.issueInstant.getTimeInMillis());
        valueMap.put("issueInstant", issueInstantString);
        valueMap.put("id", Util.toXml(String.valueOf(this.id)));
        valueMap.put("assertionConsumerServiceURL", Util.toXml(String.valueOf(settings.getSpAssertionConsumerServiceUrl())));
        valueMap.put("protocolBinding", Util.toXml(settings.getSpAssertionConsumerServiceBinding()));
        valueMap.put("spEntityid", Util.toXml(settings.getSpEntityId()));
        String requestedAuthnContextStr = "";
        List<String> requestedAuthnContexts = settings.getRequestedAuthnContext();
        if (requestedAuthnContexts != null && !requestedAuthnContexts.isEmpty()) {
            String requestedAuthnContextCmp = settings.getRequestedAuthnContextComparison();
            requestedAuthnContextStr = "<samlp:RequestedAuthnContext Comparison=\"" + Util.toXml(requestedAuthnContextCmp) + "\">";
            for (String requestedAuthnContext : requestedAuthnContexts) {
                requestedAuthnContextStr = requestedAuthnContextStr + "<saml:AuthnContextClassRef>" + Util.toXml(requestedAuthnContext) + "</saml:AuthnContextClassRef>";
            }
            requestedAuthnContextStr = requestedAuthnContextStr + "</samlp:RequestedAuthnContext>";
        }
        valueMap.put("requestedAuthnContextStr", requestedAuthnContextStr);
        return new StrSubstitutor(valueMap);
    }

    private static StringBuilder getAuthnRequestTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<samlp:AuthnRequest xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" ID=\"${id}\" Version=\"2.0\" IssueInstant=\"${issueInstant}\"${providerStr}${forceAuthnStr}${isPassiveStr}${destinationStr} ProtocolBinding=\"${protocolBinding}\" AssertionConsumerServiceURL=\"${assertionConsumerServiceURL}\">");
        template.append("<saml:Issuer>${spEntityid}</saml:Issuer>");
        template.append("${subjectStr}${nameIDPolicyStr}${requestedAuthnContextStr}</samlp:AuthnRequest>");
        return template;
    }

    public String getId() {
        return this.id;
    }

    public Calendar getIssueInstant() {
        return this.issueInstant == null ? null : (Calendar)this.issueInstant.clone();
    }
}

