/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.status;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.support.broadcast.BroadcastResponse;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.replication.action.status.ReplayDetails;
import org.opensearch.replication.action.status.RestoreDetails;
import org.opensearch.replication.action.status.ShardInfoResponse;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B;\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u00a2\u0006\u0002\u0010\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012BK\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0015J\b\u0010:\u001a\u00020\u0011H\u0016J\u001a\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<2\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010\u0012R\u001a\u0010&\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010$\"\u0004\b(\u0010\u0012R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010$\"\u0004\b0\u0010\u0012R\u001a\u0010\u0014\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010$\"\u0004\b2\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e03X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010$\"\u0004\b9\u0010\u0012\u00a8\u0006D"}, d2={"Lorg/opensearch/replication/action/status/ReplicationStatusResponse;", "Lorg/opensearch/action/support/broadcast/BroadcastResponse;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "totalShards", "", "successfulShards", "failedShards", "shardFailures", "", "Lorg/opensearch/core/action/support/DefaultShardOperationFailedException;", "shardInfoRespons", "Lorg/opensearch/replication/action/status/ShardInfoResponse;", "(IIILjava/util/List;Ljava/util/List;)V", "status", "", "(Ljava/lang/String;)V", "shardInfoResponse", "reason", "(IIILjava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "aggregatedReplayDetails", "Lorg/opensearch/replication/action/status/ReplayDetails;", "getAggregatedReplayDetails", "()Lorg/opensearch/replication/action/status/ReplayDetails;", "setAggregatedReplayDetails", "(Lorg/opensearch/replication/action/status/ReplayDetails;)V", "aggregatedRestoreDetails", "Lorg/opensearch/replication/action/status/RestoreDetails;", "getAggregatedRestoreDetails", "()Lorg/opensearch/replication/action/status/RestoreDetails;", "setAggregatedRestoreDetails", "(Lorg/opensearch/replication/action/status/RestoreDetails;)V", "connectionAlias", "getConnectionAlias", "()Ljava/lang/String;", "setConnectionAlias", "followerIndexName", "getFollowerIndexName", "setFollowerIndexName", "isVerbose", "", "()Z", "setVerbose", "(Z)V", "leaderIndexName", "getLeaderIndexName", "setLeaderIndexName", "getReason", "setReason", "", "getShardInfoResponse", "()Ljava/util/List;", "setShardInfoResponse", "(Ljava/util/List;)V", "getStatus", "setStatus", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "opensearch-cross-cluster-replication"})
public final class ReplicationStatusResponse
extends BroadcastResponse
implements ToXContentObject {
    public List<ShardInfoResponse> shardInfoResponse;
    public String status;
    public String reason;
    public String connectionAlias;
    public String leaderIndexName;
    public String followerIndexName;
    public ReplayDetails aggregatedReplayDetails;
    public RestoreDetails aggregatedRestoreDetails;
    private boolean isVerbose;

    @NotNull
    public final List<ShardInfoResponse> getShardInfoResponse() {
        List<ShardInfoResponse> list = this.shardInfoResponse;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"shardInfoResponse");
        return null;
    }

    public final void setShardInfoResponse(@NotNull List<ShardInfoResponse> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.shardInfoResponse = list;
    }

    @NotNull
    public final String getStatus() {
        String string = this.status;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"status");
        return null;
    }

    public final void setStatus(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.status = string;
    }

    @NotNull
    public final String getReason() {
        String string = this.reason;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"reason");
        return null;
    }

    public final void setReason(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.reason = string;
    }

    @NotNull
    public final String getConnectionAlias() {
        String string = this.connectionAlias;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"connectionAlias");
        return null;
    }

    public final void setConnectionAlias(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.connectionAlias = string;
    }

    @NotNull
    public final String getLeaderIndexName() {
        String string = this.leaderIndexName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"leaderIndexName");
        return null;
    }

    public final void setLeaderIndexName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.leaderIndexName = string;
    }

    @NotNull
    public final String getFollowerIndexName() {
        String string = this.followerIndexName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"followerIndexName");
        return null;
    }

    public final void setFollowerIndexName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.followerIndexName = string;
    }

    @NotNull
    public final ReplayDetails getAggregatedReplayDetails() {
        ReplayDetails replayDetails = this.aggregatedReplayDetails;
        if (replayDetails != null) {
            return replayDetails;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"aggregatedReplayDetails");
        return null;
    }

    public final void setAggregatedReplayDetails(@NotNull ReplayDetails replayDetails) {
        Intrinsics.checkNotNullParameter((Object)((Object)replayDetails), (String)"<set-?>");
        this.aggregatedReplayDetails = replayDetails;
    }

    @NotNull
    public final RestoreDetails getAggregatedRestoreDetails() {
        RestoreDetails restoreDetails = this.aggregatedRestoreDetails;
        if (restoreDetails != null) {
            return restoreDetails;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"aggregatedRestoreDetails");
        return null;
    }

    public final void setAggregatedRestoreDetails(@NotNull RestoreDetails restoreDetails) {
        Intrinsics.checkNotNullParameter((Object)((Object)restoreDetails), (String)"<set-?>");
        this.aggregatedRestoreDetails = restoreDetails;
    }

    public final boolean isVerbose() {
        return this.isVerbose;
    }

    public final void setVerbose(boolean bl) {
        this.isVerbose = bl;
    }

    public ReplicationStatusResponse(@NotNull StreamInput inp) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        super(inp);
        this.isVerbose = true;
        List list = inp.readList(ShardInfoResponse::new);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        this.setShardInfoResponse(list);
    }

    public ReplicationStatusResponse(int totalShards, int successfulShards, int failedShards, @NotNull List<? extends DefaultShardOperationFailedException> shardFailures, @NotNull List<ShardInfoResponse> shardInfoRespons) {
        Intrinsics.checkNotNullParameter(shardFailures, (String)"shardFailures");
        Intrinsics.checkNotNullParameter(shardInfoRespons, (String)"shardInfoRespons");
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.isVerbose = true;
        this.setShardInfoResponse(CollectionsKt.toMutableList((Collection)shardInfoRespons));
    }

    public ReplicationStatusResponse(@NotNull String status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.isVerbose = true;
        this.setStatus(status);
    }

    public ReplicationStatusResponse(int totalShards, int successfulShards, int failedShards, @NotNull List<? extends DefaultShardOperationFailedException> shardFailures, @NotNull List<ShardInfoResponse> shardInfoResponse, @NotNull String status, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(shardFailures, (String)"shardFailures");
        Intrinsics.checkNotNullParameter(shardInfoResponse, (String)"shardInfoResponse");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.isVerbose = true;
        this.setShardInfoResponse(CollectionsKt.toMutableList((Collection)shardInfoResponse));
        this.setStatus(status);
        this.setReason(reason);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) throws IOException {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.startObject();
        if (this.status != null) {
            builder.field("status", this.getStatus());
        }
        if (this.reason != null) {
            builder.field("reason", this.getReason());
        }
        if (this.connectionAlias != null) {
            builder.field("leader_alias", this.getConnectionAlias());
        }
        if (this.leaderIndexName != null) {
            builder.field("leader_index", this.getLeaderIndexName());
        }
        if (this.followerIndexName != null) {
            builder.field("follower_index", this.getFollowerIndexName());
        }
        if (this.aggregatedReplayDetails != null) {
            builder.field("syncing_details", (ToXContent)this.getAggregatedReplayDetails());
        }
        if (this.aggregatedRestoreDetails != null) {
            builder.field("bootstrap_details", (ToXContent)this.getAggregatedRestoreDetails());
        }
        if (this.isVerbose & this.shardInfoResponse != null) {
            builder.field("shard_replication_details", (Iterable)this.getShardInfoResponse());
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        if (this.shardInfoResponse != null) {
            out.writeList(this.getShardInfoResponse());
        }
        if (this.status != null) {
            out.writeString(this.getStatus());
        }
        if (this.reason != null) {
            out.writeString(this.getReason());
        }
        if (this.connectionAlias != null) {
            out.writeString(this.getConnectionAlias());
        }
        if (this.leaderIndexName != null) {
            out.writeString(this.getLeaderIndexName());
        }
        if (this.followerIndexName != null) {
            out.writeString(this.getFollowerIndexName());
        }
    }

    @NotNull
    public String toString() {
        return "ReplicationStatusResponse(shardInfoResponse=" + this.getShardInfoResponse() + ", status='" + this.getStatus() + "', connectionAlias='" + this.getConnectionAlias() + "', leaderIndexName='" + this.getLeaderIndexName() + "', followerIndexName='" + this.getFollowerIndexName() + "')";
    }
}

