/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.formatters.ColorPrintf;
import org.jboss.logmanager.formatters.ColorUtil;
import org.jboss.logmanager.formatters.FormatStep;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.formatters.Printf;
import org.jboss.logmanager.handlers.ConsoleHandler;

public class ColorPatternFormatter
extends PatternFormatter {
    private final Printf printf;
    private final int darken;

    public ColorPatternFormatter() {
        this(0);
    }

    public ColorPatternFormatter(String pattern) {
        this(0, pattern);
    }

    public ColorPatternFormatter(int darken) {
        this.darken = darken;
        this.printf = new ColorPrintf(darken);
    }

    public ColorPatternFormatter(int darken, String pattern) {
        this(darken);
        this.setPattern(pattern);
    }

    @Override
    public void setSteps(FormatStep[] steps) {
        FormatStep[] colorSteps = new FormatStep[steps.length];
        for (int i = 0; i < steps.length; ++i) {
            colorSteps[i] = this.colorize(steps[i]);
        }
        super.setSteps(colorSteps);
    }

    private FormatStep colorize(FormatStep step) {
        switch (step.getItemType()) {
            case LEVEL: {
                return new LevelColorStep(step, this.darken);
            }
            case SOURCE_CLASS_NAME: {
                return new ColorStep(step, 255, 255, 68, this.darken);
            }
            case DATE: {
                return new ColorStep(step, 192, 192, 192, this.darken);
            }
            case SOURCE_FILE_NAME: {
                return new ColorStep(step, 255, 255, 68, this.darken);
            }
            case HOST_NAME: {
                return new ColorStep(step, 68, 255, 68, this.darken);
            }
            case SOURCE_LINE_NUMBER: {
                return new ColorStep(step, 255, 255, 68, this.darken);
            }
            case LINE_SEPARATOR: {
                return step;
            }
            case CATEGORY: {
                return new ColorStep(step, 68, 136, 255, this.darken);
            }
            case MDC: {
                return new ColorStep(step, 68, 255, 170, this.darken);
            }
            case MESSAGE: {
                return new ColorStep(step, 255, 255, 255, this.darken);
            }
            case EXCEPTION_TRACE: {
                return new ColorStep(step, 255, 68, 68, this.darken);
            }
            case SOURCE_METHOD_NAME: {
                return new ColorStep(step, 255, 255, 68, this.darken);
            }
            case SOURCE_MODULE_NAME: {
                return new ColorStep(step, 136, 255, 68, this.darken);
            }
            case SOURCE_MODULE_VERSION: {
                return new ColorStep(step, 68, 255, 68, this.darken);
            }
            case NDC: {
                return new ColorStep(step, 68, 255, 170, this.darken);
            }
            case PROCESS_ID: {
                return new ColorStep(step, 221, 187, 119, this.darken);
            }
            case PROCESS_NAME: {
                return new ColorStep(step, 221, 221, 119, this.darken);
            }
            case RELATIVE_TIME: {
                return new ColorStep(step, 192, 192, 192, this.darken);
            }
            case RESOURCE_KEY: {
                return new ColorStep(step, 68, 255, 68, this.darken);
            }
            case SYSTEM_PROPERTY: {
                return new ColorStep(step, 136, 136, 0, this.darken);
            }
            case TEXT: {
                return new ColorStep(step, 208, 208, 208, this.darken);
            }
            case THREAD_ID: {
                return new ColorStep(step, 68, 170, 68, this.darken);
            }
            case THREAD_NAME: {
                return new ColorStep(step, 68, 170, 68, this.darken);
            }
        }
        return new ColorStep(step, 176, 208, 176, this.darken);
    }

    private String colorizePlain(String str) {
        return str;
    }

    @Override
    public String formatMessage(LogRecord logRecord) {
        if (logRecord instanceof ExtLogRecord) {
            ExtLogRecord record = (ExtLogRecord)logRecord;
            if (record.getFormatStyle() != ExtLogRecord.FormatStyle.PRINTF || record.getParameters() == null || record.getParameters().length == 0) {
                return this.colorizePlain(super.formatMessage(record));
            }
            return this.printf.format(record.getMessage(), record.getParameters());
        }
        return this.colorizePlain(super.formatMessage(logRecord));
    }

    static final class LevelColorStep
    implements FormatStep {
        private static final int LARGEST_LEVEL = Level.ERROR.intValue();
        private static final int SMALLEST_LEVEL = Level.TRACE.intValue();
        private static final int SATURATION = 66;
        private final FormatStep delegate;
        private final int darken;
        private final boolean trueColor = ConsoleHandler.isTrueColor();

        LevelColorStep(FormatStep delegate, int darken) {
            this.delegate = delegate;
            this.darken = darken;
        }

        @Override
        public void render(Formatter formatter, StringBuilder builder, ExtLogRecord record) {
            int level = Math.max(Math.min(record.getLevel().intValue(), LARGEST_LEVEL), SMALLEST_LEVEL) - SMALLEST_LEVEL;
            int r = (level < 300 ? 0 : (level - 300) * 189 / 300) + 66 >>> this.darken;
            int g = (300 - Math.abs(level - 300)) * 189 / 300 + 66 >>> this.darken;
            int b = (level > 300 ? 0 : level * 189 / 300) + 66 >>> this.darken;
            ColorUtil.startFgColor(builder, this.trueColor, r, g, b);
            this.delegate.render(formatter, builder, record);
            ColorUtil.endFgColor(builder);
        }

        @Override
        public void render(StringBuilder builder, ExtLogRecord record) {
            this.render(null, builder, record);
        }

        @Override
        public int estimateLength() {
            return this.delegate.estimateLength() + 30;
        }

        @Override
        public boolean isCallerInformationRequired() {
            return false;
        }
    }

    static final class ColorStep
    implements FormatStep {
        private final int r;
        private final int g;
        private final int b;
        private final FormatStep delegate;
        private final boolean trueColor = ConsoleHandler.isTrueColor();

        ColorStep(FormatStep delegate, int r, int g, int b, int darken) {
            this.r = r >>> darken;
            this.g = g >>> darken;
            this.b = b >>> darken;
            this.delegate = delegate;
        }

        @Override
        public void render(Formatter formatter, StringBuilder builder, ExtLogRecord record) {
            ColorUtil.startFgColor(builder, this.trueColor, this.r, this.g, this.b);
            this.delegate.render(formatter, builder, record);
            ColorUtil.endFgColor(builder);
        }

        @Override
        public void render(StringBuilder builder, ExtLogRecord record) {
            this.render(null, builder, record);
        }

        @Override
        public int estimateLength() {
            return this.delegate.estimateLength() + 30;
        }

        @Override
        public boolean isCallerInformationRequired() {
            return this.delegate.isCallerInformationRequired();
        }

        @Override
        public FormatStep.ItemType getItemType() {
            return this.delegate.getItemType();
        }
    }
}

