// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { multipartPolicyName as tspMultipartPolicyName, multipartPolicy as tspMultipartPolicy, } from "@typespec/ts-http-runtime/internal/policies";
import { getRawContent, hasRawContent } from "../util/file.js";
/**
 * Name of multipart policy
 */
export const multipartPolicyName = tspMultipartPolicyName;
/**
 * Pipeline policy for multipart requests
 */
export function multipartPolicy() {
    const tspPolicy = tspMultipartPolicy();
    return {
        name: multipartPolicyName,
        sendRequest: async (request, next) => {
            if (request.multipartBody) {
                for (const part of request.multipartBody.parts) {
                    if (hasRawContent(part.body)) {
                        part.body = getRawContent(part.body);
                    }
                }
            }
            return tspPolicy.sendRequest(request, next);
        },
    };
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/ac4cbdf48759c7d8c3eb91ffe6bb04316e263c57/node_modules/@azure/core-rest-pipeline/dist/react-native/policies/multipartPolicy.js.map