/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ngram.slp.modeling.dynamic;

import com.intellij.completion.ngram.slp.modeling.AbstractModel;
import com.intellij.completion.ngram.slp.modeling.Model;
import com.intellij.completion.ngram.slp.modeling.ngram.NGramModel;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u001e\u0010\u0010\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0016\u0010\u0012\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u001e\u0010\u0013\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J*\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J8\u0010\u0019\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\t0\u001a2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u001e\u0010\u001b\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010\u001e\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R&\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n\u0012\u0004\u0012\u00020\u00050\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/completion/ngram/slp/modeling/dynamic/CacheModel;", "Lcom/intellij/completion/ngram/slp/modeling/AbstractModel;", "model", "Lcom/intellij/completion/ngram/slp/modeling/Model;", "capacity", "", "(Lcom/intellij/completion/ngram/slp/modeling/Model;I)V", "cache", "Ljava/util/Deque;", "Lkotlin/Pair;", "", "cachedRefs", "", "forget", "", "input", "forgetToken", "index", "learn", "learnToken", "modelAtIndex", "", "notify", "next", "Ljava/io/File;", "predictAtIndex", "", "store", "toString", "", "updateCache", "Companion", "bd0177eacd27ae4e"})
public final class CacheModel
extends AbstractModel {
    private final Deque<Pair<List<Integer>, Integer>> cache;
    private final Map<Integer, List<Integer>> cachedRefs;
    private Model model;
    private final int capacity;
    public static final int DEFAULT_CAPACITY = 5000;
    public static final Companion Companion = new Companion(null);

    @Override
    public void notify(@NotNull File next) {
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        try {
            Object obj = this.model.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(obj, (String)"model.javaClass.getConstructor().newInstance()");
            this.model = (Model)obj;
        }
        catch (InstantiationException e) {
            this.model = NGramModel.Companion.standard();
        }
        catch (IllegalAccessException e) {
            this.model = NGramModel.Companion.standard();
        }
        catch (IllegalArgumentException e) {
            this.model = NGramModel.Companion.standard();
        }
        catch (InvocationTargetException e) {
            this.model = NGramModel.Companion.standard();
        }
        catch (NoSuchMethodException e) {
            this.model = NGramModel.Companion.standard();
        }
        catch (SecurityException e) {
            this.model = NGramModel.Companion.standard();
        }
        this.cache.clear();
        this.cachedRefs.clear();
    }

    @Override
    public void learn(@NotNull List<Integer> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
    }

    @Override
    public void learnToken(@NotNull List<Integer> input, int index) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
    }

    @Override
    public void forget(@NotNull List<Integer> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
    }

    @Override
    public void forgetToken(@NotNull List<Integer> input, int index) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
    }

    @Override
    @NotNull
    public Pair<Double, Double> modelAtIndex(@NotNull List<Integer> input, int index) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        Pair<Double, Double> modeled2 = this.model.modelToken(input, index);
        this.updateCache(input, index);
        return modeled2;
    }

    private final void updateCache(List<Integer> input, int index) {
        if (this.capacity > 0 && this.getDynamic()) {
            this.store(input, index);
            this.model.learnToken(input, index);
            if (this.cache.size() > this.capacity) {
                Pair<List<Integer>, Integer> removed = this.cache.removeFirst();
                this.model.forgetToken((List)removed.getFirst(), ((Number)removed.getSecond()).intValue());
            }
        }
    }

    private final void store(List<Integer> input, int index) {
        int hash = ((Object)input).hashCode();
        List list = this.cachedRefs.get(hash);
        if (list == null) {
            list = new ArrayList(input);
            this.cachedRefs.put(hash, list);
        }
        this.cache.addLast((Pair<List<Integer>, Integer>)new Pair((Object)list, (Object)index));
    }

    @Override
    @NotNull
    public Map<Integer, Pair<Double, Double>> predictAtIndex(@Nullable List<Integer> input, int index) {
        List<Integer> list = input;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return this.model.predictToken(list, index);
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    public CacheModel(@NotNull Model model2, int capacity) {
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        this.model = model2;
        this.capacity = capacity;
        this.setDynamic(true);
        this.cache = new ArrayDeque(this.capacity);
        this.cachedRefs = new HashMap();
    }

    public /* synthetic */ CacheModel(Model model2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            model2 = NGramModel.Companion.standard();
        }
        if ((n2 & 2) != 0) {
            n = 5000;
        }
        this(model2, n);
    }

    public CacheModel() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/completion/ngram/slp/modeling/dynamic/CacheModel$Companion;", "", "()V", "DEFAULT_CAPACITY", "", "bd0177eacd27ae4e"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

