/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Util;

public class HostKey {
    private static final byte[][] names = new byte[][]{Util.str2byte("ssh-dss"), Util.str2byte("ssh-rsa"), Util.str2byte("ecdsa-sha2-nistp256"), Util.str2byte("ecdsa-sha2-nistp384"), Util.str2byte("ecdsa-sha2-nistp521")};
    protected static final int GUESS = 0;
    public static final int SSHDSS = 1;
    public static final int SSHRSA = 2;
    public static final int ECDSA256 = 3;
    public static final int ECDSA384 = 4;
    public static final int ECDSA521 = 5;
    static final int UNKNOWN = 6;
    protected String marker;
    protected String host;
    protected int type;
    protected byte[] key;
    protected String comment;

    public HostKey(String string, byte[] byArray) throws JSchException {
        this(string, 0, byArray);
    }

    public HostKey(String string, int n, byte[] byArray) throws JSchException {
        this(string, n, byArray, null);
    }

    public HostKey(String string, int n, byte[] byArray, String string2) throws JSchException {
        this("", string, n, byArray, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HostKey(String string, String string2, int n, byte[] byArray, String string3) throws JSchException {
        this.marker = string;
        this.host = string2;
        if (n == 0) {
            if (byArray[8] == 100) {
                this.type = 1;
            } else if (byArray[8] == 114) {
                this.type = 2;
            } else if (byArray[8] == 97 && byArray[20] == 50) {
                this.type = 3;
            } else if (byArray[8] == 97 && byArray[20] == 51) {
                this.type = 4;
            } else {
                if (byArray[8] != 97 || byArray[20] != 53) throw new JSchException("invalid key type");
                this.type = 5;
            }
        } else {
            this.type = n;
        }
        this.key = byArray;
        this.comment = string3;
    }

    public String getHost() {
        return this.host;
    }

    public String getType() {
        if (this.type == 1 || this.type == 2 || this.type == 3 || this.type == 4 || this.type == 5) {
            return Util.byte2str(names[this.type - 1]);
        }
        return "UNKNOWN";
    }

    protected static int name2type(String string) {
        for (int i = 0; i < names.length; ++i) {
            if (!Util.byte2str(names[i]).equals(string)) continue;
            return i + 1;
        }
        return 6;
    }

    public String getKey() {
        return Util.byte2str(Util.toBase64(this.key, 0, this.key.length));
    }

    public String getFingerPrint(JSch jSch) {
        HASH hASH = null;
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("md5"));
            hASH = (HASH)clazz.newInstance();
        }
        catch (Exception exception) {
            System.err.println("getFingerPrint: " + exception);
        }
        return Util.getFingerPrint(hASH, this.key);
    }

    public String getComment() {
        return this.comment;
    }

    public String getMarker() {
        return this.marker;
    }

    boolean isMatched(String string) {
        return this.isIncluded(string);
    }

    private boolean isIncluded(String string) {
        int n = 0;
        String string2 = this.host;
        int n2 = string2.length();
        int n3 = string.length();
        while (n < n2) {
            int n4 = string2.indexOf(44, n);
            if (n4 == -1) {
                if (n3 != n2 - n) {
                    return false;
                }
                return string2.regionMatches(true, n, string, 0, n3);
            }
            if (n3 == n4 - n && string2.regionMatches(true, n, string, 0, n3)) {
                return true;
            }
            n = n4 + 1;
        }
        return false;
    }
}

