/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.argument;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.argument.ReadVarKeywordsNodeGen;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;

public abstract class ReadVarKeywordsNode
extends ReadArgumentNode {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TruffleString[] keywordNames;
    private final boolean doWrap;

    public abstract PKeyword[] executePKeyword(VirtualFrame var1);

    public static ReadVarKeywordsNode create() {
        return ReadVarKeywordsNodeGen.create(PythonUtils.EMPTY_TRUFFLESTRING_ARRAY, false);
    }

    public static ReadVarKeywordsNode create(TruffleString[] keywordNames) {
        return ReadVarKeywordsNodeGen.create(keywordNames, false);
    }

    public static ReadVarKeywordsNode createForUserFunction(TruffleString[] names) {
        return ReadVarKeywordsNodeGen.create(names, true);
    }

    ReadVarKeywordsNode(TruffleString[] keywordNames, boolean doWrap) {
        this.keywordNames = keywordNames;
        this.doWrap = doWrap;
    }

    protected int getLimit() {
        return Math.max(this.keywordNames.length, 5);
    }

    protected int getAndCheckKwargLen(VirtualFrame frame) {
        CompilerAsserts.neverPartOfCompilation((String)"caching the kwarg len should never be compiled");
        int length = ReadVarKeywordsNode.getKwargLen(frame);
        if (length >= PythonLanguage.get(this).getEngineOption(PythonOptions.VariableArgumentReadUnrollingLimit)) {
            return -1;
        }
        return length;
    }

    protected static int getKwargLen(VirtualFrame frame) {
        return PArguments.getKeywordArguments((Frame)frame).length;
    }

    private Object returnValue(PKeyword[] keywords) {
        if (this.doWrap) {
            return PFactory.createDict(PythonLanguage.get(this), keywords);
        }
        return keywords;
    }

    @Specialization(guards={"getKwargLen(frame) == cachedLen", "cachedLen == 0"}, limit="1")
    Object noKeywordArgs(VirtualFrame frame, @Cached(value="getAndCheckKwargLen(frame)") int cachedLen) {
        return this.returnValue(PKeyword.EMPTY_KEYWORDS);
    }

    @Specialization(guards={"getKwargLen(frame) == cachedLen"}, limit="getLimit()")
    @ExplodeLoop
    Object extractKwargs(VirtualFrame frame, @Cached(value="getAndCheckKwargLen(frame)") int cachedLen, @Cached.Exclusive @Cached TruffleString.EqualNode equalNode) {
        PKeyword[] keywordArguments = PArguments.getKeywordArguments((Frame)frame);
        PKeyword[] remArguments = PKeyword.create(cachedLen);
        CompilerAsserts.compilationConstant((Object)this.keywordNames.length);
        int i = 0;
        for (int j = 0; j < cachedLen; ++j) {
            PKeyword keyword = keywordArguments[j];
            TruffleString kwName = keyword.getName();
            boolean kwFound = this.searchKeyword(kwName, equalNode);
            if (kwFound) continue;
            remArguments[i] = keyword;
            ++i;
        }
        if (remArguments.length != i) {
            return this.returnValue(Arrays.copyOf(remArguments, i));
        }
        return this.returnValue(remArguments);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
    private boolean searchKeyword(TruffleString kwName, TruffleString.EqualNode equalNode) {
        for (TruffleString name : this.keywordNames) {
            if (!equalNode.execute((AbstractTruffleString)kwName, (AbstractTruffleString)name, PythonUtils.TS_ENCODING)) continue;
            return true;
        }
        return false;
    }

    @Specialization(replaces={"extractKwargs"})
    Object extractVariableKwargs(VirtualFrame frame, @Cached.Exclusive @Cached TruffleString.EqualNode equalNode) {
        PKeyword[] keywordArguments = PArguments.getKeywordArguments((Frame)frame);
        PKeyword[] remArguments = PKeyword.create(keywordArguments.length);
        int i = 0;
        block0: for (PKeyword keyword : keywordArguments) {
            TruffleString kwName = keyword.getName();
            for (TruffleString name : this.keywordNames) {
                if (equalNode.execute((AbstractTruffleString)kwName, (AbstractTruffleString)name, PythonUtils.TS_ENCODING)) continue block0;
            }
            remArguments[i] = keyword;
            ++i;
        }
        return this.returnValue(Arrays.copyOf(remArguments, i));
    }
}

