/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableStatement;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={ResultSet.class, OracleResultSet.class, oracle.jdbc.internal.OracleResultSet.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class NonTxnReplayableResultSet
extends NonTxnReplayableBase
implements Replayable {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    public NonTxnReplayableResultSet() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$17, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$17, null);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$17, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void args;
            void receiver;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$0, this, method, object, objectArray);
            }
            super.preForAll((Method)m2, receiver, (Object[])args);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Pre
    @Methods(signatures={@Signature(name="deleteRow", args={}), @Signature(name="insertRow", args={}), @Signature(name="updateRow", args={})})
    protected void preForRowUpdates(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            FailoverManagerImpl.ReplayLifecycle lifecycle;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$1, this, method, object, objectArray);
            }
            if ((lifecycle = this.failoverMngr.getReplayLifecycle()) != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$1, this);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$1, this, null);
                }
                return;
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$1, Level.FINER, this.getClass(), $$$methodRef$$$1, "On result set {0}, entering preForRowUpdates({1})", new Object[]{this, m2.getName()});
            }
            if (this.failoverMngr != null) {
                this.failoverMngr.disableReplayInternal((Method)m2, 371, "Replay disabled because of active transaction", null);
            } else if (bl) {
                OracleLog.log($$$loggerRef$$$1, Level.SEVERE, this.getClass(), $$$methodRef$$$1, "On result set {0}, failover manager not set", this);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$1, Level.FINER, this.getClass(), $$$methodRef$$$1, "On result set {0}, exiting preForRowUpdates()", this);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Pre
    @Methods(signatures={@Signature(name="updateAsciiStream", args={String.class, InputStream.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class, long.class})})
    protected void preForUpdateStreams(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            FailoverManagerImpl.ReplayLifecycle lifecycle;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$2, this, method, object, objectArray);
            }
            if ((lifecycle = this.failoverMngr.getReplayLifecycle()) != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$2, this);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$2, this, null);
                }
                return;
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$2, Level.FINER, this.getClass(), $$$methodRef$$$2, "On result set {0}, entering preForRowUpdates({1})", new Object[]{this, m2.getName()});
            }
            if (this.failoverMngr != null) {
                this.failoverMngr.disableReplayInternal((Method)m2, 371, "Replay disabled because of active transaction", null);
            } else if (bl) {
                OracleLog.log($$$loggerRef$$$2, Level.SEVERE, this.getClass(), $$$methodRef$$$2, "On result set {0}, failover manager not set", this);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$2, Level.FINER, this.getClass(), $$$methodRef$$$2, "On result set {0}, exiting preForRowUpdates()", this);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Post
    protected void postForAll(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$3, this, method);
            }
            this.postForAll((Method)m2, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void result;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$4, this, method, object);
            }
            Object object2 = super.postForAll((Method)m2, result);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$4, this, object2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$4, this, null);
            }
            return object2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="next", args={})})
    protected boolean postForNext(Method method, boolean bl) {
        boolean bl2 = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void result;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$5, this, method, bl);
            }
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: 
                case REPLAYING_LASTCALL: {
                    void m2;
                    this.doPostWhenRecordingNext((Method)m2, (boolean)result, null);
                    break;
                }
                case INTERNALLY_FAILED: 
                case ALWAYS_DISABLED: 
                case INTERNALLY_DISABLED: 
                case EXTERNALLY_DISABLED: 
                case REPLAYING_CALLBACK: {
                    break;
                }
                case REPLAYING: {
                    void m2;
                    this.doPostWhenReplaying((Method)m2, (boolean)result, null);
                }
            }
            void var5_5 = result;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$5, this, (boolean)var5_5);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$5, this, null);
            }
            return (boolean)var5_5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$6, this, method);
            }
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: {
                    void m2;
                    this.doPostWhenRecordingClose((Method)m2, null);
                    break;
                }
                case INTERNALLY_FAILED: 
                case ALWAYS_DISABLED: 
                case INTERNALLY_DISABLED: 
                case EXTERNALLY_DISABLED: 
                case REPLAYING_CALLBACK: {
                    break;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$7, this, method, sQLException);
            }
            this.onErrorForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$8, this, method, sQLException);
            }
            Object object = super.onErrorForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$8, this, object);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$8, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="last", args={})})
    protected boolean onErrorForLast(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            void error;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$9, this, method, sQLException);
            }
            if (this.isClosedAndNoReplay) {
                void var6_4 = error;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$9, this, (Throwable)var6_4);
                }
                throw var6_4;
            }
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            if (error instanceof SQLRecoverableException && lifecycle == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$9, Level.FINER, this.getClass(), $$$methodRef$$$9, "On proxy {0}, failed call for initial outage is last()", this);
                }
                this.failoverMngr.disableReplayInternal((Method)m2, 372, "Replay disabled because of nonreplayable call", null);
            }
            boolean bl2 = (Boolean)super.onErrorForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$9, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$9, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    /*
     * WARNING - void declaration
     */
    @Override
    public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry callHistoryEntry) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$10, this, callHistoryEntry);
            }
            OracleStatement ostmt = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
            long checksum = ostmt.getChecksum();
            if (bl) {
                OracleLog.log($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "On proxy {0}, method {1}, filling in checksum: {2}", new Object[]{entry.jdbcProxy, entry.method, checksum});
            }
            this.failoverMngr.update(this, (FailoverManagerImpl.CallHistoryEntry)entry, entry.result, entry.callStatus, checksum, entry.scn, entry.callException);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void entry;
            Object result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$11, this, callHistoryEntry, sQLRecoverableException);
            }
            Object object = result = super.replayOneCall((FailoverManagerImpl.CallHistoryEntry)entry, (SQLRecoverableException)origError);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$11, this, object);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$11, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doPostWhenRecordingNext(Method method, Object object, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void sqlexc;
            void result;
            long checksum;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$12, this, method, object, sQLException);
                }
                long SCN = -1L;
                checksum = 0L;
                OracleStatement ostmt = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
                try {
                    checksum = ostmt.getChecksum();
                }
                catch (SQLException exc) {
                    checksum = 0L;
                    if (!bl) break block7;
                    OracleLog.log($$$loggerRef$$$12, Level.WARNING, this.getClass(), $$$methodRef$$$12, "On result set {0}, getChecksum() gets exception: {1}", new Object[]{this, exc});
                }
            }
            this.failoverMngr.update(this, null, result, "completed", checksum, -1L, (SQLException)sqlexc);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void doPostWhenRecordingClose(Method method, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            NonTxnReplayableStatement stmtProxy;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$13, this, method, sQLException);
            }
            if ((stmtProxy = (NonTxnReplayableStatement)this.getCreator()).okToPurgeSameProxyList()) {
                this.purgeSameProxyList();
            }
            this.isClosedAndNoReplay = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void doPostWhenReplaying(Method method, Object object, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block12: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$14, this, method, object, sQLException);
                }
                try {
                    FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
                    switch (lifecycle) {
                        case REPLAYING: {
                            if (this.replayingCallEntry.checksum == 0L) break;
                            OracleStatement ostmt = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
                            long newChecksum = ostmt.getChecksum();
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$14, Level.FINER, this.getClass(), $$$methodRef$$$14, "On proxy {0}, replaying method {1}, new checksum: {2}, original checksum: {3}", new Object[]{this.replayingCallEntry.jdbcProxy, this.replayingCallEntry.method, newChecksum, this.replayingCallEntry.checksum});
                            }
                            if (this.replayingCallEntry.checksum != newChecksum) {
                                this.failoverMngr.disableReplayAndThrowException(this.replayingCallEntry.method, 388, "Replay failed because of checksum mismatch", this.originalError);
                            }
                            break;
                        }
                    }
                }
                catch (SQLException exc) {
                    if (!bl) break block12;
                    OracleLog.log($$$loggerRef$$$14, Level.WARNING, this.getClass(), $$$methodRef$$$14, "On result set {0}, doPostWhenReplaying exception: {1}", new Object[]{this, exc});
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Statement getStatement() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$15, this, new Object[0]);
            }
            Statement statement = (Statement)this.getCreator();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$15, this, statement);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$15, this, null);
            }
            return statement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$16, this, clazz);
            }
            Object object = this.getDelegate();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$16, this, object);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$16, this, null);
            }
            return (T)object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableResultSet.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$17 = NonTxnReplayableResultSet.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = NonTxnReplayableResultSet.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = NonTxnReplayableResultSet.class.getDeclaredMethod("getStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = NonTxnReplayableResultSet.class.getDeclaredMethod("doPostWhenReplaying", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = NonTxnReplayableResultSet.class.getDeclaredMethod("doPostWhenRecordingClose", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = NonTxnReplayableResultSet.class.getDeclaredMethod("doPostWhenRecordingNext", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = NonTxnReplayableResultSet.class.getDeclaredMethod("replayOneCall", FailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = NonTxnReplayableResultSet.class.getDeclaredMethod("fillInChecksum", FailoverManagerImpl.CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = NonTxnReplayableResultSet.class.getDeclaredMethod("onErrorForLast", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = NonTxnReplayableResultSet.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = NonTxnReplayableResultSet.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = NonTxnReplayableResultSet.class.getDeclaredMethod("postForClose", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = NonTxnReplayableResultSet.class.getDeclaredMethod("postForNext", Method.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = NonTxnReplayableResultSet.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = NonTxnReplayableResultSet.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = NonTxnReplayableResultSet.class.getDeclaredMethod("preForUpdateStreams", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = NonTxnReplayableResultSet.class.getDeclaredMethod("preForRowUpdates", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = NonTxnReplayableResultSet.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
    }
}

