/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;
import oracle.xdb.XMLType;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class NamedTypeAccessor
extends TypeAccessor {
    static final int MAXLENGTH = -1;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;

    NamedTypeAccessor(OracleStatement stmt, String typeName, short form, int external_type, boolean forBind) throws SQLException {
        super(Representation.NAMED_TYPE, stmt, -1, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$14, null, stmt, typeName, form, external_type, forBind);
            }
            this.init(stmt, 109, 109, form, forBind);
            this.initForDataAccess(external_type, 0, typeName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    NamedTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, String typeName) throws SQLException {
        super(Representation.NAMED_TYPE, stmt, -1, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$15, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
            }
            this.init(stmt, 109, 109, form, false);
            this.initForDescribe(109, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
            this.initForDataAccess(0, max_len, typeName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    NamedTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, String typeName, OracleType otype) throws SQLException {
        super(Representation.NAMED_TYPE, stmt, -1, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$16, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName, otype);
            }
            this.init(stmt, 109, 109, form, false);
            this.describeOtype = otype;
            this.initForDescribe(109, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
            this.internalOtype = otype;
            this.initForDataAccess(0, max_len, typeName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$16, null);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$16, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final OracleType otypeFromName(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void typeName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$0, this, string);
            }
            if (!this.outBind) {
                OracleNamedType oracleNamedType = TypeDescriptor.getTypeDescriptor((String)typeName, this.statement.connection).getPickler();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$0, this, oracleNamedType);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$0, this, null);
                }
                return oracleNamedType;
            }
            if (this.externalType == 2003) {
                OracleTypeCOLLECTION oracleTypeCOLLECTION = ArrayDescriptor.createDescriptor((String)typeName, (Connection)this.statement.connection).getOracleTypeCOLLECTION();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$0, this, oracleTypeCOLLECTION);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$0, this, null);
                }
                return oracleTypeCOLLECTION;
            }
            if (this.externalType == 2007 || this.externalType == 2009) {
                OracleNamedType oracleNamedType = OpaqueDescriptor.createDescriptor((String)typeName, (Connection)this.statement.connection).getPickler();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$0, this, oracleNamedType);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$0, this, null);
                }
                return oracleNamedType;
            }
            OracleTypeADT oracleTypeADT = StructDescriptor.createDescriptor((String)typeName, (Connection)this.statement.connection).getOracleTypeADT();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$0, this, oracleTypeADT);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$0, this, null);
            }
            return oracleTypeADT;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final CompletionStage<OracleType> otypeFromNameAsync(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void typeName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$1, this, string);
            }
            if (!this.outBind) {
                CompletionStage<OracleType> completionStage = TypeDescriptor.getTypeDescriptorAsync((String)typeName, this.statement.connection).thenApply(TypeDescriptor::getPickler);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$1, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$1, this, null);
                }
                return completionStage;
            }
            if (this.externalType == 2003) {
                CompletionStage<OracleType> completionStage = ArrayDescriptor.createDescriptorAsync((String)typeName, this.statement.connection).thenApply(ArrayDescriptor::getOracleTypeCOLLECTION);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$1, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$1, this, null);
                }
                return completionStage;
            }
            if (this.externalType == 2007 || this.externalType == 2009) {
                CompletionStage<OracleType> completionStage = OpaqueDescriptor.createDescriptorAsync((String)typeName, this.statement.connection).thenApply(TypeDescriptor::getPickler);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$1, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$1, this, null);
                }
                return completionStage;
            }
            CompletionStage<OracleType> completionStage = StructDescriptor.createDescriptorAsync((String)typeName, this.statement.connection).thenApply(CompletionStageUtil.normalCompletionHandler(StructDescriptor::getOracleTypeADT));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$1, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$1, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void typeName;
            void max_len;
            void external_type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$2, this, n2, n3, string);
            }
            super.initForDataAccess((int)external_type, (int)max_len, (String)typeName);
            this.byteLength = this.statement.connection.namedTypeAccessorByteLen;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$3, this, n2);
            }
            Object object = this.getObject((int)currentRow, this.statement.connection.getTypeMap());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$3, this, object);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$3, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            Map map2;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, n2, map);
            }
            if (this.isNull((int)currentRow)) {
                Object var6_4 = null;
                if (!bl) return null;
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, var6_4);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, null);
                return null;
            }
            if (this.externalType == 0) {
                Datum named_obj = this.getOracleObject((int)currentRow);
                if (named_obj == null) {
                    Object var6_5 = null;
                    if (!bl) return null;
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, var6_5);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, null);
                    return null;
                }
                if (named_obj instanceof STRUCT) {
                    Object object = ((STRUCT)named_obj).toJdbc(map2);
                    if (!bl) return object;
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, object);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, null);
                    return object;
                }
                if (named_obj instanceof OPAQUE) {
                    Object obj;
                    Object object = obj = ((OPAQUE)named_obj).toJdbc(map2);
                    if (!bl) return object;
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, object);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, null);
                    return object;
                }
                if (named_obj instanceof ARRAY) {
                    Object object = ((ARRAY)named_obj).toJdbc(map2);
                    if (!bl) return object;
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, object);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, null);
                    return object;
                }
                Object object = named_obj.toJdbc();
                if (!bl) return object;
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, object);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, null);
                return object;
            }
            switch (this.externalType) {
                case 2008: {
                    map2 = null;
                }
                case 2000: 
                case 2002: 
                case 2003: 
                case 2007: {
                    Datum named_obj = this.getOracleObject((int)currentRow);
                    if (named_obj == null) {
                        Object var6_10 = null;
                        if (!bl) return null;
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, var6_10);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, null);
                        return null;
                    }
                    if (named_obj instanceof STRUCT) {
                        Object object = ((STRUCT)named_obj).toJdbc(map2);
                        if (!bl) return object;
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, object);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, null);
                        return object;
                    }
                    if (named_obj instanceof ARRAY) {
                        Object object = ((ARRAY)named_obj).toJdbc(map2);
                        if (!bl) return object;
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, object);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, null);
                        return object;
                    }
                    Object object = named_obj.toJdbc();
                    if (!bl) return object;
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, object);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, null);
                    return object;
                }
                case 2009: {
                    SQLXML sQLXML;
                    Datum named_obj = this.getOracleObject((int)currentRow);
                    if (named_obj == null) {
                        Object var6_14 = null;
                        if (!bl) return null;
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, var6_14);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, null);
                        return null;
                    }
                    try {
                        sQLXML = (SQLXML)((Object)named_obj);
                        if (!bl) return sQLXML;
                    }
                    catch (ClassCastException classCastException) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                        if (!bl) throw sQLException;
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, sQLException);
                        throw sQLException;
                    }
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, sQLXML);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, null);
                    return sQLXML;
                }
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            if (!bl) throw sQLException;
            ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, sQLException);
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!bl) throw throwable;
            ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$4, this, throwable2);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                Datum datum = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, datum);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            byte[] data = this.pickledBytes((int)currentRow);
            if (data == null || data.length == 0) {
                Datum datum = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, datum);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            PhysicalConnection conn = this.statement.connection;
            OracleTypeADT otype = (OracleTypeADT)this.internalOtype;
            TypeDescriptor desc = TypeDescriptor.getTypeDescriptor(this.internalTypeName == null ? otype.getFullName() : this.internalTypeName, conn, data, 0L);
            switch (desc.getTypeCode()) {
                case 2003: {
                    ARRAY aRRAY = new ARRAY((ArrayDescriptor)desc, data, conn);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, aRRAY);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, null);
                    }
                    return aRRAY;
                }
                case 2002: {
                    STRUCT sTRUCT = new STRUCT((StructDescriptor)desc, data, conn);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, sTRUCT);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, null);
                    }
                    return sTRUCT;
                }
                case 2009: {
                    Datum datum = XMLFactory.createXML(new OPAQUE((OpaqueDescriptor)desc, data, conn));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, datum);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, null);
                    }
                    return datum;
                }
                case 2007: {
                    OPAQUE oPAQUE = new OPAQUE((OpaqueDescriptor)desc, data, conn);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, oPAQUE);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, null);
                    }
                    return oPAQUE;
                }
                case 2008: {
                    JAVA_STRUCT jAVA_STRUCT = new JAVA_STRUCT((StructDescriptor)desc, data, conn);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, jAVA_STRUCT);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, null);
                    }
                    return jAVA_STRUCT;
                }
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    OracleData getOracleData(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            OracleData oracleData;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$6, this, n2);
                }
                try {
                    void currentRow;
                    oracleData = (OracleData)this.getObject((int)currentRow);
                    if (!bl) break block7;
                }
                catch (ClassCastException ex) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$6, this, sQLException);
                    }
                    throw sQLException;
                }
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$6, this, oracleData);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$6, this, null);
            }
            return oracleData;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    ORAData getORAData(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            ORAData oRAData;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$7, this, n2);
                }
                try {
                    void currentRow;
                    oRAData = (ORAData)this.getObject((int)currentRow);
                    if (!bl) break block7;
                }
                catch (ClassCastException ex) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$7, this, sQLException);
                    }
                    throw sQLException;
                }
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$7, this, oRAData);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$7, this, null);
            }
            return oRAData;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    ARRAY getARRAY(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            ARRAY aRRAY;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$8, this, n2);
                }
                try {
                    void currentRow;
                    aRRAY = (ARRAY)this.getOracleObject((int)currentRow);
                    if (!bl) break block7;
                }
                catch (ClassCastException ex) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$8, this, sQLException);
                    }
                    throw sQLException;
                }
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$8, this, aRRAY);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$8, this, null);
            }
            return aRRAY;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    STRUCT getSTRUCT(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            STRUCT sTRUCT;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$9, this, n2);
                }
                try {
                    void currentRow;
                    sTRUCT = (STRUCT)this.getOracleObject((int)currentRow);
                    if (!bl) break block7;
                }
                catch (ClassCastException ex) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$9, this, sQLException);
                    }
                    throw sQLException;
                }
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$9, this, sTRUCT);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$9, this, null);
            }
            return sTRUCT;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Struct getStruct(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            Struct struct;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$10, this, n2);
                }
                try {
                    void currentRow;
                    struct = (Struct)((Object)this.getOracleObject((int)currentRow));
                    if (!bl) break block7;
                }
                catch (ClassCastException ex) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$10, this, sQLException);
                    }
                    throw sQLException;
                }
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$10, this, struct);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$10, this, null);
            }
            return struct;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    OPAQUE getOPAQUE(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            OPAQUE oPAQUE;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$11, this, n2);
                }
                try {
                    void currentRow;
                    oPAQUE = (OPAQUE)this.getOracleObject((int)currentRow);
                    if (!bl) break block7;
                }
                catch (ClassCastException ex) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$11, this, sQLException);
                    }
                    throw sQLException;
                }
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$11, this, oPAQUE);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$11, this, null);
            }
            return oPAQUE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    SQLXML getSQLXML(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            SQLXML sQLXML;
            block10: {
                OPAQUE opaque;
                block8: {
                    SQLXML sQLXML2;
                    block9: {
                        SQLXML sQLXML3;
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$12, this, n2);
                        }
                        try {
                            void currentRow;
                            opaque = (OPAQUE)this.getOracleObject((int)currentRow);
                            if (opaque != null) break block8;
                            sQLXML2 = sQLXML3 = null;
                            if (!bl) break block9;
                        }
                        catch (ClassCastException ex) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$12, this, sQLException);
                            }
                            throw sQLException;
                        }
                        ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$12, this, sQLXML3);
                        ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$12, this, null);
                    }
                    return sQLXML2;
                }
                sQLXML = (SQLXML)((Object)opaque);
                if (!bl) break block10;
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$12, this, sQLXML);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$12, this, null);
            }
            return sQLXML;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            Datum datum;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$13, this, n2);
            }
            if ((datum = this.getOracleObject((int)currentRow)) instanceof XMLType) {
                String string = ((XMLType)datum).getString();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$13, this, string);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$13, this, null);
                }
                return string;
            }
            String string = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$13, this, string);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$13, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NamedTypeAccessor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$16 = NamedTypeAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, String.class, OracleType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = NamedTypeAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = NamedTypeAccessor.class.getDeclaredConstructor(OracleStatement.class, String.class, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = NamedTypeAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NamedTypeAccessor.class.getDeclaredMethod("getSQLXML", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NamedTypeAccessor.class.getDeclaredMethod("getOPAQUE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NamedTypeAccessor.class.getDeclaredMethod("getStruct", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NamedTypeAccessor.class.getDeclaredMethod("getSTRUCT", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NamedTypeAccessor.class.getDeclaredMethod("getARRAY", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NamedTypeAccessor.class.getDeclaredMethod("getORAData", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NamedTypeAccessor.class.getDeclaredMethod("getOracleData", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NamedTypeAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NamedTypeAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NamedTypeAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NamedTypeAccessor.class.getDeclaredMethod("initForDataAccess", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NamedTypeAccessor.class.getDeclaredMethod("otypeFromNameAsync", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NamedTypeAccessor.class.getDeclaredMethod("otypeFromName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private static class XMLFactory {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        private XMLFactory() {
        }

        static Datum createXML(OPAQUE opq) throws SQLException {
            return XMLType.createXML((OPAQUE)opq);
        }

        static {
            try {
                $$$methodRef$$$1 = XMLFactory.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = XMLFactory.class.getDeclaredMethod("createXML", OPAQUE.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

