/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.runtime.util.InlinedProfileBuilder;

public abstract class InlinedProfileBag {
    protected static final int BRANCH_PROFILE_STATE_BITS = 1;
    protected static final int CONDITION_PROFILE_STATE_BITS = 2;
    private final InlineSupport.StateField state;

    protected InlinedProfileBag(InlineSupport.StateField state) {
        this.state = state;
    }

    protected final boolean profile(Node node, boolean value, int offset) {
        if (this.state != null) {
            int s = this.state.get(node);
            if (value) {
                int trueBit = 1 << offset;
                if ((s & trueBit) == 0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.state.set(node, s | trueBit);
                }
                return true;
            }
            int falseBit = 2 << offset;
            if ((s & falseBit) == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.state.set(node, s | falseBit);
            }
            return false;
        }
        return value;
    }

    protected final void enter(Node node, int offset) {
        if (this.state == null) {
            return;
        }
        int branchBit = 1 << offset;
        int s = this.state.get(node);
        if ((s & branchBit) == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.state.set(node, s | branchBit);
        }
    }

    public static final class Builder
    extends InlinedProfileBuilder
    implements AutoCloseable {
        public Builder(int length) {
            this(0, length);
        }

        public Builder(int offset, int length) {
            super(offset, length);
        }

        @Override
        public void close() {
            assert (this.stateFieldCursor == this.stateFieldStart + this.stateFieldLength) : this.stateFieldCursor;
        }
    }
}

