/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.database;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import us.fatehi.utility.SQLRuntimeException;
import us.fatehi.utility.Utility;
import us.fatehi.utility.ioresource.ClasspathInputResource;

public class SqlScript
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(SqlScript.class.getName());
    private static final boolean debug = Boolean.parseBoolean(System.getProperty(SqlScript.class.getCanonicalName() + ".debug", "false"));
    private final Reader scriptReader;
    private final String delimiter;
    private final Connection connection;

    public static void executeScriptFromResource(String scriptResource, Connection connection) {
        SqlScript.executeScriptFromResource(scriptResource, ";", connection);
    }

    public static void executeScriptFromResource(String scriptResource, String delimiter, Connection connection) {
        Utility.requireNotBlank(scriptResource, "No script resource line provided");
        Objects.requireNonNull(connection, "No database connection provided");
        try (BufferedReader scriptReader = new ClasspathInputResource(scriptResource).openNewInputReader(StandardCharsets.UTF_8);){
            SqlScript sqlScript = new SqlScript(scriptReader, delimiter, connection);
            sqlScript.run();
        }
        catch (Exception e) {
            throw new SQLRuntimeException("Could not read \"%s\"".formatted(scriptResource), e);
        }
    }

    public SqlScript(Reader scriptReader, String delimiter, Connection connection) {
        this.scriptReader = Objects.requireNonNull(scriptReader, "No script resource line provided");
        this.delimiter = Objects.requireNonNull(delimiter, "No delimiter provided");
        this.connection = Objects.requireNonNull(connection, "No database connection provided");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        boolean skip = "#".equals(this.delimiter);
        if (debug) {
            String lineLogMessage = "%s %s".formatted(this.scriptReader, skip ? "-- skip" : "-- execute, delimiting by " + this.delimiter);
            LOGGER.log(Level.INFO, lineLogMessage);
            System.out.println(lineLogMessage);
        }
        if (skip) {
            return;
        }
        String sql2 = null;
        try (Statement statement = this.connection.createStatement();){
            List<String> sqlList = this.readSql(new BufferedReader(this.scriptReader));
            for (String sql2 : sqlList) {
                try {
                    if (Pattern.matches("\\s+", sql2)) continue;
                    if (debug) {
                        LOGGER.log(Level.INFO, "\n" + sql2);
                    }
                    this.executeSql(sql2, statement);
                    if (this.connection.getAutoCommit()) continue;
                    this.connection.commit();
                }
                catch (SQLWarning e) {
                    int errorCode = e.getErrorCode();
                    if (errorCode == 5701 || errorCode == 5703 || errorCode == 1280) continue;
                    Throwable throwable = this.getCause(e);
                    throw new SQLRuntimeException(throwable);
                    return;
                }
            }
        }
        catch (Exception e) {
            Throwable throwable = this.getCause(e);
            System.err.println(throwable.getMessage());
            System.err.println(sql2);
            LOGGER.log(Level.WARNING, throwable.getMessage(), throwable);
            throw new SQLRuntimeException(e);
        }
    }

    private void executeSql(String sql, Statement statement) throws SQLException {
        boolean hasResults = statement.execute(sql);
        if (hasResults) {
            throw new SQLWarning("Results not expected from SQL%n%s%n".formatted(sql));
        }
        SQLWarning warnings = statement.getWarnings();
        statement.clearWarnings();
        if (warnings != null) {
            LOGGER.log(Level.WARNING, warnings.getMessage(), warnings);
        }
    }

    private Throwable getCause(Throwable e) {
        Throwable cause;
        Throwable result = e;
        while (null != (cause = result.getCause()) && result != cause) {
            result = cause;
        }
        return result;
    }

    private List<String> readSql(BufferedReader lineReader) throws IOException {
        String line;
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        while ((line = lineReader.readLine()) != null) {
            boolean isComment;
            String trimmedLine = line.strip();
            boolean bl = isComment = trimmedLine.startsWith("--") || trimmedLine.startsWith("//");
            if (!isComment && trimmedLine.endsWith(this.delimiter)) {
                sql.append(line, 0, line.lastIndexOf(this.delimiter));
                list.add(sql.toString());
                sql = new StringBuilder();
                continue;
            }
            sql.append(line);
            sql.append("\n");
        }
        if (!sql.isEmpty()) {
            list.add(sql.toString());
        }
        return list;
    }
}

