from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

LATVIAN_LANG_MODEL = {
    31: {  # 'A'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.LIKELY,  # 'B'
        48: SequenceLikelihood.LIKELY,  # 'C'
        40: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.LIKELY,  # 'K'
        33: SequenceLikelihood.LIKELY,  # 'L'
        38: SequenceLikelihood.LIKELY,  # 'M'
        44: SequenceLikelihood.LIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.POSITIVE,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        23: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.NEGATIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    41: {  # 'B'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.LIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    48: {  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    40: {  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.LIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.LIKELY,  # 'ž'
    },
    45: {  # 'E'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.LIKELY,  # 'C'
        40: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.LIKELY,  # 'K'
        33: SequenceLikelihood.LIKELY,  # 'L'
        38: SequenceLikelihood.LIKELY,  # 'M'
        44: SequenceLikelihood.LIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.LIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.NEGATIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.NEGATIVE,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    52: {  # 'F'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    49: {  # 'G'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    58: {  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    37: {  # 'I'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.LIKELY,  # 'C'
        40: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.LIKELY,  # 'J'
        35: SequenceLikelihood.LIKELY,  # 'K'
        33: SequenceLikelihood.LIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.LIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.NEGATIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.NEGATIVE,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    47: {  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.LIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.POSITIVE,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    35: {  # 'K'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    33: {  # 'L'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        34: SequenceLikelihood.LIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.LIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    38: {  # 'M'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.LIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.LIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    44: {  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.LIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    51: {  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.LIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.NEGATIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    30: {  # 'P'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.LIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.LIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    73: {  # 'Q'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.NEGATIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.NEGATIVE,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    43: {  # 'R'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.LIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    29: {  # 'S'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.LIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.LIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.LIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.LIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    32: {  # 'T'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        34: SequenceLikelihood.LIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    50: {  # 'U'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.LIKELY,  # 'M'
        44: SequenceLikelihood.LIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.NEGATIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.NEGATIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    34: {  # 'V'
        31: SequenceLikelihood.LIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.LIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.LIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    61: {  # 'W'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.NEGATIVE,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    63: {  # 'X'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.NEGATIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.NEGATIVE,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.NEGATIVE,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    66: {  # 'Y'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    55: {  # 'Z'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.LIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    1: {  # 'a'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.LIKELY,  # 'w'
        59: SequenceLikelihood.LIKELY,  # 'x'
        56: SequenceLikelihood.LIKELY,  # 'y'
        19: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.POSITIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.LIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.LIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.POSITIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.POSITIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    21: {  # 'b'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.LIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.LIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.POSITIVE,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    23: {  # 'c'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    14: {  # 'd'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.LIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    4: {  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.LIKELY,  # 'w'
        59: SequenceLikelihood.LIKELY,  # 'x'
        56: SequenceLikelihood.LIKELY,  # 'y'
        19: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.LIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.POSITIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.LIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.POSITIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.POSITIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    28: {  # 'f'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.LIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    22: {  # 'g'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.LIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.POSITIVE,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    39: {  # 'h'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.LIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    2: {  # 'i'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.LIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.LIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.LIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.LIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.POSITIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.POSITIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.LIKELY,  # 'ž'
    },
    17: {  # 'j'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.POSITIVE,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    11: {  # 'k'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.POSITIVE,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.LIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.LIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    13: {  # 'l'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        23: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.LIKELY,  # 'y'
        19: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.LIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.POSITIVE,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    12: {  # 'm'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.POSITIVE,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.LIKELY,  # 'ž'
    },
    8: {  # 'n'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.LIKELY,  # 'y'
        19: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.LIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.LIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.LIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.LIKELY,  # 'ž'
    },
    10: {  # 'o'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.LIKELY,  # 'w'
        59: SequenceLikelihood.LIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.LIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.POSITIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.LIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.LIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.POSITIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.LIKELY,  # 'ž'
    },
    15: {  # 'p'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        23: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.LIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.LIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.LIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.LIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.LIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    70: {  # 'q'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.NEGATIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.NEGATIVE,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.NEGATIVE,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    6: {  # 'r'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.LIKELY,  # 'y'
        19: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.POSITIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.POSITIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.LIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.POSITIVE,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.LIKELY,  # 'ž'
    },
    3: {  # 's'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        23: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.POSITIVE,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    5: {  # 't'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.LIKELY,  # 'y'
        19: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.LIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.LIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.LIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.POSITIVE,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    7: {  # 'u'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.LIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.LIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.POSITIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.POSITIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.LIKELY,  # 'ž'
    },
    16: {  # 'v'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    57: {  # 'w'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.LIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    59: {  # 'x'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.NEGATIVE,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    56: {  # 'y'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    19: {  # 'z'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.POSITIVE,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.LIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.LIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    60: {  # 'Ā'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.NEGATIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.NEGATIVE,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    9: {  # 'ā'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.LIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.LIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.LIKELY,  # 'ž'
    },
    67: {  # 'Č'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.NEGATIVE,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.NEGATIVE,  # 'b'
        23: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.NEGATIVE,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    54: {  # 'č'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        41: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        40: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        35: SequenceLikelihood.NEGATIVE,  # 'K'
        33: SequenceLikelihood.NEGATIVE,  # 'L'
        38: SequenceLikelihood.NEGATIVE,  # 'M'
        44: SequenceLikelihood.NEGATIVE,  # 'N'
        51: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        34: SequenceLikelihood.NEGATIVE,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    64: {  # 'Ē'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.NEGATIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.NEGATIVE,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    20: {  # 'ē'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.POSITIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.LIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.POSITIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.LIKELY,  # 'ž'
    },
    71: {  # 'Ģ'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.NEGATIVE,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.NEGATIVE,  # 'b'
        23: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.NEGATIVE,  # 'g'
        39: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.NEGATIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    46: {  # 'ģ'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        41: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        40: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        35: SequenceLikelihood.NEGATIVE,  # 'K'
        33: SequenceLikelihood.NEGATIVE,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.NEGATIVE,  # 'N'
        51: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        34: SequenceLikelihood.NEGATIVE,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.NEGATIVE,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.NEGATIVE,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    62: {  # 'Ī'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.LIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.NEGATIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.NEGATIVE,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.NEGATIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.NEGATIVE,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    18: {  # 'ī'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        23: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.LIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.LIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.LIKELY,  # 'ž'
    },
    65: {  # 'Ķ'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.NEGATIVE,  # 'b'
        23: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.NEGATIVE,  # 'g'
        39: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.NEGATIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    42: {  # 'ķ'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        41: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        40: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        35: SequenceLikelihood.NEGATIVE,  # 'K'
        33: SequenceLikelihood.NEGATIVE,  # 'L'
        38: SequenceLikelihood.NEGATIVE,  # 'M'
        44: SequenceLikelihood.NEGATIVE,  # 'N'
        51: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        34: SequenceLikelihood.NEGATIVE,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    69: {  # 'Ļ'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.NEGATIVE,  # 'b'
        23: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.NEGATIVE,  # 'g'
        39: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.NEGATIVE,  # 'l'
        12: SequenceLikelihood.NEGATIVE,  # 'm'
        8: SequenceLikelihood.NEGATIVE,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        3: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.NEGATIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    27: {  # 'ļ'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        40: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.NEGATIVE,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.NEGATIVE,  # 'N'
        51: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.LIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.LIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.LIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.LIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.POSITIVE,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    68: {  # 'Ņ'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.NEGATIVE,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.NEGATIVE,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.NEGATIVE,  # 'b'
        23: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.NEGATIVE,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.NEGATIVE,  # 'l'
        12: SequenceLikelihood.NEGATIVE,  # 'm'
        8: SequenceLikelihood.NEGATIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        3: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.NEGATIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    26: {  # 'ņ'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        40: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.NEGATIVE,  # 'M'
        44: SequenceLikelihood.NEGATIVE,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.NEGATIVE,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.LIKELY,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.LIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.POSITIVE,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    53: {  # 'Š'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.NEGATIVE,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.LIKELY,  # 'ā'
        67: SequenceLikelihood.UNLIKELY,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.LIKELY,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    24: {  # 'š'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        58: SequenceLikelihood.UNLIKELY,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.NEGATIVE,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        70: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        57: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.POSITIVE,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.POSITIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.POSITIVE,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.LIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.LIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.LIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    74: {  # 'Ū'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        4: SequenceLikelihood.NEGATIVE,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.NEGATIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.NEGATIVE,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.NEGATIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.NEGATIVE,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.NEGATIVE,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.NEGATIVE,  # 'ī'
        65: SequenceLikelihood.UNLIKELY,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.NEGATIVE,  # 'ņ'
        53: SequenceLikelihood.UNLIKELY,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    25: {  # 'ū'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        41: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        35: SequenceLikelihood.NEGATIVE,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.LIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.LIKELY,  # 'ž'
    },
    72: {  # 'Ž'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        41: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        40: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        35: SequenceLikelihood.UNLIKELY,  # 'K'
        33: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        44: SequenceLikelihood.UNLIKELY,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        34: SequenceLikelihood.NEGATIVE,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.NEGATIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        3: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ā'
        9: SequenceLikelihood.UNLIKELY,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ē'
        20: SequenceLikelihood.UNLIKELY,  # 'ē'
        71: SequenceLikelihood.UNLIKELY,  # 'Ģ'
        46: SequenceLikelihood.UNLIKELY,  # 'ģ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ī'
        18: SequenceLikelihood.UNLIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.NEGATIVE,  # 'ķ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ļ'
        27: SequenceLikelihood.NEGATIVE,  # 'ļ'
        68: SequenceLikelihood.UNLIKELY,  # 'Ņ'
        26: SequenceLikelihood.UNLIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.NEGATIVE,  # 'š'
        74: SequenceLikelihood.UNLIKELY,  # 'Ū'
        25: SequenceLikelihood.UNLIKELY,  # 'ū'
        72: SequenceLikelihood.UNLIKELY,  # 'Ž'
        36: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    36: {  # 'ž'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        41: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        40: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        58: SequenceLikelihood.NEGATIVE,  # 'H'
        37: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        35: SequenceLikelihood.NEGATIVE,  # 'K'
        33: SequenceLikelihood.NEGATIVE,  # 'L'
        38: SequenceLikelihood.NEGATIVE,  # 'M'
        44: SequenceLikelihood.NEGATIVE,  # 'N'
        51: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        73: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        34: SequenceLikelihood.NEGATIVE,  # 'V'
        61: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        4: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        39: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        70: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        57: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        56: SequenceLikelihood.UNLIKELY,  # 'y'
        19: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ā'
        9: SequenceLikelihood.POSITIVE,  # 'ā'
        67: SequenceLikelihood.NEGATIVE,  # 'Č'
        54: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ē'
        20: SequenceLikelihood.LIKELY,  # 'ē'
        71: SequenceLikelihood.NEGATIVE,  # 'Ģ'
        46: SequenceLikelihood.LIKELY,  # 'ģ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ī'
        18: SequenceLikelihood.LIKELY,  # 'ī'
        65: SequenceLikelihood.NEGATIVE,  # 'Ķ'
        42: SequenceLikelihood.UNLIKELY,  # 'ķ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ļ'
        27: SequenceLikelihood.UNLIKELY,  # 'ļ'
        68: SequenceLikelihood.NEGATIVE,  # 'Ņ'
        26: SequenceLikelihood.LIKELY,  # 'ņ'
        53: SequenceLikelihood.NEGATIVE,  # 'Š'
        24: SequenceLikelihood.UNLIKELY,  # 'š'
        74: SequenceLikelihood.NEGATIVE,  # 'Ū'
        25: SequenceLikelihood.LIKELY,  # 'ū'
        72: SequenceLikelihood.NEGATIVE,  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
}

# Character Mapping Table(s):
CP775_LATVIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 41,  # 'B'
    67: 48,  # 'C'
    68: 40,  # 'D'
    69: 45,  # 'E'
    70: 52,  # 'F'
    71: 49,  # 'G'
    72: 58,  # 'H'
    73: 37,  # 'I'
    74: 47,  # 'J'
    75: 35,  # 'K'
    76: 33,  # 'L'
    77: 38,  # 'M'
    78: 44,  # 'N'
    79: 51,  # 'O'
    80: 30,  # 'P'
    81: 73,  # 'Q'
    82: 43,  # 'R'
    83: 29,  # 'S'
    84: 32,  # 'T'
    85: 50,  # 'U'
    86: 34,  # 'V'
    87: 61,  # 'W'
    88: 63,  # 'X'
    89: 66,  # 'Y'
    90: 55,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 21,  # 'b'
    99: 23,  # 'c'
    100: 14,  # 'd'
    101: 4,  # 'e'
    102: 28,  # 'f'
    103: 22,  # 'g'
    104: 39,  # 'h'
    105: 2,  # 'i'
    106: 17,  # 'j'
    107: 11,  # 'k'
    108: 13,  # 'l'
    109: 12,  # 'm'
    110: 8,  # 'n'
    111: 10,  # 'o'
    112: 15,  # 'p'
    113: 70,  # 'q'
    114: 6,  # 'r'
    115: 3,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 16,  # 'v'
    119: 57,  # 'w'
    120: 59,  # 'x'
    121: 56,  # 'y'
    122: 19,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ć'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 9,  # 'ā'
    132: 0,  # 'ä'
    133: 46,  # 'ģ'
    134: 0,  # 'å'
    135: 0,  # 'ć'
    136: 0,  # 'ł'
    137: 20,  # 'ē'
    138: 0,  # 'Ŗ'
    139: 0,  # 'ŗ'
    140: 18,  # 'ī'
    141: 0,  # 'Ź'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ō'
    148: 0,  # 'ö'
    149: 71,  # 'Ģ'
    150: CharacterCategory.SYMBOL,  # '¢'
    151: 0,  # 'Ś'
    152: 0,  # 'ś'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 60,  # 'Ā'
    161: 62,  # 'Ī'
    162: 0,  # 'ó'
    163: 0,  # 'Ż'
    164: 0,  # 'ż'
    165: 0,  # 'ź'
    166: CharacterCategory.SYMBOL,  # '”'
    167: CharacterCategory.SYMBOL,  # '¦'
    168: CharacterCategory.SYMBOL,  # '©'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: 0,  # 'Ł'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Ą'
    182: 67,  # 'Č'
    183: 0,  # 'Ę'
    184: 0,  # 'Ė'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 0,  # 'Į'
    190: 53,  # 'Š'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'Ų'
    199: 74,  # 'Ū'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: 72,  # 'Ž'
    208: 0,  # 'ą'
    209: 54,  # 'č'
    210: 0,  # 'ę'
    211: 0,  # 'ė'
    212: 0,  # 'į'
    213: 24,  # 'š'
    214: 0,  # 'ų'
    215: 25,  # 'ū'
    216: 36,  # 'ž'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ō'
    227: 0,  # 'Ń'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'ń'
    232: 65,  # 'Ķ'
    233: 42,  # 'ķ'
    234: 69,  # 'Ļ'
    235: 27,  # 'ļ'
    236: 26,  # 'ņ'
    237: 64,  # 'Ē'
    238: 68,  # 'Ņ'
    239: CharacterCategory.SYMBOL,  # '’'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '“'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '„'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP775_LATVIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP775",
    language="Latvian",
    char_to_order_map=CP775_LATVIAN_CHAR_TO_ORDER,
    language_model=LATVIAN_LANG_MODEL,
    typical_positive_ratio=0.9648624744548474,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĀāČčĒēĢģĪīĶķĻļŅņŠšŪūŽž",
)

ISO_8859_4_LATVIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 41,  # 'B'
    67: 48,  # 'C'
    68: 40,  # 'D'
    69: 45,  # 'E'
    70: 52,  # 'F'
    71: 49,  # 'G'
    72: 58,  # 'H'
    73: 37,  # 'I'
    74: 47,  # 'J'
    75: 35,  # 'K'
    76: 33,  # 'L'
    77: 38,  # 'M'
    78: 44,  # 'N'
    79: 51,  # 'O'
    80: 30,  # 'P'
    81: 73,  # 'Q'
    82: 43,  # 'R'
    83: 29,  # 'S'
    84: 32,  # 'T'
    85: 50,  # 'U'
    86: 34,  # 'V'
    87: 61,  # 'W'
    88: 63,  # 'X'
    89: 66,  # 'Y'
    90: 55,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 21,  # 'b'
    99: 23,  # 'c'
    100: 14,  # 'd'
    101: 4,  # 'e'
    102: 28,  # 'f'
    103: 22,  # 'g'
    104: 39,  # 'h'
    105: 2,  # 'i'
    106: 17,  # 'j'
    107: 11,  # 'k'
    108: 13,  # 'l'
    109: 12,  # 'm'
    110: 8,  # 'n'
    111: 10,  # 'o'
    112: 15,  # 'p'
    113: 70,  # 'q'
    114: 6,  # 'r'
    115: 3,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 16,  # 'v'
    119: 57,  # 'w'
    120: 59,  # 'x'
    121: 56,  # 'y'
    122: 19,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: 0,  # 'ĸ'
    163: 0,  # 'Ŗ'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ĩ'
    166: 69,  # 'Ļ'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: 53,  # 'Š'
    170: 64,  # 'Ē'
    171: 71,  # 'Ģ'
    172: 0,  # 'Ŧ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 72,  # 'Ž'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 0,  # 'ą'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ŗ'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'ĩ'
    182: 27,  # 'ļ'
    183: 0,  # 'ˇ'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 24,  # 'š'
    186: 20,  # 'ē'
    187: 46,  # 'ģ'
    188: 0,  # 'ŧ'
    189: 0,  # 'Ŋ'
    190: 36,  # 'ž'
    191: 0,  # 'ŋ'
    192: 60,  # 'Ā'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Į'
    200: 67,  # 'Č'
    201: 0,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ė'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 62,  # 'Ī'
    208: 0,  # 'Đ'
    209: 68,  # 'Ņ'
    210: 0,  # 'Ō'
    211: 65,  # 'Ķ'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ų'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ũ'
    222: 74,  # 'Ū'
    223: 0,  # 'ß'
    224: 9,  # 'ā'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'į'
    232: 54,  # 'č'
    233: 0,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ė'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 18,  # 'ī'
    240: 0,  # 'đ'
    241: 26,  # 'ņ'
    242: 0,  # 'ō'
    243: 42,  # 'ķ'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ų'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ũ'
    254: 25,  # 'ū'
    255: CharacterCategory.SYMBOL,  # '˙'
}

ISO_8859_4_LATVIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-4",
    language="Latvian",
    char_to_order_map=ISO_8859_4_LATVIAN_CHAR_TO_ORDER,
    language_model=LATVIAN_LANG_MODEL,
    typical_positive_ratio=0.9648624744548474,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĀāČčĒēĢģĪīĶķĻļŅņŠšŪūŽž",
)

ISO_8859_13_LATVIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 41,  # 'B'
    67: 48,  # 'C'
    68: 40,  # 'D'
    69: 45,  # 'E'
    70: 52,  # 'F'
    71: 49,  # 'G'
    72: 58,  # 'H'
    73: 37,  # 'I'
    74: 47,  # 'J'
    75: 35,  # 'K'
    76: 33,  # 'L'
    77: 38,  # 'M'
    78: 44,  # 'N'
    79: 51,  # 'O'
    80: 30,  # 'P'
    81: 73,  # 'Q'
    82: 43,  # 'R'
    83: 29,  # 'S'
    84: 32,  # 'T'
    85: 50,  # 'U'
    86: 34,  # 'V'
    87: 61,  # 'W'
    88: 63,  # 'X'
    89: 66,  # 'Y'
    90: 55,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 21,  # 'b'
    99: 23,  # 'c'
    100: 14,  # 'd'
    101: 4,  # 'e'
    102: 28,  # 'f'
    103: 22,  # 'g'
    104: 39,  # 'h'
    105: 2,  # 'i'
    106: 17,  # 'j'
    107: 11,  # 'k'
    108: 13,  # 'l'
    109: 12,  # 'm'
    110: 8,  # 'n'
    111: 10,  # 'o'
    112: 15,  # 'p'
    113: 70,  # 'q'
    114: 6,  # 'r'
    115: 3,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 16,  # 'v'
    119: 57,  # 'w'
    120: 59,  # 'x'
    121: 56,  # 'y'
    122: 19,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '”'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '„'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ø'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ŗ'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Æ'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '“'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ø'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'ŗ'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: 0,  # 'æ'
    192: 0,  # 'Ą'
    193: 0,  # 'Į'
    194: 60,  # 'Ā'
    195: 0,  # 'Ć'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Ę'
    199: 64,  # 'Ē'
    200: 67,  # 'Č'
    201: 0,  # 'É'
    202: 0,  # 'Ź'
    203: 0,  # 'Ė'
    204: 71,  # 'Ģ'
    205: 65,  # 'Ķ'
    206: 62,  # 'Ī'
    207: 69,  # 'Ļ'
    208: 53,  # 'Š'
    209: 0,  # 'Ń'
    210: 68,  # 'Ņ'
    211: 0,  # 'Ó'
    212: 0,  # 'Ō'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ų'
    217: 0,  # 'Ł'
    218: 0,  # 'Ś'
    219: 74,  # 'Ū'
    220: 0,  # 'Ü'
    221: 0,  # 'Ż'
    222: 72,  # 'Ž'
    223: 0,  # 'ß'
    224: 0,  # 'ą'
    225: 0,  # 'į'
    226: 9,  # 'ā'
    227: 0,  # 'ć'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'ę'
    231: 20,  # 'ē'
    232: 54,  # 'č'
    233: 0,  # 'é'
    234: 0,  # 'ź'
    235: 0,  # 'ė'
    236: 46,  # 'ģ'
    237: 42,  # 'ķ'
    238: 18,  # 'ī'
    239: 27,  # 'ļ'
    240: 24,  # 'š'
    241: 0,  # 'ń'
    242: 26,  # 'ņ'
    243: 0,  # 'ó'
    244: 0,  # 'ō'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ų'
    249: 0,  # 'ł'
    250: 0,  # 'ś'
    251: 25,  # 'ū'
    252: 0,  # 'ü'
    253: 0,  # 'ż'
    254: 36,  # 'ž'
    255: CharacterCategory.SYMBOL,  # '’'
}

ISO_8859_13_LATVIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-13",
    language="Latvian",
    char_to_order_map=ISO_8859_13_LATVIAN_CHAR_TO_ORDER,
    language_model=LATVIAN_LANG_MODEL,
    typical_positive_ratio=0.9648624744548474,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĀāČčĒēĢģĪīĶķĻļŅņŠšŪūŽž",
)

WINDOWS_1257_LATVIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 41,  # 'B'
    67: 48,  # 'C'
    68: 40,  # 'D'
    69: 45,  # 'E'
    70: 52,  # 'F'
    71: 49,  # 'G'
    72: 58,  # 'H'
    73: 37,  # 'I'
    74: 47,  # 'J'
    75: 35,  # 'K'
    76: 33,  # 'L'
    77: 38,  # 'M'
    78: 44,  # 'N'
    79: 51,  # 'O'
    80: 30,  # 'P'
    81: 73,  # 'Q'
    82: 43,  # 'R'
    83: 29,  # 'S'
    84: 32,  # 'T'
    85: 50,  # 'U'
    86: 34,  # 'V'
    87: 61,  # 'W'
    88: 63,  # 'X'
    89: 66,  # 'Y'
    90: 55,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 21,  # 'b'
    99: 23,  # 'c'
    100: 14,  # 'd'
    101: 4,  # 'e'
    102: 28,  # 'f'
    103: 22,  # 'g'
    104: 39,  # 'h'
    105: 2,  # 'i'
    106: 17,  # 'j'
    107: 11,  # 'k'
    108: 13,  # 'l'
    109: 12,  # 'm'
    110: 8,  # 'n'
    111: 10,  # 'o'
    112: 15,  # 'p'
    113: 70,  # 'q'
    114: 6,  # 'r'
    115: 3,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 16,  # 'v'
    119: 57,  # 'w'
    120: 59,  # 'x'
    121: 56,  # 'y'
    122: 19,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: CharacterCategory.UNDEFINED,  # None
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.UNDEFINED,  # None
    137: CharacterCategory.SYMBOL,  # '‰'
    138: CharacterCategory.UNDEFINED,  # None
    139: CharacterCategory.SYMBOL,  # '‹'
    140: CharacterCategory.UNDEFINED,  # None
    141: CharacterCategory.SYMBOL,  # '¨'
    142: 0,  # 'ˇ'
    143: CharacterCategory.SYMBOL,  # '¸'
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: CharacterCategory.UNDEFINED,  # None
    155: CharacterCategory.SYMBOL,  # '›'
    156: CharacterCategory.UNDEFINED,  # None
    157: CharacterCategory.SYMBOL,  # '¯'
    158: CharacterCategory.SYMBOL,  # '˛'
    159: CharacterCategory.UNDEFINED,  # None
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.UNDEFINED,  # None
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.UNDEFINED,  # None
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ø'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ŗ'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Æ'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ø'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'ŗ'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: 0,  # 'æ'
    192: 0,  # 'Ą'
    193: 0,  # 'Į'
    194: 60,  # 'Ā'
    195: 0,  # 'Ć'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Ę'
    199: 64,  # 'Ē'
    200: 67,  # 'Č'
    201: 0,  # 'É'
    202: 0,  # 'Ź'
    203: 0,  # 'Ė'
    204: 71,  # 'Ģ'
    205: 65,  # 'Ķ'
    206: 62,  # 'Ī'
    207: 69,  # 'Ļ'
    208: 53,  # 'Š'
    209: 0,  # 'Ń'
    210: 68,  # 'Ņ'
    211: 0,  # 'Ó'
    212: 0,  # 'Ō'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ų'
    217: 0,  # 'Ł'
    218: 0,  # 'Ś'
    219: 74,  # 'Ū'
    220: 0,  # 'Ü'
    221: 0,  # 'Ż'
    222: 72,  # 'Ž'
    223: 0,  # 'ß'
    224: 0,  # 'ą'
    225: 0,  # 'į'
    226: 9,  # 'ā'
    227: 0,  # 'ć'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'ę'
    231: 20,  # 'ē'
    232: 54,  # 'č'
    233: 0,  # 'é'
    234: 0,  # 'ź'
    235: 0,  # 'ė'
    236: 46,  # 'ģ'
    237: 42,  # 'ķ'
    238: 18,  # 'ī'
    239: 27,  # 'ļ'
    240: 24,  # 'š'
    241: 0,  # 'ń'
    242: 26,  # 'ņ'
    243: 0,  # 'ó'
    244: 0,  # 'ō'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ų'
    249: 0,  # 'ł'
    250: 0,  # 'ś'
    251: 25,  # 'ū'
    252: 0,  # 'ü'
    253: 0,  # 'ż'
    254: 36,  # 'ž'
    255: CharacterCategory.SYMBOL,  # '˙'
}

WINDOWS_1257_LATVIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1257",
    language="Latvian",
    char_to_order_map=WINDOWS_1257_LATVIAN_CHAR_TO_ORDER,
    language_model=LATVIAN_LANG_MODEL,
    typical_positive_ratio=0.9648624744548474,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĀāČčĒēĢģĪīĶķĻļŅņŠšŪūŽž",
)
