from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

INDONESIAN_LANG_MODEL = {
    21: {  # 'A'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.LIKELY,  # 'J'
        29: SequenceLikelihood.POSITIVE,  # 'K'
        38: SequenceLikelihood.POSITIVE,  # 'L'
        26: SequenceLikelihood.POSITIVE,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.POSITIVE,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.POSITIVE,  # 'R'
        22: SequenceLikelihood.POSITIVE,  # 'S'
        28: SequenceLikelihood.POSITIVE,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.LIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.LIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.LIKELY,  # 'v'
        23: SequenceLikelihood.LIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.LIKELY,  # 'z'
    },
    27: {  # 'B'
        21: SequenceLikelihood.POSITIVE,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.POSITIVE,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    35: {  # 'C'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        37: SequenceLikelihood.POSITIVE,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.LIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    30: {  # 'D'
        21: SequenceLikelihood.POSITIVE,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.POSITIVE,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    42: {  # 'E'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.POSITIVE,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.LIKELY,  # 'W'
        51: SequenceLikelihood.LIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        32: SequenceLikelihood.LIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    43: {  # 'F'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.LIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    40: {  # 'G'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    39: {  # 'H'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    31: {  # 'I'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.POSITIVE,  # 'D'
        42: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.LIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        22: SequenceLikelihood.POSITIVE,  # 'S'
        28: SequenceLikelihood.POSITIVE,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.LIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    33: {  # 'J'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    29: {  # 'K'
        21: SequenceLikelihood.POSITIVE,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.LIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    38: {  # 'L'
        21: SequenceLikelihood.POSITIVE,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.POSITIVE,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    26: {  # 'M'
        21: SequenceLikelihood.POSITIVE,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.POSITIVE,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    34: {  # 'N'
        21: SequenceLikelihood.POSITIVE,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.POSITIVE,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.POSITIVE,  # 'I'
        33: SequenceLikelihood.LIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.LIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    37: {  # 'O'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.LIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        22: SequenceLikelihood.POSITIVE,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.LIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        32: SequenceLikelihood.LIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    25: {  # 'P'
        21: SequenceLikelihood.POSITIVE,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.POSITIVE,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.LIKELY,  # 'J'
        29: SequenceLikelihood.POSITIVE,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        37: SequenceLikelihood.POSITIVE,  # 'O'
        25: SequenceLikelihood.POSITIVE,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.POSITIVE,  # 'R'
        22: SequenceLikelihood.POSITIVE,  # 'S'
        28: SequenceLikelihood.POSITIVE,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.LIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    50: {  # 'Q'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.LIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    36: {  # 'R'
        21: SequenceLikelihood.POSITIVE,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.POSITIVE,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    22: {  # 'S'
        21: SequenceLikelihood.POSITIVE,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.POSITIVE,  # 'D'
        42: SequenceLikelihood.POSITIVE,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        31: SequenceLikelihood.POSITIVE,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.POSITIVE,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.LIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.LIKELY,  # 'V'
        44: SequenceLikelihood.LIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.LIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.LIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    28: {  # 'T'
        21: SequenceLikelihood.POSITIVE,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.POSITIVE,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        31: SequenceLikelihood.POSITIVE,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.LIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.LIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    41: {  # 'U'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        22: SequenceLikelihood.POSITIVE,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    47: {  # 'V'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    44: {  # 'W'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    51: {  # 'X'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    48: {  # 'Y'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.NEGATIVE,  # 'z'
    },
    52: {  # 'Z'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    1: {  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.POSITIVE,  # 'v'
        23: SequenceLikelihood.POSITIVE,  # 'w'
        45: SequenceLikelihood.POSITIVE,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.POSITIVE,  # 'z'
    },
    15: {  # 'b'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.LIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    20: {  # 'c'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    11: {  # 'd'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.LIKELY,  # 'v'
        23: SequenceLikelihood.POSITIVE,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.LIKELY,  # 'z'
    },
    3: {  # 'e'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.POSITIVE,  # 'v'
        23: SequenceLikelihood.POSITIVE,  # 'w'
        45: SequenceLikelihood.POSITIVE,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.LIKELY,  # 'z'
    },
    24: {  # 'f'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.LIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    12: {  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.LIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    17: {  # 'h'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.POSITIVE,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    4: {  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.LIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.POSITIVE,  # 'v'
        23: SequenceLikelihood.POSITIVE,  # 'w'
        45: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.POSITIVE,  # 'z'
    },
    19: {  # 'j'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.NEGATIVE,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    8: {  # 'k'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.LIKELY,  # 'v'
        23: SequenceLikelihood.LIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    13: {  # 'l'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.LIKELY,  # 'v'
        23: SequenceLikelihood.LIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    10: {  # 'm'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    2: {  # 'n'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.POSITIVE,  # 'v'
        23: SequenceLikelihood.LIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.LIKELY,  # 'z'
    },
    16: {  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.POSITIVE,  # 'v'
        23: SequenceLikelihood.POSITIVE,  # 'w'
        45: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.LIKELY,  # 'z'
    },
    14: {  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    49: {  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    6: {  # 'r'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.LIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.POSITIVE,  # 'v'
        23: SequenceLikelihood.POSITIVE,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.LIKELY,  # 'z'
    },
    9: {  # 's'
        21: SequenceLikelihood.LIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.POSITIVE,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    5: {  # 't'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.LIKELY,  # 'v'
        23: SequenceLikelihood.POSITIVE,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        46: SequenceLikelihood.LIKELY,  # 'z'
    },
    7: {  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.LIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        32: SequenceLikelihood.LIKELY,  # 'v'
        23: SequenceLikelihood.LIKELY,  # 'w'
        45: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.LIKELY,  # 'z'
    },
    32: {  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    23: {  # 'w'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.NEGATIVE,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.POSITIVE,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    45: {  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    18: {  # 'y'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.LIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.LIKELY,  # 'n'
        16: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.LIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'z'
    },
    46: {  # 'z'
        21: SequenceLikelihood.UNLIKELY,  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        42: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        33: SequenceLikelihood.UNLIKELY,  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'K'
        38: SequenceLikelihood.UNLIKELY,  # 'L'
        26: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        37: SequenceLikelihood.UNLIKELY,  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'P'
        50: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        22: SequenceLikelihood.UNLIKELY,  # 'S'
        28: SequenceLikelihood.UNLIKELY,  # 'T'
        41: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        44: SequenceLikelihood.UNLIKELY,  # 'W'
        51: SequenceLikelihood.UNLIKELY,  # 'X'
        48: SequenceLikelihood.UNLIKELY,  # 'Y'
        52: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        16: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        49: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        32: SequenceLikelihood.UNLIKELY,  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'w'
        45: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        46: SequenceLikelihood.LIKELY,  # 'z'
    },
}

# Character Mapping Table(s):
CP037_INDONESIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 0,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 0,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 0,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 0,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 0,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 0,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 15,  # 'b'
    131: 20,  # 'c'
    132: 11,  # 'd'
    133: 3,  # 'e'
    134: 24,  # 'f'
    135: 12,  # 'g'
    136: 17,  # 'h'
    137: 4,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 19,  # 'j'
    146: 8,  # 'k'
    147: 13,  # 'l'
    148: 10,  # 'm'
    149: 2,  # 'n'
    150: 16,  # 'o'
    151: 14,  # 'p'
    152: 49,  # 'q'
    153: 6,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 9,  # 's'
    163: 5,  # 't'
    164: 7,  # 'u'
    165: 32,  # 'v'
    166: 23,  # 'w'
    167: 45,  # 'x'
    168: 18,  # 'y'
    169: 46,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 21,  # 'A'
    194: 27,  # 'B'
    195: 35,  # 'C'
    196: 30,  # 'D'
    197: 42,  # 'E'
    198: 43,  # 'F'
    199: 40,  # 'G'
    200: 39,  # 'H'
    201: 31,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 33,  # 'J'
    210: 29,  # 'K'
    211: 38,  # 'L'
    212: 26,  # 'M'
    213: 34,  # 'N'
    214: 37,  # 'O'
    215: 25,  # 'P'
    216: 50,  # 'Q'
    217: 36,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 0,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 22,  # 'S'
    227: 28,  # 'T'
    228: 41,  # 'U'
    229: 47,  # 'V'
    230: 44,  # 'W'
    231: 51,  # 'X'
    232: 48,  # 'Y'
    233: 52,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 0,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP037_INDONESIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP037",
    language="Indonesian",
    char_to_order_map=CP037_INDONESIAN_CHAR_TO_ORDER,
    language_model=INDONESIAN_LANG_MODEL,
    typical_positive_ratio=0.9894995727977018,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz",
)

CP437_INDONESIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 21,  # 'A'
    66: 27,  # 'B'
    67: 35,  # 'C'
    68: 30,  # 'D'
    69: 42,  # 'E'
    70: 43,  # 'F'
    71: 40,  # 'G'
    72: 39,  # 'H'
    73: 31,  # 'I'
    74: 33,  # 'J'
    75: 29,  # 'K'
    76: 38,  # 'L'
    77: 26,  # 'M'
    78: 34,  # 'N'
    79: 37,  # 'O'
    80: 25,  # 'P'
    81: 50,  # 'Q'
    82: 36,  # 'R'
    83: 22,  # 'S'
    84: 28,  # 'T'
    85: 41,  # 'U'
    86: 47,  # 'V'
    87: 44,  # 'W'
    88: 51,  # 'X'
    89: 48,  # 'Y'
    90: 52,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 15,  # 'b'
    99: 20,  # 'c'
    100: 11,  # 'd'
    101: 3,  # 'e'
    102: 24,  # 'f'
    103: 12,  # 'g'
    104: 17,  # 'h'
    105: 4,  # 'i'
    106: 19,  # 'j'
    107: 8,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 2,  # 'n'
    111: 16,  # 'o'
    112: 14,  # 'p'
    113: 49,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 32,  # 'v'
    119: 23,  # 'w'
    120: 45,  # 'x'
    121: 18,  # 'y'
    122: 46,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP437_INDONESIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP437",
    language="Indonesian",
    char_to_order_map=CP437_INDONESIAN_CHAR_TO_ORDER,
    language_model=INDONESIAN_LANG_MODEL,
    typical_positive_ratio=0.9894995727977018,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz",
)

CP500_INDONESIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 0,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 0,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 0,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 0,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 0,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 0,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 15,  # 'b'
    131: 20,  # 'c'
    132: 11,  # 'd'
    133: 3,  # 'e'
    134: 24,  # 'f'
    135: 12,  # 'g'
    136: 17,  # 'h'
    137: 4,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 19,  # 'j'
    146: 8,  # 'k'
    147: 13,  # 'l'
    148: 10,  # 'm'
    149: 2,  # 'n'
    150: 16,  # 'o'
    151: 14,  # 'p'
    152: 49,  # 'q'
    153: 6,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 9,  # 's'
    163: 5,  # 't'
    164: 7,  # 'u'
    165: 32,  # 'v'
    166: 23,  # 'w'
    167: 45,  # 'x'
    168: 18,  # 'y'
    169: 46,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 21,  # 'A'
    194: 27,  # 'B'
    195: 35,  # 'C'
    196: 30,  # 'D'
    197: 42,  # 'E'
    198: 43,  # 'F'
    199: 40,  # 'G'
    200: 39,  # 'H'
    201: 31,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 33,  # 'J'
    210: 29,  # 'K'
    211: 38,  # 'L'
    212: 26,  # 'M'
    213: 34,  # 'N'
    214: 37,  # 'O'
    215: 25,  # 'P'
    216: 50,  # 'Q'
    217: 36,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 0,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 22,  # 'S'
    227: 28,  # 'T'
    228: 41,  # 'U'
    229: 47,  # 'V'
    230: 44,  # 'W'
    231: 51,  # 'X'
    232: 48,  # 'Y'
    233: 52,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 0,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP500_INDONESIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP500",
    language="Indonesian",
    char_to_order_map=CP500_INDONESIAN_CHAR_TO_ORDER,
    language_model=INDONESIAN_LANG_MODEL,
    typical_positive_ratio=0.9894995727977018,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz",
)

CP850_INDONESIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 21,  # 'A'
    66: 27,  # 'B'
    67: 35,  # 'C'
    68: 30,  # 'D'
    69: 42,  # 'E'
    70: 43,  # 'F'
    71: 40,  # 'G'
    72: 39,  # 'H'
    73: 31,  # 'I'
    74: 33,  # 'J'
    75: 29,  # 'K'
    76: 38,  # 'L'
    77: 26,  # 'M'
    78: 34,  # 'N'
    79: 37,  # 'O'
    80: 25,  # 'P'
    81: 50,  # 'Q'
    82: 36,  # 'R'
    83: 22,  # 'S'
    84: 28,  # 'T'
    85: 41,  # 'U'
    86: 47,  # 'V'
    87: 44,  # 'W'
    88: 51,  # 'X'
    89: 48,  # 'Y'
    90: 52,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 15,  # 'b'
    99: 20,  # 'c'
    100: 11,  # 'd'
    101: 3,  # 'e'
    102: 24,  # 'f'
    103: 12,  # 'g'
    104: 17,  # 'h'
    105: 4,  # 'i'
    106: 19,  # 'j'
    107: 8,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 2,  # 'n'
    111: 16,  # 'o'
    112: 14,  # 'p'
    113: 49,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 32,  # 'v'
    119: 23,  # 'w'
    120: 45,  # 'x'
    121: 18,  # 'y'
    122: 46,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: 0,  # 'ı'
    214: 0,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 0,  # 'Û'
    235: 0,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP850_INDONESIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP850",
    language="Indonesian",
    char_to_order_map=CP850_INDONESIAN_CHAR_TO_ORDER,
    language_model=INDONESIAN_LANG_MODEL,
    typical_positive_ratio=0.9894995727977018,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz",
)

CP858_INDONESIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 21,  # 'A'
    66: 27,  # 'B'
    67: 35,  # 'C'
    68: 30,  # 'D'
    69: 42,  # 'E'
    70: 43,  # 'F'
    71: 40,  # 'G'
    72: 39,  # 'H'
    73: 31,  # 'I'
    74: 33,  # 'J'
    75: 29,  # 'K'
    76: 38,  # 'L'
    77: 26,  # 'M'
    78: 34,  # 'N'
    79: 37,  # 'O'
    80: 25,  # 'P'
    81: 50,  # 'Q'
    82: 36,  # 'R'
    83: 22,  # 'S'
    84: 28,  # 'T'
    85: 41,  # 'U'
    86: 47,  # 'V'
    87: 44,  # 'W'
    88: 51,  # 'X'
    89: 48,  # 'Y'
    90: 52,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 15,  # 'b'
    99: 20,  # 'c'
    100: 11,  # 'd'
    101: 3,  # 'e'
    102: 24,  # 'f'
    103: 12,  # 'g'
    104: 17,  # 'h'
    105: 4,  # 'i'
    106: 19,  # 'j'
    107: 8,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 2,  # 'n'
    111: 16,  # 'o'
    112: 14,  # 'p'
    113: 49,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 32,  # 'v'
    119: 23,  # 'w'
    120: 45,  # 'x'
    121: 18,  # 'y'
    122: 46,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: CharacterCategory.SYMBOL,  # '€'
    214: 0,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 0,  # 'Û'
    235: 0,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP858_INDONESIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP858",
    language="Indonesian",
    char_to_order_map=CP858_INDONESIAN_CHAR_TO_ORDER,
    language_model=INDONESIAN_LANG_MODEL,
    typical_positive_ratio=0.9894995727977018,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz",
)

ISO_8859_1_INDONESIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 21,  # 'A'
    66: 27,  # 'B'
    67: 35,  # 'C'
    68: 30,  # 'D'
    69: 42,  # 'E'
    70: 43,  # 'F'
    71: 40,  # 'G'
    72: 39,  # 'H'
    73: 31,  # 'I'
    74: 33,  # 'J'
    75: 29,  # 'K'
    76: 38,  # 'L'
    77: 26,  # 'M'
    78: 34,  # 'N'
    79: 37,  # 'O'
    80: 25,  # 'P'
    81: 50,  # 'Q'
    82: 36,  # 'R'
    83: 22,  # 'S'
    84: 28,  # 'T'
    85: 41,  # 'U'
    86: 47,  # 'V'
    87: 44,  # 'W'
    88: 51,  # 'X'
    89: 48,  # 'Y'
    90: 52,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 15,  # 'b'
    99: 20,  # 'c'
    100: 11,  # 'd'
    101: 3,  # 'e'
    102: 24,  # 'f'
    103: 12,  # 'g'
    104: 17,  # 'h'
    105: 4,  # 'i'
    106: 19,  # 'j'
    107: 8,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 2,  # 'n'
    111: 16,  # 'o'
    112: 14,  # 'p'
    113: 49,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 32,  # 'v'
    119: 23,  # 'w'
    120: 45,  # 'x'
    121: 18,  # 'y'
    122: 46,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_1_INDONESIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-1",
    language="Indonesian",
    char_to_order_map=ISO_8859_1_INDONESIAN_CHAR_TO_ORDER,
    language_model=INDONESIAN_LANG_MODEL,
    typical_positive_ratio=0.9894995727977018,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz",
)

ISO_8859_15_INDONESIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 21,  # 'A'
    66: 27,  # 'B'
    67: 35,  # 'C'
    68: 30,  # 'D'
    69: 42,  # 'E'
    70: 43,  # 'F'
    71: 40,  # 'G'
    72: 39,  # 'H'
    73: 31,  # 'I'
    74: 33,  # 'J'
    75: 29,  # 'K'
    76: 38,  # 'L'
    77: 26,  # 'M'
    78: 34,  # 'N'
    79: 37,  # 'O'
    80: 25,  # 'P'
    81: 50,  # 'Q'
    82: 36,  # 'R'
    83: 22,  # 'S'
    84: 28,  # 'T'
    85: 41,  # 'U'
    86: 47,  # 'V'
    87: 44,  # 'W'
    88: 51,  # 'X'
    89: 48,  # 'Y'
    90: 52,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 15,  # 'b'
    99: 20,  # 'c'
    100: 11,  # 'd'
    101: 3,  # 'e'
    102: 24,  # 'f'
    103: 12,  # 'g'
    104: 17,  # 'h'
    105: 4,  # 'i'
    106: 19,  # 'j'
    107: 8,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 2,  # 'n'
    111: 16,  # 'o'
    112: 14,  # 'p'
    113: 49,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 32,  # 'v'
    119: 23,  # 'w'
    120: 45,  # 'x'
    121: 18,  # 'y'
    122: 46,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: 0,  # 'Ž'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_15_INDONESIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-15",
    language="Indonesian",
    char_to_order_map=ISO_8859_15_INDONESIAN_CHAR_TO_ORDER,
    language_model=INDONESIAN_LANG_MODEL,
    typical_positive_ratio=0.9894995727977018,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz",
)

MACROMAN_INDONESIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 21,  # 'A'
    66: 27,  # 'B'
    67: 35,  # 'C'
    68: 30,  # 'D'
    69: 42,  # 'E'
    70: 43,  # 'F'
    71: 40,  # 'G'
    72: 39,  # 'H'
    73: 31,  # 'I'
    74: 33,  # 'J'
    75: 29,  # 'K'
    76: 38,  # 'L'
    77: 26,  # 'M'
    78: 34,  # 'N'
    79: 37,  # 'O'
    80: 25,  # 'P'
    81: 50,  # 'Q'
    82: 36,  # 'R'
    83: 22,  # 'S'
    84: 28,  # 'T'
    85: 41,  # 'U'
    86: 47,  # 'V'
    87: 44,  # 'W'
    88: 51,  # 'X'
    89: 48,  # 'Y'
    90: 52,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 15,  # 'b'
    99: 20,  # 'c'
    100: 11,  # 'd'
    101: 3,  # 'e'
    102: 24,  # 'f'
    103: 12,  # 'g'
    104: 17,  # 'h'
    105: 4,  # 'i'
    106: 19,  # 'j'
    107: 8,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 2,  # 'n'
    111: 16,  # 'o'
    112: 14,  # 'p'
    113: 49,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 32,  # 'v'
    119: 23,  # 'w'
    120: 45,  # 'x'
    121: 18,  # 'y'
    122: 46,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Å'
    130: 0,  # 'Ç'
    131: 0,  # 'É'
    132: 0,  # 'Ñ'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 0,  # 'á'
    136: 0,  # 'à'
    137: 0,  # 'â'
    138: 0,  # 'ä'
    139: 0,  # 'ã'
    140: 0,  # 'å'
    141: 0,  # 'ç'
    142: 0,  # 'é'
    143: 0,  # 'è'
    144: 0,  # 'ê'
    145: 0,  # 'ë'
    146: 0,  # 'í'
    147: 0,  # 'ì'
    148: 0,  # 'î'
    149: 0,  # 'ï'
    150: 0,  # 'ñ'
    151: 0,  # 'ó'
    152: 0,  # 'ò'
    153: 0,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 0,  # 'ú'
    157: 0,  # 'ù'
    158: 0,  # 'û'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 0,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 0,  # 'Œ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ÿ'
    217: 0,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ﬁ'
    223: 0,  # 'ﬂ'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 0,  # 'Â'
    230: 0,  # 'Ê'
    231: 0,  # 'Á'
    232: 0,  # 'Ë'
    233: 0,  # 'È'
    234: 0,  # 'Í'
    235: 0,  # 'Î'
    236: 0,  # 'Ï'
    237: 0,  # 'Ì'
    238: 0,  # 'Ó'
    239: 0,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 0,  # 'Ò'
    242: 0,  # 'Ú'
    243: 0,  # 'Û'
    244: 0,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACROMAN_INDONESIAN_MODEL = SingleByteCharSetModel(
    charset_name="MacRoman",
    language="Indonesian",
    char_to_order_map=MACROMAN_INDONESIAN_CHAR_TO_ORDER,
    language_model=INDONESIAN_LANG_MODEL,
    typical_positive_ratio=0.9894995727977018,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz",
)

WINDOWS_1252_INDONESIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 21,  # 'A'
    66: 27,  # 'B'
    67: 35,  # 'C'
    68: 30,  # 'D'
    69: 42,  # 'E'
    70: 43,  # 'F'
    71: 40,  # 'G'
    72: 39,  # 'H'
    73: 31,  # 'I'
    74: 33,  # 'J'
    75: 29,  # 'K'
    76: 38,  # 'L'
    77: 26,  # 'M'
    78: 34,  # 'N'
    79: 37,  # 'O'
    80: 25,  # 'P'
    81: 50,  # 'Q'
    82: 36,  # 'R'
    83: 22,  # 'S'
    84: 28,  # 'T'
    85: 41,  # 'U'
    86: 47,  # 'V'
    87: 44,  # 'W'
    88: 51,  # 'X'
    89: 48,  # 'Y'
    90: 52,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 15,  # 'b'
    99: 20,  # 'c'
    100: 11,  # 'd'
    101: 3,  # 'e'
    102: 24,  # 'f'
    103: 12,  # 'g'
    104: 17,  # 'h'
    105: 4,  # 'i'
    106: 19,  # 'j'
    107: 8,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 2,  # 'n'
    111: 16,  # 'o'
    112: 14,  # 'p'
    113: 49,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 32,  # 'v'
    119: 23,  # 'w'
    120: 45,  # 'x'
    121: 18,  # 'y'
    122: 46,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: 0,  # 'Ž'
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: 0,  # 'ž'
    159: 0,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

WINDOWS_1252_INDONESIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1252",
    language="Indonesian",
    char_to_order_map=WINDOWS_1252_INDONESIAN_CHAR_TO_ORDER,
    language_model=INDONESIAN_LANG_MODEL,
    typical_positive_ratio=0.9894995727977018,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz",
)
