/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.request;

import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.opensearch.rest.RestRequest;
import org.opensearch.sql.ppl.domain.PPLQueryRequest;
import org.opensearch.sql.protocol.response.format.Format;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;

public class PPLQueryRequestFactory {
    private static final Logger LOG = LogManager.getLogger(PPLQueryRequestFactory.class);
    private static final String PPL_URL_PARAM_KEY = "ppl";
    private static final String PPL_FIELD_NAME = "query";
    private static final String QUERY_PARAMS_FORMAT = "format";
    private static final String QUERY_PARAMS_EXPLAIN_MODE = "mode";
    private static final String QUERY_PARAMS_SANITIZE = "sanitize";
    private static final String DEFAULT_RESPONSE_FORMAT = "jdbc";
    private static final String DEFAULT_EXPLAIN_FORMAT = "json";
    private static final String DEFAULT_EXPLAIN_MODE = "standard";
    private static final String QUERY_PARAMS_PRETTY = "pretty";
    private static final String QUERY_PARAMS_PROFILE = "profile";

    public static PPLQueryRequest getPPLRequest(RestRequest request) {
        switch (request.method()) {
            case GET: {
                return PPLQueryRequestFactory.parsePPLRequestFromUrl(request);
            }
            case POST: {
                return PPLQueryRequestFactory.parsePPLRequestFromPayload(request);
            }
        }
        throw new IllegalArgumentException("OpenSearch PPL doesn't supported HTTP " + request.method().name());
    }

    private static PPLQueryRequest parsePPLRequestFromUrl(RestRequest restRequest) {
        String ppl = restRequest.param(PPL_URL_PARAM_KEY);
        if (ppl == null) {
            throw new IllegalArgumentException("Cannot find ppl parameter from the URL");
        }
        return new PPLQueryRequest(ppl, null, restRequest.path());
    }

    private static PPLQueryRequest parsePPLRequestFromPayload(RestRequest restRequest) {
        String explainMode;
        String content = restRequest.content().utf8ToString();
        Format format = PPLQueryRequestFactory.getFormat(restRequest.params(), restRequest.rawPath());
        if (Format.isExplainMode((Format)format)) {
            LOG.warn("Using 'format' parameter for explain mode is deprecated. Please use 'mode' parameter instead. This will be removed in 4.x.");
            explainMode = format.getFormatName();
            format = Format.JSON;
        } else {
            explainMode = PPLQueryRequestFactory.getExplainMode(restRequest.params(), restRequest.rawPath());
        }
        boolean pretty = PPLQueryRequestFactory.getPrettyOption(restRequest.params());
        try {
            JSONObject jsonContent = new JSONObject(content);
            boolean profileRequested = jsonContent.optBoolean(QUERY_PARAMS_PROFILE, false);
            String queryString = jsonContent.optString(PPL_FIELD_NAME, "");
            boolean enableProfile = profileRequested && PPLQueryRequestFactory.isProfileSupported(restRequest.path(), format, queryString);
            PPLQueryRequest pplRequest = new PPLQueryRequest(jsonContent.getString(PPL_FIELD_NAME), jsonContent, restRequest.path(), format.getFormatName(), explainMode, enableProfile);
            if (format.equals((Object)Format.CSV)) {
                pplRequest.sanitize(PPLQueryRequestFactory.getSanitizeOption(restRequest.params()));
            }
            if (pretty) {
                pplRequest.style(JsonResponseFormatter.Style.PRETTY);
            }
            return pplRequest;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Failed to parse request payload", e);
        }
    }

    private static Format getFormat(Map<String, String> requestParams, String path) {
        Optional optionalFormat;
        String formatName = requestParams.containsKey(QUERY_PARAMS_FORMAT) ? requestParams.get(QUERY_PARAMS_FORMAT).toLowerCase() : (PPLQueryRequestFactory.isExplainRequest(path) ? DEFAULT_EXPLAIN_FORMAT : DEFAULT_RESPONSE_FORMAT);
        Optional optional = optionalFormat = PPLQueryRequestFactory.isExplainRequest(path) ? Format.ofExplain((String)formatName) : Format.of((String)formatName);
        if (optionalFormat.isPresent()) {
            return (Format)optionalFormat.get();
        }
        throw new IllegalArgumentException("Failed to create executor due to unknown response format: " + formatName);
    }

    private static boolean isExplainRequest(String path) {
        return path != null && path.endsWith("/_explain");
    }

    private static boolean getSanitizeOption(Map<String, String> requestParams) {
        if (requestParams.containsKey(QUERY_PARAMS_SANITIZE)) {
            return Boolean.parseBoolean(requestParams.get(QUERY_PARAMS_SANITIZE));
        }
        return true;
    }

    private static boolean getPrettyOption(Map<String, String> requestParams) {
        if (requestParams.containsKey(QUERY_PARAMS_PRETTY)) {
            String prettyValue = requestParams.get(QUERY_PARAMS_PRETTY);
            if (prettyValue.isEmpty()) {
                return true;
            }
            return Boolean.parseBoolean(prettyValue);
        }
        return false;
    }

    private static boolean isProfileSupported(String path, Format format, String query) {
        boolean explainPath = PPLQueryRequestFactory.isExplainRequest(path);
        boolean explainQuery = query != null && query.trim().toLowerCase().startsWith("explain");
        boolean isJdbcFormat = format != null && DEFAULT_RESPONSE_FORMAT.equalsIgnoreCase(format.getFormatName());
        return !explainPath && !explainQuery && isJdbcFormat;
    }

    private static String getExplainMode(Map<String, String> requestParams, String path) {
        if (!PPLQueryRequestFactory.isExplainRequest(path)) {
            return null;
        }
        return requestParams.getOrDefault(QUERY_PARAMS_EXPLAIN_MODE, DEFAULT_EXPLAIN_MODE).toLowerCase();
    }
}

