/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.monitoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.notifications.core.repackage.com.amazonaws.SdkClientException;
import org.opensearch.notifications.core.repackage.com.amazonaws.monitoring.CsmConfiguration;
import org.opensearch.notifications.core.repackage.com.amazonaws.monitoring.CsmConfigurationProvider;
import org.opensearch.notifications.core.repackage.org.apache.commons.logging.Log;
import org.opensearch.notifications.core.repackage.org.apache.commons.logging.LogFactory;

public class CsmConfigurationProviderChain
implements CsmConfigurationProvider {
    private static final Log log = LogFactory.getLog(CsmConfigurationProviderChain.class);
    private final List<CsmConfigurationProvider> providers = new ArrayList<CsmConfigurationProvider>();

    public CsmConfigurationProviderChain(CsmConfigurationProvider ... providers) {
        if (providers != null) {
            Collections.addAll(this.providers, providers);
        }
    }

    @Override
    public CsmConfiguration getConfiguration() {
        for (CsmConfigurationProvider p : this.providers) {
            try {
                return p.getConfiguration();
            }
            catch (SdkClientException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Unable to load configuration from " + p.toString() + ": " + e.getMessage()));
            }
        }
        throw new SdkClientException("Could not resolve client side monitoring configuration from the configured providers in the chain");
    }
}

