/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.vectorvalues;

import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.apache.lucene.index.KnnVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesIterator;
import org.opensearch.knn.index.vectorvalues.VectorValueExtractorStrategy;

public class KNNBinaryVectorValues
extends KNNVectorValues<byte[]> {
    KNNBinaryVectorValues(KNNVectorValuesIterator vectorValuesIterator) {
        super(vectorValuesIterator);
    }

    @Override
    public byte[] getVector() throws IOException {
        byte[] vector = VectorValueExtractorStrategy.extractBinaryVector(this.vectorValuesIterator);
        this.dimension = vector.length * 8;
        this.bytesPerVector = vector.length;
        return vector;
    }

    @Override
    public byte[] conditionalCloneVector() throws IOException {
        byte[] vector = this.getVector();
        if (this.vectorValuesIterator.getDocIdSetIterator() instanceof KnnVectorValues.DocIndexIterator) {
            return Arrays.copyOf(vector, vector.length);
        }
        return vector;
    }

    @Override
    @Generated
    public String toString() {
        return "KNNBinaryVectorValues(super=" + super.toString() + ")";
    }
}

