"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenSearchObservabilityPlugin = OpenSearchObservabilityPlugin;
var _shared = require("../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function OpenSearchObservabilityPlugin(Client, config, components) {
  const clientAction = components.clientAction.factory;
  Client.prototype.observability = components.clientAction.namespaceFactory();
  const observability = Client.prototype.observability.prototype;

  // Get Object
  observability.getObject = clientAction({
    url: {
      fmt: _shared.OPENSEARCH_PANELS_API.OBJECT,
      params: {
        objectId: {
          type: 'string'
        },
        objectIdList: {
          type: 'string'
        },
        objectType: {
          type: 'string'
        },
        sortField: {
          type: 'string'
        },
        sortOrder: {
          type: 'string'
        },
        fromIndex: {
          type: 'number'
        },
        maxItems: {
          type: 'number'
        },
        name: {
          type: 'string'
        },
        lastUpdatedTimeMs: {
          type: 'string'
        },
        createdTimeMs: {
          type: 'string'
        }
      }
    },
    method: 'GET'
  });

  // Get Object by Id
  observability.getObjectById = clientAction({
    url: {
      fmt: `${_shared.OPENSEARCH_PANELS_API.OBJECT}/<%=objectId%>`,
      req: {
        objectId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });

  // Create new Object
  observability.createObject = clientAction({
    url: {
      fmt: _shared.OPENSEARCH_PANELS_API.OBJECT
    },
    method: 'POST',
    needBody: true
  });

  // Update Object by Id
  observability.updateObjectById = clientAction({
    url: {
      fmt: `${_shared.OPENSEARCH_PANELS_API.OBJECT}/<%=objectId%>`,
      req: {
        objectId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'PUT',
    needBody: true
  });

  // Delete Object by Id
  observability.deleteObjectById = clientAction({
    url: {
      fmt: `${_shared.OPENSEARCH_PANELS_API.OBJECT}/<%=objectId%>`,
      req: {
        objectId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });

  // Delete Object by Id List
  observability.deleteObjectByIdList = clientAction({
    url: {
      fmt: _shared.OPENSEARCH_PANELS_API.OBJECT,
      params: {
        objectIdList: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });

  // Get async job status
  observability.getJobStatus = clientAction({
    url: {
      fmt: `${_shared.JOBS_ENDPOINT_BASE}/<%=queryId%>`,
      req: {
        queryId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });

  // Delete async job
  observability.deleteJob = clientAction({
    url: {
      fmt: `${_shared.JOBS_ENDPOINT_BASE}/<%=queryId%>`,
      req: {
        queryId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });

  // Run async job
  observability.runDirectQuery = clientAction({
    url: {
      fmt: `${_shared.JOBS_ENDPOINT_BASE}`
    },
    method: 'POST',
    needBody: true
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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