/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.errors;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.streams.errors.ErrorHandlerContext;
import org.apache.kafka.streams.errors.internals.DefaultErrorHandlerContext;
import org.apache.kafka.streams.processor.ProcessorContext;

public interface DeserializationExceptionHandler
extends Configurable {
    @Deprecated
    default public DeserializationHandlerResponse handle(ProcessorContext context, ConsumerRecord<byte[], byte[]> record, Exception exception) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public DeserializationHandlerResponse handle(ErrorHandlerContext context, ConsumerRecord<byte[], byte[]> record, Exception exception) {
        return this.handle((ProcessorContext)((DefaultErrorHandlerContext)context).processorContext().orElse(null), record, exception);
    }

    default public Response handleError(ErrorHandlerContext context, ConsumerRecord<byte[], byte[]> record, Exception exception) {
        return new Response(Result.from(this.handle(context, record, exception)), Collections.emptyList());
    }

    @Deprecated
    public static enum DeserializationHandlerResponse {
        CONTINUE(0, "CONTINUE"),
        FAIL(1, "FAIL");

        public final String name;
        public final int id;

        private DeserializationHandlerResponse(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static class Response {
        private final Result result;
        private final List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords;

        private Response(Result result, List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords) {
            this.result = result;
            this.deadLetterQueueRecords = deadLetterQueueRecords;
        }

        public static Response fail(List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords) {
            return new Response(Result.FAIL, deadLetterQueueRecords);
        }

        public static Response fail() {
            return Response.fail(Collections.emptyList());
        }

        public static Response resume(List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords) {
            return new Response(Result.RESUME, deadLetterQueueRecords);
        }

        public static Response resume() {
            return Response.resume(Collections.emptyList());
        }

        public Result result() {
            return this.result;
        }

        public List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords() {
            if (this.deadLetterQueueRecords == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.deadLetterQueueRecords);
        }
    }

    public static enum Result {
        RESUME(0, "RESUME"),
        FAIL(1, "FAIL");

        public final String name;
        public final int id;

        private Result(int id, String name) {
            this.id = id;
            this.name = name;
        }

        private static Result from(DeserializationHandlerResponse value) {
            switch (value.ordinal()) {
                case 1: {
                    return FAIL;
                }
                case 0: {
                    return RESUME;
                }
            }
            throw new IllegalArgumentException("No Result enum found for old value: " + String.valueOf((Object)value));
        }
    }
}

