/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.CachedSupplier;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerHeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMembershipManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.FetchBuffer;
import org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.FetchRequestManager;
import org.apache.kafka.clients.consumer.internals.MemberStateListener;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.OffsetCommitCallbackInvoker;
import org.apache.kafka.clients.consumer.internals.OffsetsRequestManager;
import org.apache.kafka.clients.consumer.internals.PositionsValidator;
import org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.kafka.clients.consumer.internals.ShareConsumeRequestManager;
import org.apache.kafka.clients.consumer.internals.ShareConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ShareFetchBuffer;
import org.apache.kafka.clients.consumer.internals.ShareFetchConfig;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.ShareHeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.ShareMembershipManager;
import org.apache.kafka.clients.consumer.internals.StreamsGroupHeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.StreamsMembershipManager;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceData;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.TopicMetadataRequestManager;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgementEventHandler;
import org.apache.kafka.common.internals.IdempotentCloser;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.telemetry.internals.ClientTelemetryReporter;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public class RequestManagers
implements Closeable {
    private final Logger log;
    public final Optional<CoordinatorRequestManager> coordinatorRequestManager;
    public final Optional<CommitRequestManager> commitRequestManager;
    public final Optional<ConsumerHeartbeatRequestManager> consumerHeartbeatRequestManager;
    public final Optional<ShareHeartbeatRequestManager> shareHeartbeatRequestManager;
    public final Optional<ConsumerMembershipManager> consumerMembershipManager;
    public final Optional<ShareMembershipManager> shareMembershipManager;
    public final Optional<StreamsMembershipManager> streamsMembershipManager;
    public final OffsetsRequestManager offsetsRequestManager;
    public final TopicMetadataRequestManager topicMetadataRequestManager;
    public final FetchRequestManager fetchRequestManager;
    public final Optional<ShareConsumeRequestManager> shareConsumeRequestManager;
    public final Optional<StreamsGroupHeartbeatRequestManager> streamsGroupHeartbeatRequestManager;
    private final List<RequestManager> entries;
    private final IdempotentCloser closer = new IdempotentCloser();

    public RequestManagers(LogContext logContext, OffsetsRequestManager offsetsRequestManager, TopicMetadataRequestManager topicMetadataRequestManager, FetchRequestManager fetchRequestManager, Optional<CoordinatorRequestManager> coordinatorRequestManager, Optional<CommitRequestManager> commitRequestManager, Optional<ConsumerHeartbeatRequestManager> heartbeatRequestManager, Optional<ConsumerMembershipManager> membershipManager, Optional<StreamsGroupHeartbeatRequestManager> streamsGroupHeartbeatRequestManager, Optional<StreamsMembershipManager> streamsMembershipManager) {
        this.log = logContext.logger(RequestManagers.class);
        this.offsetsRequestManager = Objects.requireNonNull(offsetsRequestManager, "OffsetsRequestManager cannot be null");
        this.coordinatorRequestManager = coordinatorRequestManager;
        this.commitRequestManager = commitRequestManager;
        this.topicMetadataRequestManager = topicMetadataRequestManager;
        this.fetchRequestManager = fetchRequestManager;
        this.shareConsumeRequestManager = Optional.empty();
        this.consumerHeartbeatRequestManager = heartbeatRequestManager;
        this.shareHeartbeatRequestManager = Optional.empty();
        this.streamsGroupHeartbeatRequestManager = streamsGroupHeartbeatRequestManager;
        this.consumerMembershipManager = membershipManager;
        this.streamsMembershipManager = streamsMembershipManager;
        this.shareMembershipManager = Optional.empty();
        ArrayList<RequestManager> list = new ArrayList<RequestManager>();
        coordinatorRequestManager.ifPresent(list::add);
        commitRequestManager.ifPresent(list::add);
        heartbeatRequestManager.ifPresent(list::add);
        membershipManager.ifPresent(list::add);
        streamsGroupHeartbeatRequestManager.ifPresent(list::add);
        streamsMembershipManager.ifPresent(list::add);
        list.add(offsetsRequestManager);
        list.add(topicMetadataRequestManager);
        list.add(fetchRequestManager);
        this.entries = Collections.unmodifiableList(list);
    }

    public RequestManagers(LogContext logContext, ShareConsumeRequestManager shareConsumeRequestManager, Optional<CoordinatorRequestManager> coordinatorRequestManager, Optional<ShareHeartbeatRequestManager> shareHeartbeatRequestManager, Optional<ShareMembershipManager> shareMembershipManager) {
        this.log = logContext.logger(RequestManagers.class);
        this.shareConsumeRequestManager = Optional.of(shareConsumeRequestManager);
        this.coordinatorRequestManager = coordinatorRequestManager;
        this.commitRequestManager = Optional.empty();
        this.consumerHeartbeatRequestManager = Optional.empty();
        this.streamsGroupHeartbeatRequestManager = Optional.empty();
        this.shareHeartbeatRequestManager = shareHeartbeatRequestManager;
        this.consumerMembershipManager = Optional.empty();
        this.streamsMembershipManager = Optional.empty();
        this.shareMembershipManager = shareMembershipManager;
        this.offsetsRequestManager = null;
        this.topicMetadataRequestManager = null;
        this.fetchRequestManager = null;
        ArrayList<ShareConsumeRequestManager> list = new ArrayList<ShareConsumeRequestManager>();
        coordinatorRequestManager.ifPresent(list::add);
        shareHeartbeatRequestManager.ifPresent(list::add);
        shareMembershipManager.ifPresent(list::add);
        list.add(shareConsumeRequestManager);
        this.entries = Collections.unmodifiableList(list);
    }

    public List<RequestManager> entries() {
        return this.entries;
    }

    @Override
    public void close() {
        this.closer.close(() -> {
            this.log.debug("Closing RequestManagers");
            this.entries.stream().filter(rm -> rm instanceof Closeable).map(rm -> (Closeable)((Object)rm)).forEach(c -> Utils.closeQuietly(c, c.getClass().getSimpleName()));
            this.log.debug("RequestManagers has been closed");
        }, () -> this.log.debug("RequestManagers was already closed"));
    }

    public static Supplier<RequestManagers> supplier(final Time time, final LogContext logContext, final BackgroundEventHandler backgroundEventHandler, final ConsumerMetadata metadata, final SubscriptionState subscriptions, final FetchBuffer fetchBuffer, final ConsumerConfig config, final GroupRebalanceConfig groupRebalanceConfig, final ApiVersions apiVersions, final FetchMetricsManager fetchMetricsManager, final Supplier<NetworkClientDelegate> networkClientDelegateSupplier, final Optional<ClientTelemetryReporter> clientTelemetryReporter, final Metrics metrics, final OffsetCommitCallbackInvoker offsetCommitCallbackInvoker, final MemberStateListener applicationThreadMemberStateListener, final Optional<StreamsRebalanceData> streamsRebalanceData, final PositionsValidator positionsValidator) {
        return new CachedSupplier<RequestManagers>(){

            @Override
            protected RequestManagers create() {
                NetworkClientDelegate networkClientDelegate = (NetworkClientDelegate)networkClientDelegateSupplier.get();
                FetchConfig fetchConfig = new FetchConfig(config);
                long retryBackoffMs = config.getLong("retry.backoff.ms");
                long retryBackoffMaxMs = config.getLong("retry.backoff.max.ms");
                int requestTimeoutMs = config.getInt("request.timeout.ms");
                int defaultApiTimeoutMs = config.getInt("default.api.timeout.ms");
                FetchRequestManager fetch = new FetchRequestManager(logContext, time, metadata, subscriptions, fetchConfig, fetchBuffer, fetchMetricsManager, networkClientDelegate, apiVersions);
                TopicMetadataRequestManager topic = new TopicMetadataRequestManager(logContext, time, config);
                ConsumerHeartbeatRequestManager heartbeatRequestManager = null;
                ConsumerMembershipManager membershipManager = null;
                CoordinatorRequestManager coordinator = null;
                CommitRequestManager commitRequestManager = null;
                StreamsGroupHeartbeatRequestManager streamsGroupHeartbeatRequestManager = null;
                StreamsMembershipManager streamsMembershipManager = null;
                if (groupRebalanceConfig != null && groupRebalanceConfig.groupId != null) {
                    Optional<String> serverAssignor = Optional.ofNullable(config.getString("group.remote.assignor"));
                    coordinator = new CoordinatorRequestManager(logContext, retryBackoffMs, retryBackoffMaxMs, groupRebalanceConfig.groupId);
                    commitRequestManager = new CommitRequestManager(time, logContext, subscriptions, config, coordinator, offsetCommitCallbackInvoker, groupRebalanceConfig.groupId, groupRebalanceConfig.groupInstanceId, metrics, metadata);
                    if (streamsRebalanceData.isPresent()) {
                        streamsMembershipManager = new StreamsMembershipManager(groupRebalanceConfig.groupId, (StreamsRebalanceData)streamsRebalanceData.get(), subscriptions, backgroundEventHandler, logContext, time, metrics);
                        streamsMembershipManager.registerStateListener(commitRequestManager);
                        streamsMembershipManager.registerStateListener(applicationThreadMemberStateListener);
                        if (clientTelemetryReporter.isPresent()) {
                            ((ClientTelemetryReporter)clientTelemetryReporter.get()).updateMetricsLabels(Map.of("group_member_id", streamsMembershipManager.memberId()));
                        }
                        streamsGroupHeartbeatRequestManager = new StreamsGroupHeartbeatRequestManager(logContext, time, config, coordinator, streamsMembershipManager, backgroundEventHandler, metrics, (StreamsRebalanceData)streamsRebalanceData.get());
                    } else {
                        membershipManager = new ConsumerMembershipManager(groupRebalanceConfig.groupId, groupRebalanceConfig.groupInstanceId, groupRebalanceConfig.rackId, groupRebalanceConfig.rebalanceTimeoutMs, serverAssignor, subscriptions, commitRequestManager, metadata, logContext, backgroundEventHandler, time, metrics, (boolean)config.getBoolean("enable.auto.commit"));
                        if (clientTelemetryReporter.isPresent()) {
                            ((ClientTelemetryReporter)clientTelemetryReporter.get()).updateMetricsLabels(Map.of("group_member_id", membershipManager.memberId()));
                        }
                        membershipManager.registerStateListener(commitRequestManager);
                        membershipManager.registerStateListener(applicationThreadMemberStateListener);
                        heartbeatRequestManager = new ConsumerHeartbeatRequestManager(logContext, time, config, coordinator, subscriptions, membershipManager, backgroundEventHandler, metrics);
                    }
                }
                OffsetsRequestManager listOffsets = new OffsetsRequestManager(subscriptions, metadata, fetchConfig.isolationLevel, time, retryBackoffMs, requestTimeoutMs, defaultApiTimeoutMs, apiVersions, networkClientDelegate, commitRequestManager, positionsValidator, logContext);
                return new RequestManagers(logContext, listOffsets, topic, fetch, Optional.ofNullable(coordinator), Optional.ofNullable(commitRequestManager), Optional.ofNullable(heartbeatRequestManager), Optional.ofNullable(membershipManager), Optional.ofNullable(streamsGroupHeartbeatRequestManager), Optional.ofNullable(streamsMembershipManager));
            }
        };
    }

    public static Supplier<RequestManagers> supplier(final Time time, final LogContext logContext, final ShareAcknowledgementEventHandler shareAcknowledgementEventHandler, final BackgroundEventHandler backgroundEventHandler, final ShareConsumerMetadata metadata, final SubscriptionState subscriptions, final ShareFetchBuffer fetchBuffer, final ConsumerConfig config, final GroupRebalanceConfig groupRebalanceConfig, final ShareFetchMetricsManager shareFetchMetricsManager, final Optional<ClientTelemetryReporter> clientTelemetryReporter, final Metrics metrics) {
        return new CachedSupplier<RequestManagers>(){

            @Override
            protected RequestManagers create() {
                long retryBackoffMs = config.getLong("retry.backoff.ms");
                long retryBackoffMaxMs = config.getLong("retry.backoff.max.ms");
                ShareFetchConfig shareFetchConfig = new ShareFetchConfig(config);
                CoordinatorRequestManager coordinator = new CoordinatorRequestManager(logContext, retryBackoffMs, retryBackoffMaxMs, groupRebalanceConfig.groupId);
                ShareMembershipManager shareMembershipManager = new ShareMembershipManager(logContext, groupRebalanceConfig.groupId, (String)groupRebalanceConfig.rackId.orElse(null), subscriptions, (Metadata)metadata, time, metrics);
                clientTelemetryReporter.ifPresent(telemetryReporter -> telemetryReporter.updateMetricsLabels(Map.of("group_member_id", shareMembershipManager.memberId())));
                ShareHeartbeatRequestManager shareHeartbeatRequestManager = new ShareHeartbeatRequestManager(logContext, time, config, coordinator, subscriptions, shareMembershipManager, backgroundEventHandler, metrics);
                ShareConsumeRequestManager shareConsumeRequestManager = new ShareConsumeRequestManager(time, logContext, groupRebalanceConfig.groupId, metadata, subscriptions, shareFetchConfig, fetchBuffer, shareAcknowledgementEventHandler, shareFetchMetricsManager, retryBackoffMs, retryBackoffMaxMs);
                shareMembershipManager.registerStateListener(shareConsumeRequestManager);
                return new RequestManagers(logContext, shareConsumeRequestManager, Optional.of(coordinator), Optional.of(shareHeartbeatRequestManager), Optional.of(shareMembershipManager));
            }
        };
    }
}

