/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.spi;

import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.DefaultLoggingEvent;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.spi.CallerBoundaryAware;
import org.slf4j.spi.LocationAwareLogger;
import org.slf4j.spi.LoggingEventAware;
import org.slf4j.spi.LoggingEventBuilder;

public class DefaultLoggingEventBuilder
implements LoggingEventBuilder,
CallerBoundaryAware {
    static String DLEB_FQCN = DefaultLoggingEventBuilder.class.getName();
    protected DefaultLoggingEvent loggingEvent;
    protected Logger logger;

    public DefaultLoggingEventBuilder(Logger logger, Level level) {
        this.logger = logger;
        this.loggingEvent = new DefaultLoggingEvent(level, logger);
    }

    @Override
    public LoggingEventBuilder addMarker(Marker marker) {
        this.loggingEvent.addMarker(marker);
        return this;
    }

    @Override
    public LoggingEventBuilder setCause(Throwable t15) {
        this.loggingEvent.setThrowable(t15);
        return this;
    }

    @Override
    public LoggingEventBuilder addArgument(Object p15) {
        this.loggingEvent.addArgument(p15);
        return this;
    }

    @Override
    public LoggingEventBuilder addArgument(Supplier<?> objectSupplier) {
        this.loggingEvent.addArgument(objectSupplier.get());
        return this;
    }

    @Override
    public LoggingEventBuilder addKeyValue(String key, Object value) {
        this.loggingEvent.addKeyValue(key, value);
        return this;
    }

    @Override
    public LoggingEventBuilder addKeyValue(String key, Supplier<Object> value) {
        this.loggingEvent.addKeyValue(key, value.get());
        return this;
    }

    @Override
    public void setCallerBoundary(String fqcn) {
        this.loggingEvent.setCallerBoundary(fqcn);
    }

    @Override
    public void log() {
        this.log(this.loggingEvent);
    }

    @Override
    public LoggingEventBuilder setMessage(String message2) {
        this.loggingEvent.setMessage(message2);
        return this;
    }

    @Override
    public LoggingEventBuilder setMessage(Supplier<String> messageSupplier) {
        this.loggingEvent.setMessage(messageSupplier.get());
        return this;
    }

    @Override
    public void log(String message2) {
        this.loggingEvent.setMessage(message2);
        this.log(this.loggingEvent);
    }

    @Override
    public void log(String message2, Object arg) {
        this.loggingEvent.setMessage(message2);
        this.loggingEvent.addArgument(arg);
        this.log(this.loggingEvent);
    }

    @Override
    public void log(String message2, Object arg0, Object arg1) {
        this.loggingEvent.setMessage(message2);
        this.loggingEvent.addArgument(arg0);
        this.loggingEvent.addArgument(arg1);
        this.log(this.loggingEvent);
    }

    @Override
    public void log(String message2, Object ... args) {
        this.loggingEvent.setMessage(message2);
        this.loggingEvent.addArguments(args);
        this.log(this.loggingEvent);
    }

    @Override
    public void log(Supplier<String> messageSupplier) {
        if (messageSupplier == null) {
            this.log((String)null);
        } else {
            this.log(messageSupplier.get());
        }
    }

    protected void log(LoggingEvent aLoggingEvent) {
        if (aLoggingEvent.getCallerBoundary() == null) {
            this.setCallerBoundary(DLEB_FQCN);
        }
        if (this.logger instanceof LoggingEventAware) {
            ((LoggingEventAware)((Object)this.logger)).log(aLoggingEvent);
        } else if (this.logger instanceof LocationAwareLogger) {
            this.logViaLocationAwareLoggerAPI((LocationAwareLogger)this.logger, aLoggingEvent);
        } else {
            this.logViaPublicSLF4JLoggerAPI(aLoggingEvent);
        }
    }

    private void logViaLocationAwareLoggerAPI(LocationAwareLogger locationAwareLogger, LoggingEvent aLoggingEvent) {
        String msg = aLoggingEvent.getMessage();
        List<Marker> markerList = aLoggingEvent.getMarkers();
        String mergedMessage = this.mergeMarkersAndKeyValuePairsAndMessage(aLoggingEvent);
        locationAwareLogger.log(null, aLoggingEvent.getCallerBoundary(), aLoggingEvent.getLevel().toInt(), mergedMessage, aLoggingEvent.getArgumentArray(), aLoggingEvent.getThrowable());
    }

    private void logViaPublicSLF4JLoggerAPI(LoggingEvent aLoggingEvent) {
        Object[] argArray = aLoggingEvent.getArgumentArray();
        int argLen = argArray == null ? 0 : argArray.length;
        Throwable t15 = aLoggingEvent.getThrowable();
        int tLen = t15 == null ? 0 : 1;
        Object[] combinedArguments = new Object[argLen + tLen];
        if (argArray != null) {
            System.arraycopy(argArray, 0, combinedArguments, 0, argLen);
        }
        if (t15 != null) {
            combinedArguments[argLen] = t15;
        }
        String mergedMessage = this.mergeMarkersAndKeyValuePairsAndMessage(aLoggingEvent);
        switch (aLoggingEvent.getLevel()) {
            case TRACE: {
                this.logger.trace(mergedMessage, combinedArguments);
                break;
            }
            case DEBUG: {
                this.logger.debug(mergedMessage, combinedArguments);
                break;
            }
            case INFO: {
                this.logger.info(mergedMessage, combinedArguments);
                break;
            }
            case WARN: {
                this.logger.warn(mergedMessage, combinedArguments);
                break;
            }
            case ERROR: {
                this.logger.error(mergedMessage, combinedArguments);
            }
        }
    }

    private String mergeMarkersAndKeyValuePairsAndMessage(LoggingEvent aLoggingEvent) {
        StringBuilder sb5 = this.mergeMarkers(aLoggingEvent.getMarkers(), null);
        sb5 = this.mergeKeyValuePairs(aLoggingEvent.getKeyValuePairs(), sb5);
        String mergedMessage = this.mergeMessage(aLoggingEvent.getMessage(), sb5);
        return mergedMessage;
    }

    private StringBuilder mergeMarkers(List<Marker> markerList, StringBuilder sb5) {
        if (markerList == null || markerList.isEmpty()) {
            return sb5;
        }
        if (sb5 == null) {
            sb5 = new StringBuilder();
        }
        for (Marker marker : markerList) {
            sb5.append(marker);
            sb5.append(' ');
        }
        return sb5;
    }

    private StringBuilder mergeKeyValuePairs(List<KeyValuePair> keyValuePairList, StringBuilder sb5) {
        if (keyValuePairList == null || keyValuePairList.isEmpty()) {
            return sb5;
        }
        if (sb5 == null) {
            sb5 = new StringBuilder();
        }
        for (KeyValuePair kvp : keyValuePairList) {
            sb5.append(kvp.key);
            sb5.append('=');
            sb5.append(kvp.value);
            sb5.append(' ');
        }
        return sb5;
    }

    private String mergeMessage(String msg, StringBuilder sb5) {
        if (sb5 != null) {
            sb5.append(msg);
            return sb5.toString();
        }
        return msg;
    }
}

