/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class YamlFoldParser
implements FoldParser {
    private static boolean isSpaces(Token t15) {
        String lexeme = t15.getLexeme();
        return lexeme.trim().isEmpty();
    }

    @Override
    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Stack<Integer> indentStack = new Stack<Integer>();
        Fold currentFold = null;
        int lineCount = textArea.getLineCount();
        int lastOffset = 0;
        try {
            for (int line = 0; line < lineCount; ++line) {
                int outer;
                Token t15 = textArea.getTokenListForLine(line);
                if (!t15.isPaintable()) continue;
                Token startLine = t15;
                int offset = t15.getOffset();
                int indent = 0;
                while (t15 != null && t15.isPaintable() && YamlFoldParser.isSpaces(t15)) {
                    indent += t15.length();
                    t15 = t15.getNextToken();
                }
                if (t15 != null && t15.isPaintable() && t15.isSingleChar('-')) {
                    ++indent;
                    t15 = t15.getNextToken();
                }
                while (!indentStack.empty() && (outer = ((Integer)indentStack.peek()).intValue()) >= indent && currentFold != null) {
                    currentFold.setEndOffset(lastOffset);
                    Fold parentFold = currentFold.getParent();
                    if (currentFold.isOnSingleLine()) {
                        YamlFoldParser.removeFold(currentFold, folds);
                    }
                    currentFold = parentFold;
                    indentStack.pop();
                }
                while (t15 != null && t15.isPaintable()) {
                    offset = t15.getOffset();
                    t15 = t15.getNextToken();
                }
                lastOffset = offset;
                if (currentFold == null) {
                    currentFold = new Fold(0, textArea, startLine.getOffset());
                    folds.add(currentFold);
                } else {
                    currentFold = currentFold.createChild(0, startLine.getOffset());
                }
                indentStack.push(indent);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }

    private static void removeFold(Fold fold, List<Fold> folds) {
        if (!fold.removeFromParent()) {
            folds.remove(folds.size() - 1);
        }
    }
}

