/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenOrientedView;
import org.fife.ui.rsyntaxtextarea.TokenPainter;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;

public class SyntaxView
extends View
implements TabExpander,
TokenOrientedView,
RSTAView {
    private Font font;
    private FontMetrics metrics;
    private Element longLine;
    private float longLineWidth;
    private int tabSize;
    private int tabBase;
    private RSyntaxTextArea host;
    private int lineHeight;
    private int ascent;
    private int clipStart;
    private int clipEnd;
    private TokenImpl tempToken = new TokenImpl();
    static final String EOL_MARKER = "\u00b6";

    public SyntaxView(Element elem) {
        super(elem);
    }

    void calculateLongestLine() {
        Container c15 = this.getContainer();
        this.font = c15.getFont();
        this.metrics = c15.getFontMetrics(this.font);
        this.tabSize = this.getTabSize() * this.metrics.charWidth(' ');
        Element lines = this.getElement();
        int n15 = lines.getElementCount();
        for (int i15 = 0; i15 < n15; ++i15) {
            Element line = lines.getElement(i15);
            float w15 = this.getLineWidth(i15);
            if (!(w15 > this.longLineWidth)) continue;
            this.longLineWidth = w15;
            this.longLine = line;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent changes, Shape a15, ViewFactory f15) {
        this.updateDamage(changes, a15, f15);
    }

    protected void damageLineRange(int line0, int line1, Shape a15, Component host) {
        if (a15 != null) {
            Rectangle area0 = this.lineToRect(a15, line0);
            Rectangle area1 = this.lineToRect(a15, line1);
            if (area0 != null && area1 != null) {
                Rectangle dmg = area0.union(area1);
                host.repaint(dmg.x, dmg.y, dmg.width, dmg.height);
            } else {
                host.repaint();
            }
        }
    }

    static void drawEOLMarker(RSyntaxTextArea textArea, Graphics2D g15, float x15, float y15) {
        g15.setColor(textArea.getForegroundForTokenType(21));
        g15.setFont(textArea.getFontForTokenType(21));
        g15.drawString(EOL_MARKER, x15, y15);
    }

    private float drawLine(TokenPainter painter, Token token, Graphics2D g15, float x15, float y15, int line) {
        float nextX = x15;
        boolean paintBG = this.host.getPaintTokenBackgrounds(line, y15);
        while (token != null && token.isPaintable() && nextX < (float)this.clipEnd) {
            nextX = painter.paint(token, g15, nextX, y15, this.host, this, this.clipStart, paintBG);
            token = token.getNextToken();
        }
        if (this.host.getEOLMarkersVisible()) {
            SyntaxView.drawEOLMarker(this.host, g15, nextX, y15);
        }
        return nextX;
    }

    private float drawLineWithSelection(TokenPainter painter, Token token, Graphics2D g15, float x15, float y15, int selStart, int selEnd) {
        while (token != null && token.isPaintable() && x15 < (float)this.clipEnd) {
            x15 = SyntaxView.drawTokenWithSelection(painter, token, g15, x15, y15, selStart, selEnd, this.host, this, this.clipStart);
            token = token.getNextToken();
        }
        if (this.host.getEOLMarkersVisible()) {
            SyntaxView.drawEOLMarker(this.host, g15, x15, y15);
        }
        return x15;
    }

    public static float drawTokenWithSelection(TokenPainter painter, Token token, Graphics2D g15, float x15, float y15, int selStart, int selEnd, RSyntaxTextArea host, TabExpander e15, float clipStart) {
        boolean useSTC = host.getUseSelectedTextColor();
        if (selEnd <= token.getOffset() || selStart >= token.getEndOffset()) {
            x15 = painter.paint(token, g15, x15, y15, host, e15, clipStart);
        } else if (selStart <= token.getOffset()) {
            if (token.containsPosition(selEnd)) {
                Rectangle origClip = g15.getClipBounds();
                int selectedCharCount = Math.min(token.length(), selEnd - token.getOffset());
                float selEndX = painter.nextX(token, selectedCharCount, x15, host, e15);
                g15.setClip((int)x15, origClip.y, (int)(selEndX - x15), origClip.height);
                painter.paintSelected(token, g15, x15, y15, host, e15, clipStart, useSTC);
                g15.setClip((int)selEndX, origClip.y, origClip.width - (int)(selEndX - (float)origClip.x), origClip.height);
                x15 = painter.paint(token, g15, x15, y15, host, e15, clipStart);
                g15.setClip(origClip);
            } else {
                x15 = painter.paintSelected(token, g15, x15, y15, host, e15, clipStart, useSTC);
            }
        } else {
            float tokenX = x15;
            Rectangle origClip = g15.getClipBounds();
            int unselectedCharCount = Math.min(token.length(), selStart - token.getOffset());
            float selStartX = painter.nextX(token, unselectedCharCount, tokenX, host, e15);
            g15.setClip((int)tokenX, origClip.y, (int)(selStartX - tokenX), origClip.height);
            painter.paint(token, g15, tokenX, y15, host, e15, clipStart);
            int selectedCharCount = Math.min(token.getEndOffset(), selEnd) - token.getOffset() - unselectedCharCount;
            float selEndX = painter.nextX(token, selectedCharCount + unselectedCharCount, tokenX, host, e15);
            g15.setClip((int)selStartX, origClip.y, (int)(selEndX - selStartX), origClip.height);
            painter.paintSelected(token, g15, tokenX, y15, host, e15, clipStart, useSTC);
            x15 = selEndX;
            if (token.getEndOffset() > selEnd) {
                g15.setClip((int)x15, origClip.y, origClip.width - (int)(x15 - (float)origClip.x), origClip.height);
                x15 = painter.paint(token, g15, tokenX, y15, host, e15, clipStart);
            }
            g15.setClip(origClip);
        }
        return x15;
    }

    private float getEOLMarkerWidth(RSyntaxTextArea textArea) {
        return this.metrics.stringWidth(EOL_MARKER);
    }

    private float getLineWidth(int lineNumber) {
        Token tokenList = ((RSyntaxDocument)this.getDocument()).getTokenListForLine(lineNumber);
        return RSyntaxUtilities.getTokenListWidth(tokenList, (RSyntaxTextArea)this.getContainer(), this);
    }

    @Override
    public int getNextVisualPositionFrom(int pos, Position.Bias b15, Shape a15, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return RSyntaxUtilities.getNextVisualPositionFrom(pos, b15, a15, direction, biasRet, this);
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        switch (axis) {
            case 0: {
                float span = this.longLineWidth + (float)this.getRhsCorrection();
                if (this.host.getEOLMarkersVisible()) {
                    span += this.getEOLMarkerWidth(this.host);
                }
                return span;
            }
            case 1: {
                this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
                int visibleLineCount = this.getElement().getElementCount();
                if (this.host.isCodeFoldingEnabled()) {
                    visibleLineCount -= this.host.getFoldManager().getHiddenLineCount();
                }
                return (float)visibleLineCount * (float)this.lineHeight;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    private int getRhsCorrection() {
        int rhsCorrection = 10;
        if (this.host != null) {
            rhsCorrection = this.host.getRightHandSideCorrection();
        }
        return rhsCorrection;
    }

    private int getTabSize() {
        Integer i15 = (Integer)this.getDocument().getProperty("tabSize");
        int size = i15 != null ? i15 : 5;
        return size;
    }

    @Override
    public Token getTokenListForPhysicalLineAbove(int offset) {
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = document.getDefaultRootElement();
        int line = map.getElementIndex(offset);
        FoldManager fm4 = this.host.getFoldManager();
        if (fm4 == null ? --line >= 0 : (line = fm4.getVisibleLineAbove(line)) >= 0) {
            return document.getTokenListForLine(line);
        }
        return null;
    }

    @Override
    public Token getTokenListForPhysicalLineBelow(int offset) {
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = document.getDefaultRootElement();
        int lineCount = map.getElementCount();
        int line = map.getElementIndex(offset);
        if (!this.host.isCodeFoldingEnabled()) {
            if (line < lineCount - 1) {
                return document.getTokenListForLine(line + 1);
            }
        } else {
            FoldManager fm4 = this.host.getFoldManager();
            line = fm4.getVisibleLineBelow(line);
            if (line >= 0 && line < lineCount) {
                return document.getTokenListForLine(line);
            }
        }
        return null;
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a15, ViewFactory f15) {
        this.updateDamage(changes, a15, f15);
    }

    protected Rectangle lineToRect(Shape a15, int line) {
        Rectangle r15 = null;
        this.updateMetrics();
        if (this.metrics != null) {
            Rectangle alloc = a15.getBounds();
            int n15 = this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
            if (this.host != null && this.host.isCodeFoldingEnabled()) {
                FoldManager fm4 = this.host.getFoldManager();
                int hiddenCount = fm4.getHiddenLineCountAbove(line);
                line -= hiddenCount;
            }
            r15 = new Rectangle(alloc.x, alloc.y + line * this.lineHeight, alloc.width, this.lineHeight);
        }
        return r15;
    }

    @Override
    public Shape modelToView(int pos, Shape a15, Position.Bias b15) throws BadLocationException {
        Element map = this.getElement();
        RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
        int lineIndex = map.getElementIndex(pos);
        Token tokenList = doc.getTokenListForLine(lineIndex);
        Rectangle lineArea = this.lineToRect(a15, lineIndex);
        this.tabBase = lineArea.x;
        lineArea = tokenList.listOffsetToView((RSyntaxTextArea)this.getContainer(), this, pos, this.tabBase, lineArea);
        return lineArea;
    }

    @Override
    public Shape modelToView(int p05, Position.Bias b05, int p15, Position.Bias b15, Shape a15) throws BadLocationException {
        Rectangle r15;
        Shape s15;
        Shape s05 = this.modelToView(p05, a15, b05);
        if (p15 == this.getEndOffset()) {
            try {
                s15 = this.modelToView(p15, a15, b15);
            }
            catch (BadLocationException ble) {
                s15 = null;
            }
            if (s15 == null) {
                Rectangle alloc = a15 instanceof Rectangle ? (Rectangle)a15 : a15.getBounds();
                s15 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s15 = this.modelToView(p15, a15, b15);
        }
        Rectangle r05 = s05 instanceof Rectangle ? (Rectangle)s05 : s05.getBounds();
        Rectangle rectangle = r15 = s15 instanceof Rectangle ? (Rectangle)s15 : s15.getBounds();
        if (r05.y != r15.y) {
            Rectangle alloc = a15 instanceof Rectangle ? (Rectangle)a15 : a15.getBounds();
            r05.x = alloc.x;
            r05.width = alloc.width;
        }
        r05.add(r15);
        if (p15 > p05) {
            r05.width -= r15.width;
        }
        return r05;
    }

    @Override
    public float nextTabStop(float x15, int tabOffset) {
        if (this.tabSize == 0) {
            return x15;
        }
        int tabCount = ((int)x15 - this.tabBase) / this.tabSize;
        return (float)this.tabBase + ((float)tabCount + 1.0f) * (float)this.tabSize;
    }

    @Override
    public void paint(Graphics g15, Shape a15) {
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Rectangle alloc = a15.getBounds();
        this.tabBase = alloc.x;
        this.host = (RSyntaxTextArea)this.getContainer();
        Rectangle clip = g15.getClipBounds();
        this.clipStart = clip.x;
        this.clipEnd = this.clipStart + clip.width;
        this.lineHeight = this.host.getLineHeight();
        this.ascent = this.host.getMaxAscent();
        int heightAbove = clip.y - alloc.y;
        int linesAbove = Math.max(0, heightAbove / this.lineHeight);
        FoldManager fm4 = this.host.getFoldManager();
        linesAbove += fm4.getHiddenLineCountAbove(linesAbove, true);
        Rectangle lineArea = this.lineToRect(a15, linesAbove);
        int y15 = lineArea.y + this.ascent;
        int x15 = lineArea.x;
        Element map = this.getElement();
        int lineCount = map.getElementCount();
        int selStart = this.host.getSelectionStart();
        int selEnd = this.host.getSelectionEnd();
        RSyntaxTextAreaHighlighter h15 = (RSyntaxTextAreaHighlighter)this.host.getHighlighter();
        Graphics2D g2d = (Graphics2D)g15;
        TokenPainter painter = this.host.getTokenPainter();
        for (int line = linesAbove; y15 < clip.y + clip.height + this.ascent && line < lineCount; y15 += this.lineHeight, ++line) {
            int hiddenLineCount;
            Fold fold = fm4.getFoldForLine(line);
            Element lineElement = map.getElement(line);
            int startOffset = lineElement.getStartOffset();
            int endOffset = lineElement.getEndOffset() - 1;
            h15.paintLayeredHighlights(g2d, startOffset, endOffset, a15, this.host, this);
            Token token = document.getTokenListForLine(line);
            if (selStart == selEnd || startOffset >= selEnd || endOffset < selStart) {
                this.drawLine(painter, token, g2d, x15, y15, line);
            } else {
                this.drawLineWithSelection(painter, token, g2d, x15, y15, selStart, selEnd);
            }
            h15.paintParserHighlights(g2d, startOffset, endOffset, a15, this.host, this);
            if (fold == null || !fold.isCollapsed()) continue;
            Color c15 = RSyntaxUtilities.getFoldedLineBottomColor(this.host);
            if (c15 != null) {
                g15.setColor(c15);
                g15.drawLine(x15, y15 + this.lineHeight - this.ascent - 1, this.host.getWidth(), y15 + this.lineHeight - this.ascent - 1);
            }
            while ((hiddenLineCount = fold.getLineCount()) != 0 && (fold = fm4.getFoldForLine(line += hiddenLineCount)) != null && fold.isCollapsed()) {
            }
        }
    }

    private boolean possiblyUpdateLongLine(Element line, int lineNumber) {
        float w15 = this.getLineWidth(lineNumber);
        if (w15 > this.longLineWidth) {
            this.longLineWidth = w15;
            this.longLine = line;
            return true;
        }
        return false;
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a15, ViewFactory f15) {
        this.updateDamage(changes, a15, f15);
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.updateMetrics();
    }

    protected void updateDamage(DocumentEvent changes, Shape a15, ViewFactory f15) {
        Element[] removed;
        Container host = this.getContainer();
        this.updateMetrics();
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec5 = changes.getChange(elem);
        Element[] added = ec5 != null ? ec5.getChildrenAdded() : null;
        Element[] elementArray = removed = ec5 != null ? ec5.getChildrenRemoved() : null;
        if (added != null && added.length > 0 || removed != null && removed.length > 0) {
            if (added != null) {
                int addedAt = ec5.getIndex();
                for (int i15 = 0; i15 < added.length; ++i15) {
                    this.possiblyUpdateLongLine(added[i15], addedAt + i15);
                }
            }
            if (removed != null) {
                for (Element element : removed) {
                    if (element != this.longLine) continue;
                    this.longLineWidth = -1.0f;
                    this.calculateLongestLine();
                    break;
                }
            }
            this.preferenceChanged(null, true, true);
            host.repaint();
        } else if (changes.getType() == DocumentEvent.EventType.CHANGE) {
            int startLine = changes.getOffset();
            int endLine = changes.getLength();
            this.damageLineRange(startLine, endLine, a15, host);
        } else {
            Element map = this.getElement();
            int line = map.getElementIndex(changes.getOffset());
            this.damageLineRange(line, line, a15, host);
            if (changes.getType() == DocumentEvent.EventType.INSERT) {
                Element e15 = map.getElement(line);
                if (e15 == this.longLine) {
                    this.longLineWidth = this.getLineWidth(line);
                    this.preferenceChanged(null, true, false);
                } else if (this.possiblyUpdateLongLine(e15, line)) {
                    this.preferenceChanged(null, true, false);
                }
            } else if (changes.getType() == DocumentEvent.EventType.REMOVE && map.getElement(line) == this.longLine) {
                this.longLineWidth = -1.0f;
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    private void updateMetrics() {
        this.host = (RSyntaxTextArea)this.getContainer();
        Font f15 = this.host.getFont();
        if (this.font != f15) {
            this.calculateLongestLine();
        }
    }

    @Override
    public int viewToModel(float fx4, float fy4, Shape a15, Position.Bias[] bias) {
        bias[0] = Position.Bias.Forward;
        Rectangle alloc = a15.getBounds();
        RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
        int x15 = (int)fx4;
        int y15 = (int)fy4;
        if (y15 < alloc.y) {
            return this.getStartOffset();
        }
        if (y15 > alloc.y + alloc.height) {
            return this.host.getLastVisibleOffset();
        }
        Element map = doc.getDefaultRootElement();
        this.lineHeight = this.host.getLineHeight();
        int lineIndex = Math.abs((y15 - alloc.y) / this.lineHeight);
        FoldManager fm4 = this.host.getFoldManager();
        if ((lineIndex += fm4.getHiddenLineCountAbove(lineIndex, true)) >= map.getElementCount()) {
            return this.host.getLastVisibleOffset();
        }
        Element line = map.getElement(lineIndex);
        if (x15 < alloc.x) {
            return line.getStartOffset();
        }
        if (x15 > alloc.x + alloc.width) {
            return line.getEndOffset() - 1;
        }
        int p05 = line.getStartOffset();
        Token tokenList = doc.getTokenListForLine(lineIndex);
        this.tabBase = alloc.x;
        int offs = tokenList.getListOffset((RSyntaxTextArea)this.getContainer(), this, this.tabBase, x15);
        return offs != -1 ? offs : p05;
    }

    @Override
    public int yForLine(Rectangle alloc, int line) {
        this.updateMetrics();
        if (this.metrics != null) {
            FoldManager fm4;
            int n15 = this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
            if (this.host != null && !(fm4 = this.host.getFoldManager()).isLineHidden(line)) {
                line -= fm4.getHiddenLineCountAbove(line);
                return alloc.y + line * this.lineHeight;
            }
        }
        return -1;
    }

    @Override
    public int yForLineContaining(Rectangle alloc, int offs) throws BadLocationException {
        Element map = this.getElement();
        int line = map.getElementIndex(offs);
        return this.yForLine(alloc, line);
    }
}

