/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.section.layout;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeType;
import org.exbin.bined.DefaultCodeAreaCaretPosition;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.MovementDirection;
import org.exbin.bined.section.SectionCodeAreaStructure;
import org.exbin.bined.section.layout.PositionIterator;
import org.exbin.bined.section.layout.SectionCodeAreaLayoutProfile;
import org.exbin.bined.section.layout.SpaceType;

@ParametersAreNonnullByDefault
public class DefaultSectionCodeAreaLayoutProfile
implements SectionCodeAreaLayoutProfile {
    protected boolean showHeader = true;
    protected int topHeaderSpace = 0;
    protected int bottomHeaderSpace = 0;
    protected boolean showRowPosition = true;
    protected int leftRowPositionSpace = 0;
    protected int rightRowPositionSpace = 0;
    protected int halfSpaceGroupSize = 0;
    protected int spaceGroupSize = 1;
    protected int doubleSpaceGroupSize = 0;

    @Override
    @Nonnull
    public DefaultSectionCodeAreaLayoutProfile createCopy() {
        DefaultSectionCodeAreaLayoutProfile copy = new DefaultSectionCodeAreaLayoutProfile();
        copy.showHeader = this.showHeader;
        copy.topHeaderSpace = this.topHeaderSpace;
        copy.bottomHeaderSpace = this.bottomHeaderSpace;
        copy.showRowPosition = this.showRowPosition;
        copy.leftRowPositionSpace = this.leftRowPositionSpace;
        copy.rightRowPositionSpace = this.rightRowPositionSpace;
        copy.halfSpaceGroupSize = this.halfSpaceGroupSize;
        copy.spaceGroupSize = this.spaceGroupSize;
        copy.doubleSpaceGroupSize = this.doubleSpaceGroupSize;
        return copy;
    }

    @Override
    public int computeHalfCharsPerRow(SectionCodeAreaStructure structure) {
        CodeAreaViewMode viewMode = structure.getViewMode();
        CodeType codeType = structure.getCodeType();
        int bytesPerRow = structure.getBytesPerRow();
        PosIterator posIterator = new PosIterator(codeType, viewMode, bytesPerRow);
        while (!posIterator.isEndReached()) {
            posIterator.nextSpaceType();
        }
        return posIterator.getHalfCharPosition();
    }

    @Override
    public int computeBytesPerRow(int halfCharsPerPage, SectionCodeAreaStructure structure) {
        CodeAreaViewMode viewMode = structure.getViewMode();
        CodeType codeType = structure.getCodeType();
        int maxBytesPerLine = structure.getMaxBytesPerLine();
        RowWrappingMode rowWrapping = structure.getRowWrapping();
        int wrappingBytesGroupSize = structure.getWrappingBytesGroupSize();
        int computedBytesPerRow = 0;
        if (rowWrapping == RowWrappingMode.WRAPPING) {
            int wrappingBytesGroupOffset;
            if (viewMode == CodeAreaViewMode.TEXT_PREVIEW) {
                computedBytesPerRow = halfCharsPerPage >> 1;
            } else {
                PosIterator posIterator = new PosIterator(codeType, CodeAreaViewMode.CODE_MATRIX, 0);
                do {
                    computedBytesPerRow = posIterator.getBytePosition();
                    int halfCharPos = posIterator.getHalfCharPosition() + 2;
                    if (viewMode == CodeAreaViewMode.DUAL) {
                        halfCharPos += 4 + posIterator.getBytePosition() * 2;
                    }
                    if (halfCharPos > halfCharsPerPage) break;
                    posIterator.nextSpaceType();
                } while (!posIterator.endReached);
            }
            if (maxBytesPerLine > 0 && computedBytesPerRow > maxBytesPerLine) {
                computedBytesPerRow = maxBytesPerLine;
            }
            if (wrappingBytesGroupSize > 1 && (wrappingBytesGroupOffset = computedBytesPerRow % wrappingBytesGroupSize) > 0) {
                computedBytesPerRow -= wrappingBytesGroupOffset;
            }
        } else {
            computedBytesPerRow = maxBytesPerLine;
        }
        if (computedBytesPerRow < 1) {
            computedBytesPerRow = 1;
        }
        return computedBytesPerRow;
    }

    @Override
    public long computeRowsPerDocument(SectionCodeAreaStructure structure) {
        long dataSize = structure.getDataSize();
        int bytesPerRow = structure.getBytesPerRow();
        return dataSize / (long)bytesPerRow + 1L;
    }

    @Override
    public int computePositionByte(int rowHalfCharPosition, SectionCodeAreaStructure structure) {
        CodeType codeType = structure.getCodeType();
        CodeAreaViewMode viewMode = structure.getViewMode();
        int bytesPerRow = structure.getBytesPerRow();
        PosIterator posIterator = new PosIterator(codeType, viewMode, bytesPerRow);
        int bytePosition = 0;
        while (posIterator.getHalfCharPosition() < rowHalfCharPosition && !posIterator.isEndReached()) {
            bytePosition = posIterator.getBytePosition();
            posIterator.nextSpaceType();
        }
        return bytePosition;
    }

    @Override
    public synchronized int computeFirstByteHalfCharPos(int byteOffset, CodeAreaSection section, SectionCodeAreaStructure structure) {
        CodeType codeType = structure.getCodeType();
        CodeAreaViewMode viewMode = structure.getViewMode();
        int bytesPerRow = structure.getBytesPerRow();
        PosIterator posIterator = new PosIterator(codeType, viewMode, bytesPerRow);
        while (!(posIterator.getBytePosition() >= byteOffset && posIterator.getSection() == section || posIterator.isEndReached())) {
            posIterator.nextSpaceType();
        }
        return posIterator.getHalfCharPosition();
    }

    @Override
    public int computeLastByteHalfCharPos(int byteOffset, CodeAreaSection section, SectionCodeAreaStructure structure) {
        CodeType codeType = structure.getCodeType();
        CodeAreaViewMode viewMode = structure.getViewMode();
        int bytesPerRow = structure.getBytesPerRow();
        PosIterator posIterator = new PosIterator(codeType, viewMode, bytesPerRow);
        int halfCharPos = 0;
        while (!(posIterator.getBytePosition() > byteOffset && posIterator.getSection() == section || posIterator.isEndReached())) {
            halfCharPos = posIterator.getHalfCharPosition();
            posIterator.nextSpaceType();
        }
        return halfCharPos;
    }

    @Override
    @Nonnull
    public CodeAreaCaretPosition computeMovePosition(CodeAreaCaretPosition position, MovementDirection direction, SectionCodeAreaStructure structure, int rowsPerPage) {
        CodeType codeType = structure.getCodeType();
        long dataSize = structure.getDataSize();
        int bytesPerRow = structure.getBytesPerRow();
        CodeAreaSection section = position.getSection().orElse(BasicCodeAreaSection.CODE_MATRIX);
        DefaultCodeAreaCaretPosition target = new DefaultCodeAreaCaretPosition(position.getDataPosition(), position.getCodeOffset(), section);
        switch (direction) {
            case LEFT: {
                if (section != BasicCodeAreaSection.TEXT_PREVIEW) {
                    int codeOffset = position.getCodeOffset();
                    if (codeOffset > 0) {
                        target.setCodeOffset(codeOffset - 1);
                        break;
                    }
                    if (position.getDataPosition() <= 0L) break;
                    target.setDataPosition(position.getDataPosition() - 1L);
                    target.setCodeOffset(codeType.getMaxDigitsForByte() - 1);
                    break;
                }
                if (position.getDataPosition() <= 0L) break;
                target.setDataPosition(position.getDataPosition() - 1L);
                break;
            }
            case RIGHT: {
                if (section != BasicCodeAreaSection.TEXT_PREVIEW) {
                    int codeOffset = position.getCodeOffset();
                    if (position.getDataPosition() < dataSize && codeOffset < codeType.getMaxDigitsForByte() - 1) {
                        target.setCodeOffset(codeOffset + 1);
                        break;
                    }
                    if (position.getDataPosition() >= dataSize) break;
                    target.setDataPosition(position.getDataPosition() + 1L);
                    target.setCodeOffset(0);
                    break;
                }
                if (position.getDataPosition() >= dataSize) break;
                target.setDataPosition(position.getDataPosition() + 1L);
                break;
            }
            case UP: {
                if (position.getDataPosition() < (long)bytesPerRow) break;
                target.setDataPosition(position.getDataPosition() - (long)bytesPerRow);
                break;
            }
            case DOWN: {
                if (position.getDataPosition() >= dataSize - (long)bytesPerRow && (position.getDataPosition() != dataSize - (long)bytesPerRow || position.getCodeOffset() != 0)) break;
                target.setDataPosition(position.getDataPosition() + (long)bytesPerRow);
                break;
            }
            case ROW_START: {
                long dataPosition = position.getDataPosition();
                dataPosition -= dataPosition % (long)bytesPerRow;
                target.setDataPosition(dataPosition);
                target.setCodeOffset(0);
                break;
            }
            case ROW_END: {
                long dataPosition = position.getDataPosition();
                long increment = (long)(bytesPerRow - 1) - dataPosition % (long)bytesPerRow;
                if (dataPosition > Long.MAX_VALUE - increment || dataPosition + increment > dataSize) {
                    target.setDataPosition(dataSize);
                } else {
                    target.setDataPosition(dataPosition + increment);
                }
                if (section == BasicCodeAreaSection.TEXT_PREVIEW) break;
                if (target.getDataPosition() == dataSize) {
                    target.setCodeOffset(0);
                    break;
                }
                target.setCodeOffset(codeType.getMaxDigitsForByte() - 1);
                break;
            }
            case PAGE_UP: {
                long dataPosition = position.getDataPosition();
                long increment = (long)bytesPerRow * (long)rowsPerPage;
                if (dataPosition < increment) {
                    target.setDataPosition(dataPosition % (long)bytesPerRow);
                    break;
                }
                target.setDataPosition(dataPosition - increment);
                break;
            }
            case PAGE_DOWN: {
                long dataPosition = position.getDataPosition();
                long increment = (long)bytesPerRow * (long)rowsPerPage;
                if (dataPosition > dataSize - increment) {
                    long lastRowDataStart = dataSize - dataSize % (long)bytesPerRow;
                    long positionOnRow = dataPosition % (long)bytesPerRow;
                    if (lastRowDataStart == dataSize - positionOnRow) {
                        target.setDataPosition(dataSize);
                        target.setCodeOffset(0);
                        break;
                    }
                    if (lastRowDataStart > dataSize - positionOnRow) {
                        if (lastRowDataStart <= (long)bytesPerRow) break;
                        target.setDataPosition((lastRowDataStart -= (long)bytesPerRow) + positionOnRow);
                        break;
                    }
                    target.setDataPosition(lastRowDataStart + positionOnRow);
                    break;
                }
                target.setDataPosition(dataPosition + increment);
                break;
            }
            case DOC_START: {
                target.setDataPosition(0L);
                target.setCodeOffset(0);
                break;
            }
            case DOC_END: {
                target.setDataPosition(dataSize);
                target.setCodeOffset(0);
                break;
            }
            case SWITCH_SECTION: {
                BasicCodeAreaSection activeSection;
                BasicCodeAreaSection basicCodeAreaSection = activeSection = section == BasicCodeAreaSection.TEXT_PREVIEW ? BasicCodeAreaSection.CODE_MATRIX : BasicCodeAreaSection.TEXT_PREVIEW;
                if (activeSection == BasicCodeAreaSection.TEXT_PREVIEW) {
                    target.setCodeOffset(0);
                }
                target.setSection(activeSection);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(direction);
            }
        }
        return target;
    }

    public int computeCodeCharacterPosition(long positionX, int characterWidth, int bytesPerRow, CodeType codeType) {
        SpaceType spaceType;
        PositionIterator charPositionIterator = this.createPositionIterator(codeType, CodeAreaViewMode.CODE_MATRIX, bytesPerRow);
        int charPositionX = 0;
        do {
            if (positionX < (long)charPositionX || positionX >= (long)(charPositionX + characterWidth)) continue;
            return charPositionIterator.getPosition();
        } while ((charPositionX += characterWidth + characterWidth * (spaceType = charPositionIterator.nextSpaceType()).getHalfCharSize()) < bytesPerRow * codeType.getMaxDigitsForByte());
        return -1;
    }

    public int computeClosestCharacterPosition(long positionX, int characterWidth, int bytesPerRow, CodeType codeType) {
        PositionIterator charPositionIterator = this.createPositionIterator(codeType, CodeAreaViewMode.CODE_MATRIX, bytesPerRow);
        int charPositionX = 0;
        do {
            if (positionX >= (long)charPositionX && positionX < (long)(charPositionX + characterWidth)) {
                return charPositionIterator.getPosition();
            }
            charPositionIterator.nextSpaceType();
            int halfSpaceSize = characterWidth / 2;
            if (positionX >= (long)(charPositionX += characterWidth) && positionX < (long)(charPositionX + halfSpaceSize)) {
                return charPositionIterator.getPosition() - 1;
            }
            if (positionX < (long)(charPositionX + halfSpaceSize) || positionX >= (long)(charPositionX + characterWidth)) continue;
            return charPositionIterator.getPosition();
        } while ((charPositionX += characterWidth) < bytesPerRow * codeType.getMaxDigitsForByte());
        return -1;
    }

    @Override
    @Nonnull
    public PositionIterator createPositionIterator(CodeType codeType, CodeAreaViewMode viewMode, int bytesPerRow) {
        return new PosIterator(codeType, viewMode, bytesPerRow);
    }

    public int computePixelPosition(int codeCharPosition, int characterWidth, CodeAreaViewMode viewMode, CodeType codeType, int bytesPerRow) {
        if (codeCharPosition == 0) {
            return 0;
        }
        int digitsPerByte = codeType.getMaxDigitsForByte();
        int firstPreviewCodeChar = viewMode == CodeAreaViewMode.TEXT_PREVIEW ? 0 : bytesPerRow * digitsPerByte;
        int halfSpaceWidth = characterWidth / 2;
        int positionX = 0;
        if (viewMode != CodeAreaViewMode.TEXT_PREVIEW) {
            PosIterator posIterator = new PosIterator(codeType, viewMode, bytesPerRow);
            while (posIterator.getPosition() < codeCharPosition) {
                posIterator.nextSpaceType();
                positionX = this.computePositionX(posIterator.getHalfCharPosition(), characterWidth, halfSpaceWidth);
            }
            if (codeCharPosition < firstPreviewCodeChar) {
                return positionX;
            }
        }
        if (viewMode != CodeAreaViewMode.CODE_MATRIX) {
            int previewCharPos = codeCharPosition - digitsPerByte * bytesPerRow;
            if (previewCharPos > bytesPerRow) {
                return -1;
            }
            return positionX + (viewMode == CodeAreaViewMode.DUAL ? characterWidth : 0) + previewCharPos * characterWidth;
        }
        return -1;
    }

    @Nonnull
    public SpaceType getSpaceSizeTypeBefore(int byteOffset, int characterWidth) {
        if (byteOffset == 0) {
            return SpaceType.NONE;
        }
        if (this.doubleSpaceGroupSize > 0 && byteOffset % this.doubleSpaceGroupSize == 0) {
            return SpaceType.DOUBLE;
        }
        if (this.spaceGroupSize > 0 && byteOffset % this.spaceGroupSize == 0) {
            return SpaceType.SINGLE;
        }
        if (this.halfSpaceGroupSize > 0 && byteOffset % this.halfSpaceGroupSize == 0) {
            return SpaceType.HALF;
        }
        return SpaceType.NONE;
    }

    @Override
    public int computePositionX(int halfCharPosition, int characterWidth, int halfSpaceWidth) {
        return characterWidth * (halfCharPosition >> 1) + halfSpaceWidth * (halfCharPosition & 1);
    }

    @Override
    public boolean isShowHeader() {
        return this.showHeader;
    }

    @Override
    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public int getBottomHeaderSpace() {
        return this.bottomHeaderSpace;
    }

    public void setBottomHeaderSpace(int bottomHeaderSpace) {
        this.bottomHeaderSpace = bottomHeaderSpace;
    }

    public int getLeftRowPositionSpace() {
        return this.leftRowPositionSpace;
    }

    public void setLeftRowPositionSpace(int leftRowPositionSpace) {
        this.leftRowPositionSpace = leftRowPositionSpace;
    }

    @Override
    public boolean isShowRowPosition() {
        return this.showRowPosition;
    }

    @Override
    public void setShowRowPosition(boolean showRowPosition) {
        this.showRowPosition = showRowPosition;
    }

    public int getTopHeaderSpace() {
        return this.topHeaderSpace;
    }

    public void setTopHeaderSpace(int topHeaderSpace) {
        this.topHeaderSpace = topHeaderSpace;
    }

    public int getRightRowPositionSpace() {
        return this.rightRowPositionSpace;
    }

    public void setRightRowPositionSpace(int rightRowPositionSpace) {
        this.rightRowPositionSpace = rightRowPositionSpace;
    }

    public int getHalfSpaceGroupSize() {
        return this.halfSpaceGroupSize;
    }

    public void setHalfSpaceGroupSize(int halfSpaceGroupSize) {
        this.halfSpaceGroupSize = halfSpaceGroupSize;
    }

    public int getSpaceGroupSize() {
        return this.spaceGroupSize;
    }

    public void setSpaceGroupSize(int spaceGroupSize) {
        this.spaceGroupSize = spaceGroupSize;
    }

    public int getDoubleSpaceGroupSize() {
        return this.doubleSpaceGroupSize;
    }

    public void setDoubleSpaceGroupSize(int doubleSpaceGroupSize) {
        this.doubleSpaceGroupSize = doubleSpaceGroupSize;
    }

    @Override
    public boolean isHalfShiftedUsed() {
        return this.halfSpaceGroupSize > 0;
    }

    @Override
    public int computeRowPositionAreaWidth(int characterWidth, int rowPositionLength) {
        return this.isShowRowPosition() ? characterWidth * (rowPositionLength + 1) + this.getLeftRowPositionSpace() + this.getRightRowPositionSpace() : 0;
    }

    @Override
    public int computeHeaderAreaHeight(int fontHeight) {
        return this.isShowHeader() ? fontHeight + fontHeight / 4 + this.getTopHeaderSpace() + this.getBottomHeaderSpace() : 0;
    }

    @Override
    public int computeHeaderOffsetPositionY() {
        return this.topHeaderSpace;
    }

    @Override
    public int computeRowPositionOffsetPositionX() {
        return this.leftRowPositionSpace;
    }

    @ParametersAreNonnullByDefault
    private final class PosIterator
    implements PositionIterator {
        private int position;
        private int bytePosition;
        private int halfCharPosition;
        private int codeOffset;
        private boolean oddHalf;
        private boolean endReached;
        @Nonnull
        private BasicCodeAreaSection section;
        private final int codeLength;
        @Nonnull
        private final CodeAreaViewMode viewMode;
        private final int bytesPerRow;
        private int halfSpacePos = 0;
        private int spacePos = 0;
        private int doubleSpacePos = 0;

        PosIterator(CodeType codeType, CodeAreaViewMode viewMode, int bytesPerRow) {
            this.codeLength = codeType.getMaxDigitsForByte();
            this.viewMode = viewMode;
            this.bytesPerRow = bytesPerRow;
            this.reset();
        }

        @Override
        public void reset() {
            this.endReached = false;
            this.position = 0;
            this.bytePosition = 0;
            this.halfCharPosition = 0;
            this.oddHalf = false;
            this.section = this.viewMode == CodeAreaViewMode.TEXT_PREVIEW ? BasicCodeAreaSection.TEXT_PREVIEW : BasicCodeAreaSection.CODE_MATRIX;
            this.codeOffset = 0;
            this.halfSpacePos = DefaultSectionCodeAreaLayoutProfile.this.halfSpaceGroupSize;
            this.spacePos = DefaultSectionCodeAreaLayoutProfile.this.spaceGroupSize;
            this.doubleSpacePos = DefaultSectionCodeAreaLayoutProfile.this.doubleSpaceGroupSize;
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public int getBytePosition() {
            return this.bytePosition;
        }

        @Override
        public int getHalfCharPosition() {
            return this.halfCharPosition;
        }

        @Override
        public int getCodeOffset() {
            return this.codeOffset;
        }

        @Override
        public boolean isEndReached() {
            return this.endReached;
        }

        @Override
        @Nonnull
        public BasicCodeAreaSection getSection() {
            return this.section;
        }

        @Override
        @Nonnull
        public SpaceType nextSpaceType() {
            if (this.endReached) {
                return SpaceType.NONE;
            }
            ++this.position;
            SpaceType spaceType = SpaceType.NONE;
            if (this.section != BasicCodeAreaSection.TEXT_PREVIEW) {
                if (this.codeOffset < this.codeLength - 1) {
                    ++this.codeOffset;
                    this.halfCharPosition += 2;
                    return spaceType;
                }
                if (this.doubleSpacePos > 0) {
                    if (this.doubleSpacePos == 1) {
                        spaceType = SpaceType.DOUBLE;
                        this.doubleSpacePos = DefaultSectionCodeAreaLayoutProfile.this.doubleSpaceGroupSize;
                    } else {
                        --this.doubleSpacePos;
                    }
                }
                if (this.spacePos > 0) {
                    if (this.spacePos == 1) {
                        if (spaceType == SpaceType.NONE) {
                            spaceType = SpaceType.SINGLE;
                        }
                        this.spacePos = DefaultSectionCodeAreaLayoutProfile.this.spaceGroupSize;
                    } else {
                        --this.spacePos;
                    }
                }
                if (this.halfSpacePos > 0) {
                    if (this.halfSpacePos == 1) {
                        if (spaceType == SpaceType.NONE) {
                            spaceType = SpaceType.HALF;
                            this.oddHalf = !this.oddHalf;
                        }
                        this.halfSpacePos = DefaultSectionCodeAreaLayoutProfile.this.halfSpaceGroupSize;
                    } else {
                        --this.halfSpacePos;
                    }
                }
                this.codeOffset = 0;
            }
            if (this.bytePosition + 1 == this.bytesPerRow) {
                if (this.viewMode == CodeAreaViewMode.DUAL && this.section == BasicCodeAreaSection.CODE_MATRIX) {
                    this.section = BasicCodeAreaSection.TEXT_PREVIEW;
                    this.bytePosition = 0;
                    spaceType = SpaceType.SINGLE;
                } else {
                    this.endReached = true;
                    spaceType = SpaceType.NONE;
                }
            } else {
                ++this.bytePosition;
            }
            this.halfCharPosition += 2 + spaceType.getHalfCharSize();
            return spaceType;
        }

        @Override
        public void skip(int count) {
            for (int step = 0; step < count; ++step) {
                this.nextSpaceType();
            }
        }
    }
}

