/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Objects;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.output.ProxyWriter;

public class FileWriterWithEncoding
extends ProxyWriter {
    public static Builder builder() {
        return new Builder();
    }

    private static OutputStreamWriter initWriter(File file2, Object encoding, boolean append) throws IOException {
        Objects.requireNonNull(file2, "file");
        OutputStream outputStream = null;
        boolean fileExistedAlready = file2.exists();
        try {
            outputStream = FileUtils.newOutputStream(file2, append);
            if (encoding == null || encoding instanceof Charset) {
                return new OutputStreamWriter(outputStream, Charsets.toCharset((Charset)encoding));
            }
            if (encoding instanceof CharsetEncoder) {
                return new OutputStreamWriter(outputStream, (CharsetEncoder)encoding);
            }
            return new OutputStreamWriter(outputStream, (String)encoding);
        }
        catch (IOException | RuntimeException ex4) {
            try {
                IOUtils.close((Closeable)outputStream);
            }
            catch (IOException e15) {
                ex4.addSuppressed(e15);
            }
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file2);
            }
            throw ex4;
        }
    }

    private FileWriterWithEncoding(Builder builder) throws IOException {
        super(FileWriterWithEncoding.initWriter(builder.checkOriginFile(), builder.getEncoder(), builder.append));
    }

    @Deprecated
    public FileWriterWithEncoding(File file2, Charset charset) throws IOException {
        this(file2, charset, false);
    }

    @Deprecated
    public FileWriterWithEncoding(File file2, Charset encoding, boolean append) throws IOException {
        this(FileWriterWithEncoding.initWriter(file2, encoding, append));
    }

    @Deprecated
    public FileWriterWithEncoding(File file2, CharsetEncoder charsetEncoder) throws IOException {
        this(file2, charsetEncoder, false);
    }

    @Deprecated
    public FileWriterWithEncoding(File file2, CharsetEncoder charsetEncoder, boolean append) throws IOException {
        this(FileWriterWithEncoding.initWriter(file2, charsetEncoder, append));
    }

    @Deprecated
    public FileWriterWithEncoding(File file2, String charsetName) throws IOException {
        this(file2, charsetName, false);
    }

    @Deprecated
    public FileWriterWithEncoding(File file2, String charsetName, boolean append) throws IOException {
        this(FileWriterWithEncoding.initWriter(file2, charsetName, append));
    }

    private FileWriterWithEncoding(OutputStreamWriter outputStreamWriter) {
        super(outputStreamWriter);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, Charset charset) throws IOException {
        this(new File(fileName), charset, false);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, Charset charset, boolean append) throws IOException {
        this(new File(fileName), charset, append);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, CharsetEncoder encoding) throws IOException {
        this(new File(fileName), encoding, false);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, CharsetEncoder charsetEncoder, boolean append) throws IOException {
        this(new File(fileName), charsetEncoder, append);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, String charsetName) throws IOException {
        this(new File(fileName), charsetName, false);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, String charsetName, boolean append) throws IOException {
        this(new File(fileName), charsetName, append);
    }

    public static class Builder
    extends AbstractStreamBuilder<FileWriterWithEncoding, Builder> {
        private boolean append;
        private CharsetEncoder charsetEncoder = super.getCharset().newEncoder();

        private File checkOriginFile() {
            return this.checkOrigin().getFile();
        }

        @Override
        public FileWriterWithEncoding get() throws IOException {
            return new FileWriterWithEncoding(this);
        }

        private Object getEncoder() {
            if (this.charsetEncoder != null && this.getCharset() != null && !this.charsetEncoder.charset().equals(this.getCharset())) {
                throw new IllegalStateException(String.format("Mismatched Charset(%s) and CharsetEncoder(%s)", this.getCharset(), this.charsetEncoder.charset()));
            }
            return this.charsetEncoder != null ? this.charsetEncoder : this.getCharset();
        }

        public Builder setAppend(boolean append) {
            this.append = append;
            return this;
        }

        public Builder setCharsetEncoder(CharsetEncoder charsetEncoder) {
            this.charsetEncoder = charsetEncoder;
            return this;
        }
    }
}

