/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.antlr.Tool;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public class DOTGenerator {
    public static final boolean STRIP_NONREDUCED_STATES = false;
    protected String arrowhead = "normal";
    protected String rankdir = "LR";
    public static STGroup stlib = new STGroupFile("org/antlr/tool/templates/dot/dot.stg");
    protected Set<Object> markedStates = null;
    protected Grammar grammar;

    public DOTGenerator(Grammar grammar) {
        this.grammar = grammar;
    }

    public String getDOT(State startState) {
        ST dot;
        if (startState == null) {
            return null;
        }
        this.markedStates = new HashSet<Object>();
        if (startState instanceof DFAState) {
            dot = stlib.getInstanceOf("dfa");
            dot.add("startState", Utils.integer(startState.stateNumber));
            dot.add("useBox", Tool.internalOption_ShowNFAConfigsInDFA);
            this.walkCreatingDFADOT(dot, (DFAState)startState);
        } else {
            dot = stlib.getInstanceOf("nfa");
            dot.add("startState", Utils.integer(startState.stateNumber));
            this.walkRuleNFACreatingDOT(dot, startState);
        }
        dot.add("rankdir", this.rankdir);
        return dot.render();
    }

    protected void walkCreatingDFADOT(ST dot, DFAState s15) {
        if (this.markedStates.contains(Utils.integer(s15.stateNumber))) {
            return;
        }
        this.markedStates.add(Utils.integer(s15.stateNumber));
        ST st4 = s15.isAcceptState() ? stlib.getInstanceOf("stopstate") : stlib.getInstanceOf("state");
        st4.add("name", this.getStateLabel(s15));
        dot.add("states", st4);
        for (int i15 = 0; i15 < s15.getNumberOfTransitions(); ++i15) {
            Transition edge = s15.transition(i15);
            st4 = stlib.getInstanceOf("edge");
            st4.add("label", this.getEdgeLabel(edge));
            st4.add("src", this.getStateLabel(s15));
            st4.add("target", this.getStateLabel(edge.target));
            st4.add("arrowhead", this.arrowhead);
            dot.add("edges", st4);
            this.walkCreatingDFADOT(dot, (DFAState)edge.target);
        }
    }

    protected void walkRuleNFACreatingDOT(ST dot, State s15) {
        GrammarAST n15;
        if (this.markedStates.contains(s15)) {
            return;
        }
        this.markedStates.add(s15);
        ST stateST = s15.isAcceptState() ? stlib.getInstanceOf("stopstate") : stlib.getInstanceOf("state");
        stateST.add("name", this.getStateLabel(s15));
        dot.add("states", stateST);
        if (s15.isAcceptState()) {
            return;
        }
        if (((NFAState)s15).isDecisionState() && (n15 = ((NFAState)s15).associatedASTNode) != null && n15.getType() != 33) {
            ST rankST = stlib.getInstanceOf("decision-rank");
            NFAState alt = (NFAState)s15;
            while (alt != null) {
                rankST.add("states", this.getStateLabel(alt));
                if (alt.transition[1] != null) {
                    alt = (NFAState)alt.transition[1].target;
                    continue;
                }
                alt = null;
            }
            dot.add("decisionRanks", rankST);
        }
        for (int i15 = 0; i15 < s15.getNumberOfTransitions(); ++i15) {
            ST edgeST;
            Transition edge = s15.transition(i15);
            if (edge instanceof RuleClosureTransition) {
                RuleClosureTransition rr4 = (RuleClosureTransition)edge;
                edgeST = stlib.getInstanceOf("edge");
                if (rr4.rule.grammar != this.grammar) {
                    edgeST.add("label", "<" + rr4.rule.grammar.name + "." + rr4.rule.name + ">");
                } else {
                    edgeST.add("label", "<" + rr4.rule.name + ">");
                }
                edgeST.add("src", this.getStateLabel(s15));
                edgeST.add("target", this.getStateLabel(rr4.followState));
                edgeST.add("arrowhead", this.arrowhead);
                dot.add("edges", edgeST);
                this.walkRuleNFACreatingDOT(dot, rr4.followState);
                continue;
            }
            edgeST = edge.isAction() ? stlib.getInstanceOf("action-edge") : (edge.isEpsilon() ? stlib.getInstanceOf("epsilon-edge") : stlib.getInstanceOf("edge"));
            edgeST.add("label", this.getEdgeLabel(edge));
            edgeST.add("src", this.getStateLabel(s15));
            edgeST.add("target", this.getStateLabel(edge.target));
            edgeST.add("arrowhead", this.arrowhead);
            dot.add("edges", edgeST);
            this.walkRuleNFACreatingDOT(dot, edge.target);
        }
    }

    protected String getEdgeLabel(Transition edge) {
        SemanticContext preds;
        String label = edge.label.toString(this.grammar);
        label = Utils.replace(label, "\\", "\\\\");
        label = Utils.replace(label, "\"", "\\\"");
        label = Utils.replace(label, "\n", "\\\\n");
        if ((label = Utils.replace(label, "\r", "")).equals("<EPSILON>")) {
            label = "e";
        }
        State target = edge.target;
        if (!edge.isSemanticPredicate() && target instanceof DFAState && (preds = ((DFAState)target).getGatedPredicatesInNFAConfigurations()) != null) {
            String predsStr = "&&{" + preds.genExpr(this.grammar.generator, this.grammar.generator.getTemplates(), null).render() + "}?";
            label = label + predsStr;
        }
        return label;
    }

    protected String getStateLabel(State s15) {
        if (s15 == null) {
            return "null";
        }
        String stateLabel = String.valueOf(s15.stateNumber);
        if (s15 instanceof DFAState) {
            StringBuilder buf = new StringBuilder(250);
            buf.append('s');
            buf.append(s15.stateNumber);
            if (Tool.internalOption_ShowNFAConfigsInDFA) {
                Set<Integer> alts;
                if (s15 instanceof DFAState && ((DFAState)s15).abortedDueToRecursionOverflow) {
                    buf.append("\\n");
                    buf.append("abortedDueToRecursionOverflow");
                }
                if ((alts = ((DFAState)s15).getAltSet()) != null) {
                    buf.append("\\n");
                    ArrayList<Integer> altList = new ArrayList<Integer>();
                    altList.addAll(alts);
                    Collections.sort(altList);
                    OrderedHashSet<NFAConfiguration> configurations = ((DFAState)s15).nfaConfigurations;
                    for (int altIndex = 0; altIndex < altList.size(); ++altIndex) {
                        Integer altI = (Integer)altList.get(altIndex);
                        int alt = altI;
                        if (altIndex > 0) {
                            buf.append("\\n");
                        }
                        buf.append("alt");
                        buf.append(alt);
                        buf.append(':');
                        ArrayList<NFAConfiguration> configsInAlt = new ArrayList<NFAConfiguration>();
                        for (NFAConfiguration c15 : configurations) {
                            if (c15.alt != alt) continue;
                            configsInAlt.add(c15);
                        }
                        int n15 = 0;
                        for (int cIndex = 0; cIndex < configsInAlt.size(); ++cIndex) {
                            NFAConfiguration c16 = (NFAConfiguration)configsInAlt.get(cIndex);
                            ++n15;
                            buf.append(c16.toString(false));
                            if (cIndex + 1 < configsInAlt.size()) {
                                buf.append(", ");
                            }
                            if (n15 % 5 != 0 || configsInAlt.size() - cIndex <= 3) continue;
                            buf.append("\\n");
                        }
                    }
                }
            }
            stateLabel = buf.toString();
        }
        if (s15 instanceof NFAState && ((NFAState)s15).isDecisionState()) {
            stateLabel = stateLabel + ",d=" + ((NFAState)s15).getDecisionNumber();
            if (((NFAState)s15).endOfBlockStateNumber != -1) {
                stateLabel = stateLabel + ",eob=" + ((NFAState)s15).endOfBlockStateNumber;
            }
        } else if (s15 instanceof NFAState && ((NFAState)s15).endOfBlockStateNumber != -1) {
            NFAState n16 = (NFAState)s15;
            stateLabel = stateLabel + ",eob=" + n16.endOfBlockStateNumber;
        } else if (s15 instanceof DFAState && ((DFAState)s15).isAcceptState()) {
            stateLabel = stateLabel + "=>" + ((DFAState)s15).getUniquelyPredictedAlt();
        }
        return '\"' + stateLabel + '\"';
    }

    public String getArrowheadType() {
        return this.arrowhead;
    }

    public void setArrowheadType(String arrowhead) {
        this.arrowhead = arrowhead;
    }

    public String getRankdir() {
        return this.rankdir;
    }

    public void setRankdir(String rankdir) {
        this.rankdir = rankdir;
    }
}

