/*
 * Decompiled with CFR 0.152.
 */
package jadx.zip.parser;

import jadx.zip.IZipEntry;
import jadx.zip.parser.JadxZipParser;
import java.io.File;
import java.io.InputStream;

public final class JadxZipEntry
implements IZipEntry {
    private final JadxZipParser parser;
    private final String fileName;
    private final int compressMethod;
    private final int entryStart;
    private final int dataStart;
    private final long compressedSize;
    private final long uncompressedSize;

    JadxZipEntry(JadxZipParser parser, String fileName, int entryStart, int dataStart, int compressMethod, long compressedSize, long uncompressedSize) {
        this.parser = parser;
        this.fileName = fileName;
        this.entryStart = entryStart;
        this.dataStart = dataStart;
        this.compressMethod = compressMethod;
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
    }

    public boolean isSizesValid() {
        if (this.compressedSize <= 0L) {
            return false;
        }
        if (this.uncompressedSize <= 0L) {
            return false;
        }
        return this.compressedSize <= this.uncompressedSize;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public long getCompressedSize() {
        return this.compressedSize;
    }

    @Override
    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    @Override
    public boolean isDirectory() {
        return this.fileName.endsWith("/");
    }

    @Override
    public boolean preferBytes() {
        return true;
    }

    @Override
    public byte[] getBytes() {
        return this.parser.getBytes(this);
    }

    @Override
    public InputStream getInputStream() {
        return this.parser.getInputStream(this);
    }

    public int getEntryStart() {
        return this.entryStart;
    }

    public int getDataStart() {
        return this.dataStart;
    }

    public int getCompressMethod() {
        return this.compressMethod;
    }

    @Override
    public File getZipFile() {
        return this.parser.getZipFile();
    }

    public String toString() {
        return this.parser.getZipFile().getName() + ":" + this.fileName;
    }
}

