/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.mappings;

import jadx.api.JadxArgs;
import jadx.api.args.UserRenamesMappingsMode;
import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.JadxPluginContext;
import jadx.api.plugins.JadxPluginInfo;
import jadx.core.utils.files.FileUtils;
import jadx.plugins.mappings.RenameMappingsOptions;
import jadx.plugins.mappings.load.ApplyMappingsPass;
import jadx.plugins.mappings.load.CodeMappingsPass;
import jadx.plugins.mappings.load.LoadMappingsPass;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class RenameMappingsPlugin
implements JadxPlugin {
    public static final String PLUGIN_ID = "rename-mappings";
    private final RenameMappingsOptions options = new RenameMappingsOptions();

    @Override
    public JadxPluginInfo getPluginInfo() {
        return new JadxPluginInfo(PLUGIN_ID, "Rename Mappings", "various mappings support");
    }

    @Override
    public void init(JadxPluginContext context) {
        context.registerOptions(this.options);
        JadxArgs args = context.getArgs();
        if (args.getUserRenamesMappingsMode() == UserRenamesMappingsMode.IGNORE) {
            return;
        }
        Path mappingsPath = args.getUserRenamesMappingsPath();
        if (mappingsPath == null || !Files.isReadable(mappingsPath)) {
            return;
        }
        context.addPass(new LoadMappingsPass(this.options));
        context.addPass(new ApplyMappingsPass());
        context.addPass(new CodeMappingsPass());
        context.registerInputsHashSupplier(() -> FileUtils.md5Sum(this.getInputsHashString(mappingsPath)));
    }

    private String getInputsHashString(Path mappingsPath) {
        return RenameMappingsPlugin.getFileHashString(mappingsPath) + ":" + this.options.getOptionsHashString();
    }

    private static String getFileHashString(Path mappingsPath) {
        try {
            return String.valueOf(mappingsPath.toAbsolutePath().normalize()) + ":" + Files.getLastModifiedTime(mappingsPath, new LinkOption[0]).toMillis();
        }
        catch (Exception e15) {
            return "";
        }
    }
}

