/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.utils;

import io.github.skylot.raung.disasm.RaungDisasm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisasmUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DisasmUtils.class);

    public static String get(byte[] bytes) {
        return DisasmUtils.useRaung(bytes);
    }

    private static String useRaung(byte[] bytes) {
        return RaungDisasm.create().executeForBytes(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String useSystemJavaP(byte[] bytes) {
        String string;
        block6: {
            Path tmpCls = null;
            try {
                tmpCls = Files.createTempFile("jadx", ".class", new FileAttribute[0]);
                Files.write(tmpCls, bytes, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                Process process = Runtime.getRuntime().exec(new String[]{"javap", "-constants", "-v", "-p", "-c", tmpCls.toAbsolutePath().toString()});
                process.waitFor(2L, TimeUnit.SECONDS);
                string = DisasmUtils.inputStreamToString(process.getInputStream());
                if (tmpCls == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (tmpCls != null) {
                        Files.delete(tmpCls);
                    }
                    throw throwable;
                }
                catch (Exception e15) {
                    LOG.error("Java class disasm error", e15);
                    return "error";
                }
            }
            Files.delete(tmpCls);
        }
        return string;
    }

    public static String inputStreamToString(InputStream in4) throws IOException {
        int r15;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((r15 = in4.read(buf)) != -1) {
            out.write(buf, 0, r15);
        }
        return out.toString();
    }
}

