/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.utils;

import jadx.plugins.input.java.data.JavaMethodProto;
import jadx.plugins.input.java.utils.JavaClassParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DescriptorParser {
    private final String desc;
    private int pos;

    public static void fillMethodProto(String mthDesc, JavaMethodProto mthProto) {
        new DescriptorParser(mthDesc).parseMethodDescriptor(mthProto);
    }

    public static JavaMethodProto parseToMethodProto(String mthDesc) {
        JavaMethodProto mthProto = new JavaMethodProto();
        new DescriptorParser(mthDesc).parseMethodDescriptor(mthProto);
        return mthProto;
    }

    private DescriptorParser(String desc) {
        this.desc = desc;
    }

    private void parseMethodDescriptor(JavaMethodProto mthProto) {
        this.validate('(');
        if (this.check(')')) {
            mthProto.setArgTypes(Collections.emptyList());
        } else {
            mthProto.setArgTypes(this.readArgsList());
        }
        this.validate(')');
        mthProto.setReturnType(this.readType());
    }

    private List<String> readArgsList() {
        ArrayList<String> list2 = new ArrayList<String>(5);
        do {
            list2.add(this.readType());
        } while (!this.check(')'));
        return list2;
    }

    private String readType() {
        int cur;
        if ((cur = this.pos++) >= this.desc.length()) {
            return null;
        }
        char ch4 = this.desc.charAt(cur);
        switch (ch4) {
            case 'L': {
                int end = this.desc.indexOf(59, cur);
                if (end == -1) {
                    throw new JavaClassParseException("Unexpected object type descriptor: " + this.desc);
                }
                int lastChar = end + 1;
                String type = this.desc.substring(cur, lastChar);
                this.pos = lastChar;
                return type;
            }
            case '[': {
                return "[" + this.readType();
            }
        }
        String primitiveType = this.parsePrimitiveType(ch4);
        this.pos = cur + 1;
        return primitiveType;
    }

    public String parsePrimitiveType(char f15) {
        switch (f15) {
            case 'Z': {
                return "Z";
            }
            case 'B': {
                return "B";
            }
            case 'C': {
                return "C";
            }
            case 'S': {
                return "S";
            }
            case 'I': {
                return "I";
            }
            case 'J': {
                return "J";
            }
            case 'F': {
                return "F";
            }
            case 'D': {
                return "D";
            }
            case 'V': {
                return "V";
            }
        }
        throw new JavaClassParseException("Unexpected char '" + f15 + "' in descriptor " + this.desc);
    }

    private boolean check(char exp) {
        return this.desc.charAt(this.pos) == exp;
    }

    private void validate(char exp) {
        if (!this.check(exp)) {
            throw new JavaClassParseException("Unexpected char in descriptor: " + this.desc + " at pos " + this.pos + ", expected: " + exp);
        }
        ++this.pos;
    }
}

