/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.attributes.debuginfo;

import jadx.api.plugins.input.data.ILocalVar;
import org.jetbrains.annotations.Nullable;

public class JavaLocalVar
implements ILocalVar {
    private int regNum;
    private final String name;
    private final String type;
    @Nullable
    private String sign;
    private final int startOffset;
    private final int endOffset;

    public JavaLocalVar(int regNum, String name, @Nullable String type, @Nullable String sign, int startOffset, int endOffset) {
        this.regNum = regNum;
        this.name = name;
        this.type = type;
        this.sign = sign;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public void shiftRegNum(int maxStack) {
        this.regNum += maxStack;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRegNum() {
        return this.regNum;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    @Nullable
    public String getSignature() {
        return this.sign;
    }

    public void setSignature(String sign) {
        this.sign = sign;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public boolean isMarkedAsParameter() {
        return false;
    }

    public int hashCode() {
        int result = this.regNum;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.startOffset;
        result = 31 * result + this.endOffset;
        return result;
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (!(o15 instanceof JavaLocalVar)) {
            return false;
        }
        JavaLocalVar other = (JavaLocalVar)o15;
        return this.regNum == other.regNum && this.startOffset == other.startOffset && this.endOffset == other.endOffset && this.name.equals(other.name);
    }

    private static String formatOffset(int offset) {
        return String.format("0x%04x", offset);
    }

    public String toString() {
        return JavaLocalVar.formatOffset(this.startOffset) + "-" + JavaLocalVar.formatOffset(this.endOffset) + ": r" + this.regNum + " '" + this.name + "' " + this.type + (String)(this.sign != null ? ", signature: " + this.sign : "");
    }
}

