/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.utils;

import jadx.plugins.input.dex.DexException;
import jadx.plugins.input.dex.sections.SectionReader;

public class MUtf8 {
    public static String decode(SectionReader in4) {
        int len = in4.readUleb128();
        char[] out = new char[len];
        int k15 = 0;
        while (true) {
            int b15;
            char a15;
            if ((a15 = (char)(in4.readUByte() & 0xFF)) == '\u0000') {
                return new String(out, 0, k15);
            }
            out[k15] = a15;
            if (a15 < '\u0080') {
                ++k15;
                continue;
            }
            if ((a15 & 0xE0) == 192) {
                b15 = in4.readUByte();
                if ((b15 & 0xC0) != 128) {
                    throw new DexException("Bad second byte");
                }
                out[k15] = (char)((a15 & 0x1F) << 6 | b15 & 0x3F);
                ++k15;
                continue;
            }
            if ((a15 & 0xF0) != 224) break;
            b15 = in4.readUByte();
            int c15 = in4.readUByte();
            if ((b15 & 0xC0) != 128 || (c15 & 0xC0) != 128) {
                throw new DexException("Bad second or third byte");
            }
            out[k15] = (char)((a15 & 0xF) << 12 | (b15 & 0x3F) << 6 | c15 & 0x3F);
            ++k15;
        }
        throw new DexException("Bad byte");
    }
}

