/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab;

import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.tab.ITabStatesListener;
import jadx.gui.ui.tab.QuickTabsBaseNode;
import jadx.gui.ui.tab.QuickTabsBookmarkParentNode;
import jadx.gui.ui.tab.QuickTabsChildNode;
import jadx.gui.ui.tab.QuickTabsOpenParentNode;
import jadx.gui.ui.tab.QuickTabsParentNode;
import jadx.gui.ui.tab.QuickTabsPinParentNode;
import jadx.gui.ui.tab.TabBlueprint;
import jadx.gui.ui.tab.TabsController;
import jadx.gui.utils.UiUtils;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class QuickTabsTree
extends JTree
implements ITabStatesListener,
TreeSelectionListener {
    private final MainWindow mainWindow;
    private final DefaultTreeModel treeModel;
    private final QuickTabsParentNode openParentNode;
    private final QuickTabsParentNode pinParentNode;
    private final QuickTabsParentNode bookmarkParentNode;

    public QuickTabsTree(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        mainWindow.getTabsController().addListener(this);
        Root root = new Root();
        this.pinParentNode = new QuickTabsPinParentNode(mainWindow.getTabsController());
        this.openParentNode = new QuickTabsOpenParentNode(mainWindow.getTabsController());
        this.bookmarkParentNode = new QuickTabsBookmarkParentNode(mainWindow.getTabsController());
        root.add(this.openParentNode);
        root.add(this.pinParentNode);
        root.add(this.bookmarkParentNode);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
        this.setCellRenderer(new CellRenderer());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e15) {
                TreeNode pressedNode = UiUtils.getTreeNodeUnderMouse(QuickTabsTree.this, e15);
                if (SwingUtilities.isLeftMouseButton(e15) && QuickTabsTree.this.nodeClickAction(pressedNode)) {
                    QuickTabsTree.this.setFocusable(true);
                    QuickTabsTree.this.requestFocus();
                }
                if (SwingUtilities.isRightMouseButton(e15)) {
                    QuickTabsTree.this.triggerRightClickAction(e15);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e15) {
                if (e15.getKeyCode() == 10) {
                    QuickTabsTree.this.nodeClickAction(QuickTabsTree.this.getLastSelectedPathComponent());
                }
            }
        });
        this.loadSettings();
        this.fillOpenParentNode();
        this.fillPinParentNode();
        this.fillBookmarkParentNode();
    }

    private void triggerRightClickAction(MouseEvent e15) {
        TreeNode treeNode = UiUtils.getTreeNodeUnderMouse(this, e15);
        if (!(treeNode instanceof QuickTabsBaseNode)) {
            return;
        }
        QuickTabsBaseNode quickTabsNode = (QuickTabsBaseNode)treeNode;
        JPopupMenu menu = quickTabsNode.onTreePopupMenu(this.mainWindow);
        if (menu != null) {
            menu.show(e15.getComponent(), e15.getX(), e15.getY());
        }
    }

    private boolean nodeClickAction(Object pressedNode) {
        if (pressedNode == null) {
            return false;
        }
        if (pressedNode instanceof QuickTabsChildNode) {
            QuickTabsChildNode childNode = (QuickTabsChildNode)pressedNode;
            this.mainWindow.getTabsController().selectTab(childNode.getJNode());
            return true;
        }
        return false;
    }

    private void fillOpenParentNode() {
        this.mainWindow.getTabsController().getOpenTabs().forEach(this::onTabOpen);
    }

    private void fillPinParentNode() {
        this.mainWindow.getTabsController().getPinnedTabs().forEach(this::onTabPinChange);
    }

    private void fillBookmarkParentNode() {
        this.mainWindow.getTabsController().getBookmarkedTabs().forEach(this::onTabBookmarkChange);
    }

    private void clearParentNode(QuickTabsParentNode parentNode) {
        int[] childIndices = new int[parentNode.getChildCount()];
        Object[] objects = new Object[parentNode.getChildCount()];
        for (int i15 = 0; i15 < childIndices.length; ++i15) {
            childIndices[i15] = i15;
            objects[i15] = parentNode.getChildAt(i15);
        }
        parentNode.removeAllNodes();
        this.treeModel.nodesWereRemoved(parentNode, childIndices, objects);
    }

    private void addJNode(QuickTabsParentNode parentNode, JNode node) {
        if (parentNode.addJNode(node)) {
            this.treeModel.nodesWereInserted(parentNode, new int[]{parentNode.getChildCount() - 1});
        }
    }

    private void removeJNode(QuickTabsParentNode parentNode, JNode node) {
        QuickTabsChildNode child = parentNode.getQuickTabsNode(node);
        if (child != null) {
            int removedIndex = parentNode.getIndex(child);
            if (parentNode.removeJNode(node)) {
                this.treeModel.nodesWereRemoved(parentNode, new int[]{removedIndex}, new Object[]{child});
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (selectedNode != null && selectedNode instanceof QuickTabsChildNode) {
            QuickTabsChildNode childNode = (QuickTabsChildNode)selectedNode;
            JNode jNode = childNode.getJNode();
            TabsController tabsController = this.mainWindow.getTabsController();
            tabsController.selectTab(jNode);
        }
    }

    public void loadSettings() {
        this.setFont(this.mainWindow.getSettings().getCodeFont());
    }

    public void dispose() {
        this.mainWindow.getTabsController().removeListener(this);
    }

    @Override
    public void onTabOpen(TabBlueprint blueprint) {
        if (!blueprint.isHidden() && blueprint.getNode().supportsQuickTabs()) {
            this.addJNode(this.openParentNode, blueprint.getNode());
        }
    }

    @Override
    public void onTabClose(TabBlueprint blueprint) {
        this.removeJNode(this.openParentNode, blueprint.getNode());
        this.removeJNode(this.pinParentNode, blueprint.getNode());
        this.removeJNode(this.bookmarkParentNode, blueprint.getNode());
    }

    @Override
    public void onTabPinChange(TabBlueprint blueprint) {
        JNode node = blueprint.getNode();
        if (blueprint.isPinned()) {
            this.addJNode(this.pinParentNode, node);
        } else {
            this.removeJNode(this.pinParentNode, node);
        }
    }

    @Override
    public void onTabBookmarkChange(TabBlueprint blueprint) {
        JNode node = blueprint.getNode();
        if (blueprint.isBookmarked()) {
            this.addJNode(this.bookmarkParentNode, node);
        } else {
            this.removeJNode(this.bookmarkParentNode, node);
        }
    }

    @Override
    public void onTabVisibilityChange(TabBlueprint blueprint) {
        JNode node = blueprint.getNode();
        if (!blueprint.isHidden()) {
            this.addJNode(this.openParentNode, node);
        } else {
            this.removeJNode(this.openParentNode, node);
        }
    }

    private class Root
    extends DefaultMutableTreeNode {
        private Root() {
        }
    }

    private class CellRenderer
    extends DefaultTreeCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c15 = super.getTreeCellRendererComponent(tree, value, this.selected, expanded, leaf, row, hasFocus);
            if (value instanceof QuickTabsBaseNode) {
                QuickTabsBaseNode quickTabsNode = (QuickTabsBaseNode)value;
                this.setIcon(quickTabsNode.getIcon());
            }
            return c15;
        }
    }
}

