/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.typeinference.BoundEnum;
import jadx.core.dex.visitors.typeinference.ITypeBoundDynamic;
import jadx.core.dex.visitors.typeinference.TypeUpdateInfo;

public final class TypeBoundFieldGetAssign
implements ITypeBoundDynamic {
    private final RootNode root;
    private final IndexInsnNode getNode;
    private final FieldInfo fieldInfo;
    private final ArgType initType;

    public TypeBoundFieldGetAssign(RootNode root, IndexInsnNode getNode, ArgType initType) {
        this.root = root;
        this.getNode = getNode;
        this.fieldInfo = (FieldInfo)getNode.getIndex();
        this.initType = initType;
    }

    @Override
    public BoundEnum getBound() {
        return BoundEnum.ASSIGN;
    }

    @Override
    public ArgType getType(TypeUpdateInfo updateInfo) {
        return this.getResultType(updateInfo.getType(this.getInstanceArg()));
    }

    @Override
    public ArgType getType() {
        return this.getResultType(this.getInstanceArg().getType());
    }

    private ArgType getResultType(ArgType instanceType) {
        ArgType resultGeneric = this.root.getTypeUtils().replaceClassGenerics(instanceType, this.initType);
        if (resultGeneric != null && !resultGeneric.isWildcard()) {
            return resultGeneric;
        }
        return this.initType;
    }

    private InsnArg getInstanceArg() {
        return this.getNode.getArg(0);
    }

    @Override
    public RegisterArg getArg() {
        return this.getNode.getResult();
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (o15 == null || this.getClass() != o15.getClass()) {
            return false;
        }
        TypeBoundFieldGetAssign that = (TypeBoundFieldGetAssign)o15;
        return this.getNode.equals(that.getNode);
    }

    public int hashCode() {
        return this.getNode.hashCode();
    }

    public String toString() {
        return "FieldGetAssign{" + String.valueOf(this.fieldInfo) + ", type=" + String.valueOf(this.getType()) + ", instanceArg=" + String.valueOf(this.getInstanceArg()) + "}";
    }
}

