/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscriptions;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class AsyncSubscription
extends AtomicLong
implements Subscription,
Disposable {
    private static final long serialVersionUID = 7028635084060361255L;
    final AtomicReference<Subscription> actual;
    final AtomicReference<Disposable> resource = new AtomicReference();

    public AsyncSubscription() {
        this.actual = new AtomicReference();
    }

    public AsyncSubscription(Disposable resource) {
        this();
        this.resource.lazySet(resource);
    }

    @Override
    public void request(long n15) {
        SubscriptionHelper.deferredRequest(this.actual, this, n15);
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this.actual);
        DisposableHelper.dispose(this.resource);
    }

    @Override
    public boolean isDisposed() {
        return this.actual.get() == SubscriptionHelper.CANCELLED;
    }

    public boolean setResource(Disposable r15) {
        return DisposableHelper.set(this.resource, r15);
    }

    public boolean replaceResource(Disposable r15) {
        return DisposableHelper.replace(this.resource, r15);
    }

    public void setSubscription(Subscription s15) {
        SubscriptionHelper.deferredSetOnce(this.actual, this, s15);
    }
}

