/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableTakeUntilPredicate<T>
extends AbstractObservableWithUpstream<T, T> {
    final Predicate<? super T> predicate;

    public ObservableTakeUntilPredicate(ObservableSource<T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = predicate;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new TakeUntilPredicateObserver<T>(observer, this.predicate));
    }

    static final class TakeUntilPredicateObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final Predicate<? super T> predicate;
        Disposable upstream;
        boolean done;

        TakeUntilPredicateObserver(Observer<? super T> downstream, Predicate<? super T> predicate) {
            this.downstream = downstream;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t15) {
            if (!this.done) {
                boolean b15;
                this.downstream.onNext(t15);
                try {
                    b15 = this.predicate.test(t15);
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.upstream.dispose();
                    this.onError(e15);
                    return;
                }
                if (b15) {
                    this.done = true;
                    this.upstream.dispose();
                    this.downstream.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (!this.done) {
                this.done = true;
                this.downstream.onError(t15);
            } else {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
            }
        }
    }
}

