/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CompletableAmb
extends Completable {
    private final CompletableSource[] sources;
    private final Iterable<? extends CompletableSource> sourcesIterable;

    public CompletableAmb(CompletableSource[] sources, Iterable<? extends CompletableSource> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        CompletableSource[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new CompletableSource[8];
            try {
                for (CompletableSource completableSource : this.sourcesIterable) {
                    if (completableSource == null) {
                        EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), observer);
                        return;
                    }
                    if (count == sources.length) {
                        CompletableSource[] b15 = new CompletableSource[count + (count >> 2)];
                        System.arraycopy(sources, 0, b15, 0, count);
                        sources = b15;
                    }
                    sources[count++] = completableSource;
                }
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                EmptyDisposable.error(e15, observer);
                return;
            }
        } else {
            count = sources.length;
        }
        CompositeDisposable set = new CompositeDisposable();
        observer.onSubscribe(set);
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        for (int i15 = 0; i15 < count; ++i15) {
            CompletableSource c15 = sources[i15];
            if (set.isDisposed()) {
                return;
            }
            if (c15 == null) {
                NullPointerException npe = new NullPointerException("One of the sources is null");
                if (atomicBoolean.compareAndSet(false, true)) {
                    set.dispose();
                    observer.onError(npe);
                } else {
                    RxJavaPlugins.onError(npe);
                }
                return;
            }
            c15.subscribe(new Amb(atomicBoolean, set, observer));
        }
        if (count == 0) {
            observer.onComplete();
        }
    }

    static final class Amb
    implements CompletableObserver {
        final AtomicBoolean once;
        final CompositeDisposable set;
        final CompletableObserver downstream;
        Disposable upstream;

        Amb(AtomicBoolean once, CompositeDisposable set, CompletableObserver observer) {
            this.once = once;
            this.set = set;
            this.downstream = observer;
        }

        @Override
        public void onComplete() {
            if (this.once.compareAndSet(false, true)) {
                this.set.delete(this.upstream);
                this.set.dispose();
                this.downstream.onComplete();
            }
        }

        @Override
        public void onError(Throwable e15) {
            if (this.once.compareAndSet(false, true)) {
                this.set.delete(this.upstream);
                this.set.dispose();
                this.downstream.onError(e15);
            } else {
                RxJavaPlugins.onError(e15);
            }
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.upstream = d15;
            this.set.add(d15);
        }
    }
}

