/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiConsumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class BiConsumerSingleObserver<T>
extends AtomicReference<Disposable>
implements SingleObserver<T>,
Disposable {
    private static final long serialVersionUID = 4943102778943297569L;
    final BiConsumer<? super T, ? super Throwable> onCallback;

    public BiConsumerSingleObserver(BiConsumer<? super T, ? super Throwable> onCallback) {
        this.onCallback = onCallback;
    }

    @Override
    public void onError(Throwable e15) {
        try {
            this.lazySet(DisposableHelper.DISPOSED);
            this.onCallback.accept(null, e15);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            RxJavaPlugins.onError(new CompositeException(e15, ex4));
        }
    }

    @Override
    public void onSubscribe(Disposable d15) {
        DisposableHelper.setOnce(this, d15);
    }

    @Override
    public void onSuccess(T value) {
        try {
            this.lazySet(DisposableHelper.DISPOSED);
            this.onCallback.accept(value, null);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            RxJavaPlugins.onError(ex4);
        }
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == DisposableHelper.DISPOSED;
    }
}

