/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl.visitors;

import io.github.skylot.raung.disasm.impl.utils.RaungWriter;
import io.github.skylot.raung.disasm.impl.visitors.RaungAnnotationVisitor;
import io.github.skylot.raung.disasm.impl.visitors.RaungClassVisitor;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.TypePath;

public class RaungFieldVisitor
extends FieldVisitor {
    private final RaungWriter writer;
    private final RaungClassVisitor clsVisitor;
    private boolean closeField;

    public RaungFieldVisitor(RaungClassVisitor clsVisitor, boolean closeField) {
        super(clsVisitor.getApi());
        this.clsVisitor = clsVisitor;
        this.writer = clsVisitor.getWriter();
        this.closeField = closeField;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        this.closeField = true;
        return RaungAnnotationVisitor.buildAnnotation(this.clsVisitor, descriptor2, visible);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, String descriptor2, boolean visible) {
        this.closeField = true;
        return RaungAnnotationVisitor.buildTypeAnnotation(this.clsVisitor, typeRef, typePath, descriptor2, visible);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.closeField = true;
        this.writer.startLine("# TODO: field attribute: " + attribute);
    }

    @Override
    public void visitEnd() {
        this.writer.decreaseIndent();
        if (this.closeField) {
            this.writer.startLine(".end field");
        }
    }
}

